/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.upnp.basedriver.export;

import java.io.File;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.felix.upnp.basedriver.Activator;
import org.apache.felix.upnp.basedriver.export.BuildDevice;
import org.apache.felix.upnp.basedriver.export.DeviceNode;
import org.apache.felix.upnp.basedriver.export.ExporterUPnPEventListener;
import org.apache.felix.upnp.basedriver.export.GeneralActionListener;
import org.apache.felix.upnp.basedriver.export.RootDeviceExportingQueue;
import org.cybergarage.upnp.Device;
import org.cybergarage.upnp.DeviceList;
import org.cybergarage.upnp.ServiceList;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ThreadExporter
implements Runnable,
ServiceListener {
    private boolean end = false;
    private RootDeviceExportingQueue queueRootDevice;
    private Hashtable exportedDevices;
    private boolean listening;
    static /* synthetic */ Class class$org$osgi$service$upnp$UPnPDevice;
    static /* synthetic */ Class class$org$osgi$service$upnp$UPnPEventListener;

    public ThreadExporter(RootDeviceExportingQueue queue) throws InvalidSyntaxException {
        this.queueRootDevice = queue;
        this.exportedDevices = new Hashtable();
        this.setListening(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        File osgiRoot = Activator.bc.getDataFile("");
        if (osgiRoot == null) {
            Activator.logger.ERROR("Unable to use filesystem");
            while (true) {
                try {
                    Activator.bc.getBundle().stop();
                }
                catch (BundleException e) {
                    e.printStackTrace();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                    continue;
                }
                break;
            }
            return;
        }
        ServiceReference rootDevice = null;
        while (!this.shouldEnd()) {
            DeviceNode dn = this.queueRootDevice.getRootDevice();
            if (dn == null) continue;
            rootDevice = dn.getReference();
            if (!this.getListening()) {
                this.setListen();
            }
            Activator.logger.INFO("[Exporter] Exporting device " + rootDevice.getProperty("UPnP.device.friendlyName"));
            ThreadExporter threadExporter = this;
            synchronized (threadExporter) {
                Device d = BuildDevice.createCyberLinkDevice(dn.getReference());
                if (d != null) {
                    if (!this.bindInvokes(d, rootDevice)) {
                        Activator.logger.DEBUG("Unable to find all the sub device or to set action listener");
                        continue;
                    }
                    ServiceRegistration listenReg = this.bindSubscribe(d);
                    if (listenReg == null) {
                        Activator.logger.DEBUG("Unable to set action listener event listener");
                        continue;
                    }
                    d.start();
                    this.exportedDevices.put(rootDevice.getProperty("UPnP.device.UDN"), new ExportedDeviceInfo(d, listenReg, dn));
                }
            }
        }
    }

    private void setListen() {
        try {
            Activator.bc.addServiceListener((ServiceListener)this, "(&(objectClass=" + (class$org$osgi$service$upnp$UPnPDevice == null ? (class$org$osgi$service$upnp$UPnPDevice = ThreadExporter.class$("org.osgi.service.upnp.UPnPDevice")) : class$org$osgi$service$upnp$UPnPDevice).getName() + ")" + "(" + "UPnP.export" + "=*))");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
    }

    private boolean bindInvokes(Device d, ServiceReference rootDevice) {
        this.bindInvoke(d, rootDevice);
        ServiceReference[] childs = null;
        try {
            childs = Activator.bc.getServiceReferences((class$org$osgi$service$upnp$UPnPDevice == null ? (class$org$osgi$service$upnp$UPnPDevice = ThreadExporter.class$("org.osgi.service.upnp.UPnPDevice")) : class$org$osgi$service$upnp$UPnPDevice).getName(), "(UPnP.device.parentUDN=" + rootDevice.getProperty("UPnP.device.UDN") + ")");
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        String[] childsUDN = (String[])rootDevice.getProperty("UPnP.device.childrenUDN");
        if (childs == null && childsUDN == null) {
            return true;
        }
        if (childs == null || childsUDN == null) {
            return false;
        }
        if (childs.length == childsUDN.length) {
            DeviceList dl = d.getDeviceList();
            for (int i = 0; i < childs.length; ++i) {
                Device dev = (Device)dl.elementAt(i);
                if (this.bindInvokes(dev, childs[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private ServiceRegistration bindSubscribe(Device d) {
        ExporterUPnPEventListener eventer = new ExporterUPnPEventListener(d);
        Properties p = new Properties();
        StringBuffer sb = new StringBuffer("(|");
        Vector<Device> v = new Vector<Device>();
        v.add(d);
        while (v.size() != 0) {
            Device current = (Device)v.elementAt(0);
            v.remove(0);
            DeviceList dl = current.getDeviceList();
            for (int i = 0; i < dl.size(); ++i) {
                v.add((Device)dl.elementAt(i));
            }
            sb.append("(").append("UPnP.device.UDN").append("=").append(current.getUDN()).append(")");
        }
        sb.append(")");
        Filter f = null;
        try {
            f = Activator.bc.createFilter(sb.toString());
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
            return null;
        }
        if (f != null) {
            p.put("upnp.filter", f);
        }
        return Activator.bc.registerService((class$org$osgi$service$upnp$UPnPEventListener == null ? (class$org$osgi$service$upnp$UPnPEventListener = ThreadExporter.class$("org.osgi.service.upnp.UPnPEventListener")) : class$org$osgi$service$upnp$UPnPEventListener).getName(), (Object)eventer, (Dictionary)p);
    }

    private boolean bindInvoke(Device upnpDev, ServiceReference osgiDev) {
        ServiceList sl = upnpDev.getServiceList();
        int l = sl.size();
        for (int i = 0; i < l; ++i) {
            sl.getService(i).setActionListener(new GeneralActionListener(osgiDev, sl.getService(i).getServiceID()));
        }
        return true;
    }

    public synchronized void cleanUp() {
        Activator.logger.INFO("Cleaning...");
        Activator.logger.INFO("Removing temporary listener....");
        Enumeration keys = this.exportedDevices.keys();
        while (keys.hasMoreElements()) {
            ServiceRegistration sr = ((ExportedDeviceInfo)this.exportedDevices.get(keys.nextElement())).getServiceRegistration();
            sr.unregister();
        }
        Activator.logger.INFO("Done");
        Activator.logger.INFO("Removing device....");
        keys = this.exportedDevices.keys();
        while (keys.hasMoreElements()) {
            Device dev = ((ExportedDeviceInfo)this.exportedDevices.get(keys.nextElement())).getDevice();
            dev.stop();
        }
        Activator.logger.INFO("Done");
    }

    private synchronized boolean shouldEnd() {
        return this.end;
    }

    public synchronized void end() {
        this.end = true;
        this.queueRootDevice.addRootDevice(null);
    }

    public void serviceChanged(ServiceEvent event) {
        switch (event.getType()) {
            case 1: {
                break;
            }
            case 2: 
            case 4: {
                this.unexportDevice(event.getServiceReference());
                if (this.exportedDevices.size() != 0) break;
                Activator.bc.removeServiceListener((ServiceListener)this);
                this.setListening(false);
            }
        }
    }

    private synchronized void setListening(boolean b) {
        this.listening = b;
    }

    private synchronized boolean getListening() {
        return this.listening;
    }

    private synchronized void unexportDevice(ServiceReference dev) {
        String udn = (String)dev.getProperty("UPnP.device.parentUDN");
        if (udn == null) {
            ServiceRegistration srListener;
            ExportedDeviceInfo edi = (ExportedDeviceInfo)this.exportedDevices.get(dev.getProperty("UPnP.device.UDN"));
            Device d = edi.getDevice();
            if (d != null) {
                Activator.logger.INFO("[Exporter] removing device:" + d.getFriendlyName());
                d.stop();
                this.exportedDevices.remove(d.getUDN());
            }
            if ((srListener = edi.getServiceRegistration()) != null) {
                srListener.unregister();
            }
        } else {
            ServiceReference[] servs = null;
            try {
                servs = Activator.bc.getServiceReferences((class$org$osgi$service$upnp$UPnPDevice == null ? (class$org$osgi$service$upnp$UPnPDevice = ThreadExporter.class$("org.osgi.service.upnp.UPnPDevice")) : class$org$osgi$service$upnp$UPnPDevice).getName(), "(UPnP.device.UDN=" + udn + ")");
            }
            catch (InvalidSyntaxException ignored) {
                // empty catch block
            }
            if (servs == null) {
                return;
            }
            this.unexportDevice((ServiceReference)servs[0]);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ExportedDeviceInfo {
        private Device device;
        private ServiceRegistration serviceRegistration;

        private ExportedDeviceInfo(Device device, ServiceRegistration serviceRegistration, DeviceNode deviceNode) {
            this.device = device;
            this.serviceRegistration = serviceRegistration;
        }

        private Device getDevice() {
            return this.device;
        }

        private ServiceRegistration getServiceRegistration() {
            return this.serviceRegistration;
        }
    }
}

