/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.plugin;

import aQute.bnd.build.ReflectAction;
import aQute.bnd.plugin.Central;
import aQute.bnd.service.action.Action;
import aQute.lib.osgi.Processor;
import java.io.File;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "aQute.bmaker";
    private static Activator plugin;
    BundleContext context;
    Central central;
    static volatile boolean busy;

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.context = context;
        this.central = new Central(context);
        Hashtable p = new Hashtable();
        context.registerService(Action.class.getName(), (Object)new ReflectAction(""), p);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        this.central.close();
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public void error(final String msg, final Throwable t) {
        Status s = new Status(4, PLUGIN_ID, 0, msg, t);
        this.getLog().log((IStatus)s);
        this.async(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (busy) {
                        return;
                    }
                    busy = true;
                }
                Status s = new Status(4, Activator.PLUGIN_ID, 0, "", null);
                ErrorDialog.openError(null, (String)"Errors during bundle generation", (String)(String.valueOf(msg) + " " + t.getMessage()), (IStatus)s);
                busy = false;
            }
        });
    }

    public void info(String msg) {
        Status s = new Status(1, PLUGIN_ID, 0, msg, null);
        this.getLog().log((IStatus)s);
    }

    public void error(List<String> errors) {
        final StringBuffer sb = new StringBuffer();
        for (String msg : errors) {
            sb.append(msg);
            sb.append("\n");
        }
        this.async(new Runnable(){

            public void run() {
                Status s = new Status(4, Activator.PLUGIN_ID, 0, "", null);
                ErrorDialog.openError(null, (String)"Errors during bundle generation", (String)sb.toString(), (IStatus)s);
            }
        });
    }

    public void message(final String msg) {
        this.async(new Runnable(){

            public void run() {
                MessageDialog.openInformation(null, (String)"Bnd", (String)msg);
            }
        });
    }

    public void warning(List<String> errors) {
        final StringBuffer sb = new StringBuffer();
        for (String msg : errors) {
            sb.append(msg);
            sb.append("\n");
        }
        this.async(new Runnable(){

            public void run() {
                Status s = new Status(2, Activator.PLUGIN_ID, 0, "", null);
                ErrorDialog.openError(null, (String)"Warnings during bundle generation", (String)sb.toString(), (IStatus)s);
            }
        });
    }

    void async(Runnable run) {
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(run);
        } else {
            run.run();
        }
    }

    public boolean getReportDone() {
        return true;
    }

    public File getCopy() {
        return null;
    }

    public boolean isPedantic() {
        return false;
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    public void report(boolean warnings, boolean acknowledge, Processor reporter, final String title, final String extra) {
        if (reporter.getErrors().size() > 0 || warnings && reporter.getWarnings().size() > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("\n");
            if (reporter.getErrors().size() > 0) {
                sb.append("[Errors]\n");
                for (String msg : reporter.getErrors()) {
                    sb.append(msg);
                    sb.append("\n");
                }
            }
            sb.append("\n");
            if (reporter.getWarnings().size() > 0) {
                sb.append("[Warnings]\n");
                for (String msg : reporter.getWarnings()) {
                    sb.append(msg);
                    sb.append("\n");
                }
            }
            final Status s = new Status(4, PLUGIN_ID, 0, sb.toString(), null);
            reporter.clear();
            this.async(new Runnable(){

                public void run() {
                    ErrorDialog.openError(null, (String)title, (String)(String.valueOf(title) + "\n" + extra), (IStatus)s);
                }
            });
        } else {
            this.message(String.valueOf(title) + " : ok");
        }
    }

    public Central getCentral() {
        return this.central;
    }
}

