/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.libsync;

import aQute.lib.osgi.Constants;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Processor;
import aQute.lib.osgi.Resource;
import aQute.lib.osgi.Verifier;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibSync
extends Processor {
    URL url;

    public LibSync() {
    }

    public LibSync(Processor parent) {
        super(parent);
    }

    public void submit(Jar jar) throws Exception {
        String host = this.getProperty("libsync.repo", "http://libsync.com/repo");
        try {
            URL url = new URL(host);
            Verifier v = new Verifier(jar);
            v.setPedantic(true);
            v.verify();
            this.getInfo(v);
            if (this.isOk() && v.getWarnings().isEmpty()) {
                this.send0(jar, url);
            }
        }
        catch (MalformedURLException e) {
            this.error("The libsync.repo property does not contain a proper URL %s, exception: %s", host, e);
        }
        catch (Exception e) {
            this.error("Submission of %s to %s failed even after retrying", host, jar.getName());
        }
    }

    Jar send0(Jar jar, URL url) throws Exception {
        int retries = Integer.parseInt(this.getProperty("libsync.retries", "3"));
        int i = 0;
        while (i < retries - 1) {
            try {
                return this.send1(jar, url);
            }
            catch (Exception e) {
                this.warning("Submission failed %s, will retry (%d times defined in libsync.retries)", e, retries);
                Thread.sleep(i * 1000);
                ++i;
            }
        }
        return this.send1(jar, url);
    }

    Jar send1(Jar jar, URL url) throws Exception {
        HttpURLConnection urlc = (HttpURLConnection)url.openConnection();
        urlc.setDoOutput(true);
        urlc.setDoInput(true);
        this.trace("Connecting to: %s", url);
        urlc.setRequestMethod("POST");
        urlc.setRequestProperty("Content-Type", "application/binary");
        urlc.connect();
        OutputStream out = urlc.getOutputStream();
        try {
            jar.write(out);
        }
        finally {
            out.close();
        }
        this.trace("Submitted: %s to %s", jar.getName(), url);
        InputStream in = urlc.getInputStream();
        try {
            Jar result = new Jar(url.toExternalForm(), in);
            this.addClose(result);
            this.trace("Received: %s", result.getName());
            Resource errors = result.getResource("META-INF/errors");
            Resource warnings = result.getResource("META-INF/warnings");
            if (errors != null) {
                this.parse(errors.openInputStream(), url.getFile(), this.getErrors());
            }
            if (warnings != null) {
                this.parse(warnings.openInputStream(), url.getFile(), this.getWarnings());
            }
            Jar jar2 = result;
            return jar2;
        }
        finally {
            in.close();
        }
    }

    private void parse(InputStream in, String prefix, List<String> to) throws Exception {
        try {
            InputStreamReader r = new InputStreamReader(in, Constants.DEFAULT_CHARSET);
            BufferedReader br = new BufferedReader(r);
            String line = br.readLine();
            while (line != null) {
                to.add(String.valueOf(prefix) + line);
                line = br.readLine();
            }
        }
        finally {
            in.close();
        }
    }
}

