<!---
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
-->

# Governance

The current PMC and committers are listed in the [Apache Phonebook].

[apache phonebook]: https://projects.apache.org/committee.html?datafusion

## Overview

DataFusion is part of the [Apache Software Foundation] and is governed following
the [Apache Way] and [project management guidelines], [independently of
commercial interests].

[apache software foundation]: https://www.apache.org/
[apache way]: https://www.apache.org/theapacheway/
[project management guidelines]: https://www.apache.org/foundation/how-it-works.html#management
[independently of commercial interests]: https://community.apache.org/projectIndependence.html

As much as practicable, we strive to make decisions by consensus, and anyone in
the community is encouraged to propose ideas, start discussions, and contribute
to the project.

## Roles

- **Contributors**: Anyone who contributes to the project, whether it be code,
  documentation, testing, issue reports, code, or some other forms.

- **Committers**: Contributors who have been granted write access to the  
  project's source code repository. Committers are responsible for reviewing and
  merging pull requests. Committers are chosen by the PMC.

- **Project Management Committee (PMC)**: The PMC is responsible for the
  oversight of the project. The PMC is responsible for making decisions about the
  project, including the addition of new committers and PMC members. The PMC is
  also responsible for [voting] on releases and ensuring that the project follows
  the [Apache Way].

[voting]: https://www.apache.org/foundation/voting.html

## Becoming a Committer

Contributors with sustained, high-quality activity may be invited to become
committers by the PMC as a recognition of their contribution to the project and
their shared commitment. Committers have the significant responsibility of using
their status and access to improve the project for the entire community.

When considering inviting someone to be a committer, the PMC looks for
contributors who are already doing the work and exercising the judgment expected
of a committer. After all, any contributor can do all of the things a committer
does except for merge a PR. While there is no set list of requirements, nor a
checklist that entitles one to commit privileges, typical behaviors include:

- Contributions beyond pull requests, such as reviewing other pull requests,
  fixing bugs and documentation, triaging issues, answering community questions,
  improving usability, helping with CI, verifying releases, etc.

- Contributions that are consistent in quality and sustained
  over time, typically on the order of 6 months or more.

- Assistance growing the size and health of the community via constructive,
  respectful, and consensus driven interactions, as described in our [Code of
  Conduct] and the [Apache Way].

If you feel you should be offered committer privileges, but have not been, you
can reach out to one of the PMC members or the private@datafusion.apache.org mailing
list.

[code of conduct]: https://www.apache.org/foundation/policies/conduct.html

## Becoming a PMC Member

Committers with long term sustained contributions to the project may be invited
to join the PMC. This is a recognition of a significant contribution to growing
the community, improving the project, and helping to guide the project's
direction, typically over the course of a year or more.
