/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.pools;

import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Supplier;

public abstract class Pool<T> {
    private final Queue<T> internalPool;
    private final Consumer<T> cleaner;
    private final Supplier<T> supplier;

    public Pool(int maxSize, Consumer<T> cleaner, Supplier<T> supplier) {
        this.internalPool = this.createQueue(maxSize);
        this.cleaner = cleaner;
        this.supplier = supplier;
    }

    abstract Queue<T> createQueue(int var1);

    public final T borrow() {
        if (this.internalPool == null) {
            return this.supplier.get();
        }
        T returnObject = this.internalPool.poll();
        if (returnObject == null) {
            returnObject = this.supplier.get();
        } else {
            this.cleaner.accept(returnObject);
        }
        return returnObject;
    }

    public final void release(T object) {
        if (this.internalPool != null) {
            this.internalPool.offer(object);
        }
    }

    public final int size() {
        if (this.internalPool != null) {
            return this.internalPool.size();
        }
        return 0;
    }
}

