/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.processors.idl;

import antlr.collections.AST;
import java.io.File;
import javax.wsdl.Definition;
import org.apache.cxf.tools.corba.processors.idl.ConstVisitor;
import org.apache.cxf.tools.corba.processors.idl.ExceptionVisitor;
import org.apache.cxf.tools.corba.processors.idl.ModuleVisitor;
import org.apache.cxf.tools.corba.processors.idl.PortTypeVisitor;
import org.apache.cxf.tools.corba.processors.idl.Scope;
import org.apache.cxf.tools.corba.processors.idl.TypeDclVisitor;
import org.apache.cxf.tools.corba.processors.idl.VisitorBase;
import org.apache.cxf.tools.corba.processors.idl.WSDLASTVisitor;
import org.apache.ws.commons.schema.XmlSchema;

public class DefinitionVisitor
extends VisitorBase {
    public DefinitionVisitor(Scope scope, Definition defn, XmlSchema schemaRef, WSDLASTVisitor wsdlVisitor) {
        super(scope, defn, schemaRef, wsdlVisitor);
    }

    @Override
    public void visit(AST node) {
        switch (node.getType()) {
            case 8: 
            case 9: {
                System.out.println("Valuetypes not supported");
                System.exit(1);
                break;
            }
            case 11: {
                ModuleVisitor moduleVisitor = new ModuleVisitor(this.getScope(), this.definition, this.schema, this.wsdlVisitor);
                moduleVisitor.visit(node);
                break;
            }
            case 7: {
                Definition newDefinition = this.createDefinition(null);
                PortTypeVisitor portTypeVisitor = new PortTypeVisitor(this.getScope(), newDefinition, this.schema, this.wsdlVisitor);
                portTypeVisitor.visit(node);
                break;
            }
            case 67: {
                XmlSchema newSchema = this.createSchema();
                Definition newDefinition = this.createDefinition(newSchema);
                ExceptionVisitor exceptionVisitor = new ExceptionVisitor(this.getScope(), newDefinition, newSchema, this.wsdlVisitor);
                exceptionVisitor.visit(node);
                break;
            }
            case 26: {
                XmlSchema newSchema = this.createSchema();
                ConstVisitor constVisitor = new ConstVisitor(this.getScope(), this.definition, newSchema, this.wsdlVisitor);
                constVisitor.visit(node);
                break;
            }
            default: {
                XmlSchema newSchema = this.createSchema();
                TypeDclVisitor typeDclVisitor = new TypeDclVisitor(this.getScope(), this.definition, newSchema, this.wsdlVisitor);
                typeDclVisitor.visit(node);
            }
        }
    }

    private XmlSchema createSchema() {
        String tns = this.mapper.map(this.getScope());
        XmlSchema xmlSchema = this.schema;
        if (tns != null && (xmlSchema = this.manager.getXmlSchema(tns)) == null) {
            xmlSchema = this.manager.createXmlSchema(tns, this.schemas);
        }
        return xmlSchema;
    }

    private Definition createDefinition(XmlSchema schema) {
        String tns = this.mapper.map(this.getScope());
        Definition defn = this.definition;
        if (tns != null && (defn = this.manager.getWSDLDefinition(tns)) == null) {
            try {
                defn = this.manager.createWSDLDefinition(tns);
                String key = this.getScope().toString("_");
                String fileName = this.getWsdlVisitor().getOutputDir() + System.getProperty("file.separator") + key;
                this.manager.addWSDLDefinitionImport(this.definition, defn, key, fileName);
                if (schema == null) {
                    schema = this.manager.getXmlSchema(tns);
                }
                if (schema != null) {
                    this.manager.addWSDLSchemaImport(defn, tns, fileName);
                    this.manager.getImportedXmlSchemas().put(new File(fileName + ".xsd"), schema);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return defn;
    }
}

