/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.jmx;

import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.RequiredModelMBean;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.ManagedBus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.management.ManagedComponent;
import org.apache.cxf.management.jmx.export.runtime.ModelMBeanAssembler;

public class InstrumentationManagerImpl
implements InstrumentationManager,
BusLifeCycleListener {
    private static final Logger LOG = LogUtils.getL7dLogger(InstrumentationManagerImpl.class);
    private static Map<String, String> mbeanServerIDMap = new HashMap<String, String>();
    private Bus bus;
    private MBeanServer mbs;
    private Set<ObjectName> busMBeans = new HashSet<ObjectName>();
    private boolean connectFailed;
    private String persistentBusId;
    private String mbeanServerName = "org.apache.cxf";
    private boolean usePlatformMBeanServer;
    private boolean enabled;

    public InstrumentationManagerImpl() {
    }

    public InstrumentationManagerImpl(Bus bus) {
        this();
        this.readJMXProperties(bus);
        this.bus = bus;
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setBus(Bus bus) {
        if (this.bus == null) {
            this.readJMXProperties(bus);
        } else {
            InstrumentationManager im = (InstrumentationManager)bus.getExtension(InstrumentationManager.class);
            if (this != im) {
                bus.setExtension((Object)this, InstrumentationManager.class);
                try {
                    ManagedBus mbus = new ManagedBus(bus);
                    im.unregister((ManagedComponent)mbus);
                    if (LOG.isLoggable(Level.INFO)) {
                        LOG.info("unregistered " + String.valueOf(mbus.getObjectName()));
                    }
                }
                catch (JMException jMException) {
                    // empty catch block
                }
            }
        }
        this.bus = bus;
    }

    public void setServerName(String s) {
        this.mbeanServerName = s;
    }

    public void setUsePlatformMBeanServer(Boolean flag) {
        this.usePlatformMBeanServer = flag;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Deprecated
    public void register() {
    }

    @PostConstruct
    public void init() {
        if (this.bus != null && this.bus.getExtension(MBeanServer.class) != null) {
            this.enabled = true;
            this.mbs = (MBeanServer)this.bus.getExtension(MBeanServer.class);
        }
        if (this.isEnabled()) {
            if (this.mbs == null) {
                if (this.usePlatformMBeanServer) {
                    this.mbs = ManagementFactory.getPlatformMBeanServer();
                } else {
                    String mbeanServerID = mbeanServerIDMap.get(this.mbeanServerName);
                    List servers = null;
                    if (mbeanServerID != null) {
                        servers = CastUtils.cast(MBeanServerFactory.findMBeanServer(mbeanServerID));
                    }
                    if (servers == null || servers.isEmpty()) {
                        this.mbs = MBeanServerFactory.createMBeanServer(this.mbeanServerName);
                        try {
                            mbeanServerID = (String)this.mbs.getAttribute(this.getDelegateName(), "MBeanServerId");
                            mbeanServerIDMap.put(this.mbeanServerName, mbeanServerID);
                        }
                        catch (JMException jMException) {}
                    } else {
                        this.mbs = (MBeanServer)servers.get(0);
                    }
                }
            }
            if (!this.connectFailed && null != this.bus) {
                try {
                    ManagedBus mbus = new ManagedBus(this.bus);
                    this.register((ManagedComponent)mbus);
                    if (LOG.isLoggable(Level.INFO)) {
                        LOG.info("registered " + String.valueOf(mbus.getObjectName()));
                    }
                }
                catch (JMException jmex) {
                    LOG.log(Level.SEVERE, "REGISTER_FAILURE_MSG", new Object[]{this.bus, jmex});
                }
            }
        }
        if (null != this.bus) {
            this.bus.setExtension((Object)this, InstrumentationManager.class);
            BusLifeCycleManager blcm = (BusLifeCycleManager)this.bus.getExtension(BusLifeCycleManager.class);
            if (null != blcm) {
                blcm.registerLifeCycleListener((BusLifeCycleListener)this);
            }
        }
    }

    private ObjectName getDelegateName() throws JMException {
        try {
            return (ObjectName)MBeanServerDelegate.class.getField("DELEGATE_NAME").get(null);
        }
        catch (Throwable throwable) {
            try {
                return new ObjectName("JMImplementation:type=MBeanServerDelegate");
            }
            catch (MalformedObjectNameException e) {
                JMException jme = new JMException(e.getMessage());
                jme.initCause(e);
                throw jme;
            }
        }
    }

    public void register(Object obj, ObjectName name) throws JMException {
        this.register(obj, name, false);
    }

    public void register(Object obj, ObjectName name, boolean forceRegistration) throws JMException {
        if (!this.isEnabled() || this.connectFailed) {
            return;
        }
        try {
            this.registerMBeanWithServer(obj, this.persist(name), forceRegistration);
        }
        catch (NotCompliantMBeanException e) {
            ModelMBeanAssembler assembler = new ModelMBeanAssembler();
            ModelMBeanInfo mbi = assembler.getModelMbeanInfo(obj.getClass());
            this.register(obj, name, mbi, forceRegistration);
        }
    }

    public ObjectName register(ManagedComponent i) throws JMException {
        return this.register(i, false);
    }

    public ObjectName register(ManagedComponent i, boolean forceRegistration) throws JMException {
        ObjectName name = i.getObjectName();
        this.register(i, name, forceRegistration);
        return name;
    }

    public void unregister(ManagedComponent component) throws JMException {
        ObjectName name = component.getObjectName();
        this.unregister(this.persist(name));
    }

    public void unregister(ObjectName name) throws JMException {
        if (!this.isEnabled() || this.connectFailed) {
            return;
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("unregistering MBean " + String.valueOf(name));
        }
        this.busMBeans.remove(name);
        this.mbs.unregisterMBean(name);
    }

    public MBeanServer getMBeanServer() {
        return this.mbs;
    }

    public void setServer(MBeanServer server) {
        this.mbs = server;
    }

    public void shutdown() {
        Object[] mBeans;
        if (!this.isEnabled()) {
            return;
        }
        for (Object name : mBeans = this.busMBeans.toArray()) {
            this.busMBeans.remove(name);
            try {
                this.unregister((ObjectName)name);
            }
            catch (JMException jmex) {
                LOG.log(Level.SEVERE, "UNREGISTER_FAILURE_MSG", new Object[]{name, jmex});
            }
        }
    }

    public void initComplete() {
    }

    public void preShutdown() {
    }

    public void postShutdown() {
        this.shutdown();
    }

    private void register(Object obj, ObjectName name, ModelMBeanInfo mbi, boolean forceRegistration) throws JMException {
        RequiredModelMBean rtMBean = (RequiredModelMBean)this.mbs.instantiate("javax.management.modelmbean.RequiredModelMBean");
        rtMBean.setModelMBeanInfo(mbi);
        try {
            rtMBean.setManagedResource(obj, "ObjectReference");
        }
        catch (InvalidTargetObjectTypeException itotex) {
            throw new JMException(itotex.getMessage());
        }
        this.registerMBeanWithServer(rtMBean, this.persist(name), forceRegistration);
    }

    private void registerMBeanWithServer(Object obj, ObjectName name, boolean forceRegistration) throws JMException {
        ObjectInstance instance;
        try {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("registering MBean " + String.valueOf(name) + ": " + String.valueOf(obj));
            }
            instance = this.mbs.registerMBean(obj, name);
        }
        catch (InstanceAlreadyExistsException e) {
            if (forceRegistration) {
                this.mbs.unregisterMBean(name);
                instance = this.mbs.registerMBean(obj, name);
            }
            throw e;
        }
        if (instance != null) {
            this.busMBeans.add(name);
        }
    }

    public String getPersistentBusId() {
        return this.persistentBusId;
    }

    public void setPersistentBusId(String id) {
        this.persistentBusId = this.sanitize(id);
    }

    private ObjectName persist(ObjectName original) throws JMException {
        String originalStr;
        ObjectName persisted = original;
        if (this.persistentBusId != null && !"".equals(this.persistentBusId) && !this.persistentBusId.startsWith("${") && (originalStr = original.toString()).indexOf("bus.id") != -1) {
            String persistedStr = originalStr.replaceFirst("bus.id=" + this.bus.getId(), "bus.id=" + this.persistentBusId);
            persisted = new ObjectName(persistedStr);
        }
        return persisted;
    }

    private String sanitize(String in) {
        StringBuilder str = new StringBuilder(in.length());
        block3: for (int x = 0; x < in.length(); ++x) {
            char ch = in.charAt(x);
            switch (ch) {
                case ',': 
                case '/': 
                case ':': 
                case '=': 
                case '?': 
                case '\\': {
                    str.append('_');
                    continue block3;
                }
                default: {
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }

    private void readJMXProperties(Bus b) {
        if (b != null) {
            this.persistentBusId = InstrumentationManagerImpl.getBusProperty(b, "bus.jmx.persistentBusId", this.persistentBusId);
            this.mbeanServerName = InstrumentationManagerImpl.getBusProperty(b, "bus.jmx.serverName", this.mbeanServerName);
            this.usePlatformMBeanServer = InstrumentationManagerImpl.getBusProperty(b, "bus.jmx.usePlatformMBeanServer", this.usePlatformMBeanServer);
            this.enabled = InstrumentationManagerImpl.getBusProperty(b, "bus.jmx.enabled", this.enabled);
        }
    }

    private static String getBusProperty(Bus b, String key, String dflt) {
        String v = (String)b.getProperty(key);
        return v != null ? v : dflt;
    }

    private static boolean getBusProperty(Bus b, String key, boolean dflt) {
        Object v = b.getProperty(key);
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        return v != null ? Boolean.valueOf(v.toString()) : dflt;
    }
}

