/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.jna;

import com.sun.jna.Function;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeLong;
import com.sun.jna.ptr.PointerByReference;
import java.nio.ByteBuffer;
import org.apache.commons.crypto.jna.OpenSsl10XNativeJna;
import org.apache.commons.crypto.jna.OpenSsl11XNativeJna;
import org.apache.commons.crypto.jna.OpenSsl20XNativeJna;
import org.apache.commons.crypto.jna.OpenSslInterfaceNativeJna;
import org.apache.commons.crypto.jna.OpenSslJna;

final class OpenSslNativeJna {
    static final int OPENSSL_INIT_ENGINE_RDRAND = 512;
    static final int OOSL_JNA_ENCRYPT_MODE = 1;
    static final int OOSL_JNA_DECRYPT_MODE = 0;
    static final boolean INIT_OK;
    static final Throwable INIT_ERROR;
    static final long VERSION;
    static final long VERSION_X_Y;
    static final long VERSION_1_0_X = 0x10000000L;
    static final long VERSION_1_1_X = 0x10100000L;
    static final long VERSION_2_0_X = 0x20000000L;
    static final long VERSION_3_0_X = 0x30000000L;
    private static final OpenSslInterfaceNativeJna JnaImplementation;

    static {
        OpenSslJna.debug("OpenSslNativeJna static init start", new Object[0]);
        String libraryName = System.getProperty("commons.crypto." + OpenSslNativeJna.class.getSimpleName(), "crypto");
        OpenSslJna.debug("OpenSslNativeJna NativeLibrary.getInstance('%s')", libraryName);
        NativeLibrary crypto = NativeLibrary.getInstance((String)libraryName);
        OpenSslJna.debug("OpenSslNativeJna NativeLibrary.getInstance('%s') -> %s", libraryName, crypto);
        Function versionFunction = null;
        try {
            versionFunction = crypto.getFunction("SSLeay");
        }
        catch (UnsatisfiedLinkError e) {
            versionFunction = crypto.getFunction("OpenSSL_version_num");
        }
        VERSION = versionFunction.invokeLong(new Object[0]);
        OpenSslJna.debug(String.format("OpenSslNativeJna detected version 0x%x", VERSION), new Object[0]);
        VERSION_X_Y = VERSION & 0xFFFFFFFFFFFF0000L;
        if (VERSION_X_Y == 0x10000000L) {
            OpenSslJna.debug("Creating OpenSsl10XNativeJna", new Object[0]);
            JnaImplementation = new OpenSsl10XNativeJna();
        } else if (VERSION_X_Y == 0x10100000L) {
            OpenSslJna.debug("Creating OpenSsl11XNativeJna", new Object[0]);
            JnaImplementation = new OpenSsl11XNativeJna();
        } else if (VERSION_X_Y == 0x20000000L) {
            OpenSslJna.debug("Creating OpenSsl20XNativeJna", new Object[0]);
            JnaImplementation = new OpenSsl20XNativeJna();
        } else {
            OpenSslJna.debug("Creating OpenSsl10XNativeJna", new Object[0]);
            JnaImplementation = new OpenSsl10XNativeJna();
        }
        INIT_OK = JnaImplementation._INIT_OK();
        INIT_ERROR = INIT_OK ? null : JnaImplementation._INIT_ERROR();
        OpenSslJna.debug("OpenSslNativeJna INIT_OK = %s, INIT_ERROR = '%s', JnaImplementation = %s", INIT_OK, INIT_ERROR, JnaImplementation.getClass());
        OpenSslJna.debug("OpenSslNativeJna static init end", new Object[0]);
    }

    public static PointerByReference ENGINE_by_id(String string) {
        return JnaImplementation._ENGINE_by_id(string);
    }

    public static int ENGINE_cleanup() {
        return JnaImplementation._ENGINE_cleanup();
    }

    public static int ENGINE_finish(PointerByReference rdrandEngine) {
        return JnaImplementation._ENGINE_finish(rdrandEngine);
    }

    public static int ENGINE_free(PointerByReference rdrandEngine) {
        return JnaImplementation._ENGINE_free(rdrandEngine);
    }

    public static int ENGINE_init(PointerByReference rdrandEngine) {
        return JnaImplementation._ENGINE_init(rdrandEngine);
    }

    public static void ENGINE_load_rdrand() {
        JnaImplementation._ENGINE_load_rdrand();
    }

    public static int ENGINE_set_default(PointerByReference rdrandEngine, int eNGINE_METHOD_RAND) {
        return JnaImplementation._ENGINE_set_default(rdrandEngine, eNGINE_METHOD_RAND);
    }

    public static String ERR_error_string(NativeLong err, char[] object) {
        return JnaImplementation._ERR_error_string(err, null);
    }

    public static NativeLong ERR_peek_error() {
        return JnaImplementation._ERR_peek_error();
    }

    public static PointerByReference EVP_aes_128_cbc() {
        return JnaImplementation._EVP_aes_128_cbc();
    }

    public static PointerByReference EVP_aes_128_ctr() {
        return JnaImplementation._EVP_aes_128_ctr();
    }

    public static PointerByReference EVP_aes_192_cbc() {
        return JnaImplementation._EVP_aes_192_cbc();
    }

    public static PointerByReference EVP_aes_192_ctr() {
        return JnaImplementation._EVP_aes_192_ctr();
    }

    public static PointerByReference EVP_aes_256_cbc() {
        return JnaImplementation._EVP_aes_256_cbc();
    }

    public static PointerByReference EVP_aes_256_ctr() {
        return JnaImplementation._EVP_aes_256_ctr();
    }

    public static void EVP_CIPHER_CTX_cleanup(PointerByReference context) {
        JnaImplementation._EVP_CIPHER_CTX_cleanup(context);
    }

    public static void EVP_CIPHER_CTX_free(PointerByReference context) {
        JnaImplementation._EVP_CIPHER_CTX_free(context);
    }

    public static PointerByReference EVP_CIPHER_CTX_new() {
        return JnaImplementation._EVP_CIPHER_CTX_new();
    }

    public static int EVP_CIPHER_CTX_set_padding(PointerByReference context, int padding) {
        return JnaImplementation._EVP_CIPHER_CTX_set_padding(context, padding);
    }

    public static int EVP_CipherFinal_ex(PointerByReference context, ByteBuffer outBuffer, int[] outlen) {
        return JnaImplementation._EVP_CipherFinal_ex(context, outBuffer, outlen);
    }

    public static int EVP_CipherInit_ex(PointerByReference context, PointerByReference algo, Object object, byte[] encoded, byte[] iv, int cipherMode) {
        return JnaImplementation._EVP_CipherInit_ex(context, algo, null, encoded, iv, cipherMode);
    }

    public static int EVP_CipherUpdate(PointerByReference context, ByteBuffer outBuffer, int[] outlen, ByteBuffer inBuffer, int remaining) {
        return JnaImplementation._EVP_CipherUpdate(context, outBuffer, outlen, inBuffer, remaining);
    }

    public static String OpenSSLVersion(int i) {
        return JnaImplementation._OpenSSL_version(i);
    }

    public static int RAND_bytes(ByteBuffer buf, int length) {
        return JnaImplementation._RAND_bytes(buf, length);
    }

    public static PointerByReference RAND_get_rand_method() {
        return JnaImplementation._RAND_get_rand_method();
    }

    public static PointerByReference RAND_SSLeay() {
        return JnaImplementation._RAND_SSLeay();
    }

    private OpenSslNativeJna() {
    }
}

