/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.jna;

import com.sun.jna.NativeLong;
import com.sun.jna.ptr.PointerByReference;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Objects;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.crypto.cipher.CryptoCipher;
import org.apache.commons.crypto.jna.OpenSslJna;
import org.apache.commons.crypto.jna.OpenSslNativeJna;
import org.apache.commons.crypto.utils.Transformation;

final class OpenSslJnaCipher
implements CryptoCipher {
    private PointerByReference algo;
    private final PointerByReference context;
    private final AlgorithmMode algorithmMode;
    private final int padding;
    private final String transformation;
    private final int IV_LENGTH = 16;

    public OpenSslJnaCipher(Properties props, String transformation) throws GeneralSecurityException {
        if (!OpenSslJna.isEnabled()) {
            throw new GeneralSecurityException("Could not enable JNA access", OpenSslJna.initialisationError());
        }
        this.transformation = transformation;
        Transformation transform = Transformation.parse(transformation);
        this.algorithmMode = AlgorithmMode.get(transform.getAlgorithm(), transform.getMode());
        if (this.algorithmMode != AlgorithmMode.AES_CBC && this.algorithmMode != AlgorithmMode.AES_CTR) {
            throw new GeneralSecurityException("Unknown algorithm " + transform.getAlgorithm() + "_" + transform.getMode());
        }
        this.padding = transform.getPadding().ordinal();
        this.context = OpenSslNativeJna.EVP_CIPHER_CTX_new();
    }

    @Override
    public void close() {
        if (this.context != null) {
            OpenSslNativeJna.EVP_CIPHER_CTX_cleanup(this.context);
        }
    }

    @Override
    public int doFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        ByteBuffer outputBuf = ByteBuffer.wrap(output, outputOffset, output.length - outputOffset);
        ByteBuffer inputBuf = ByteBuffer.wrap(input, inputOffset, inputLen);
        return this.doFinal(inputBuf, outputBuf);
    }

    @Override
    public int doFinal(ByteBuffer inBuffer, ByteBuffer outBuffer) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int uptLen = this.update(inBuffer, outBuffer);
        int[] outlen = new int[1];
        this.throwOnError(OpenSslNativeJna.EVP_CipherFinal_ex(this.context, outBuffer, outlen));
        int len = uptLen + outlen[0];
        outBuffer.position(outBuffer.position() + outlen[0]);
        return len;
    }

    protected void finalize() throws Throwable {
        OpenSslNativeJna.EVP_CIPHER_CTX_free(this.context);
        super.finalize();
    }

    @Override
    public String getAlgorithm() {
        return this.transformation;
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    @Override
    public void init(int mode, Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] iv;
        int cipherMode;
        block13: {
            int keyEncodedLength;
            block12: {
                Objects.requireNonNull(key, "key");
                Objects.requireNonNull(params, "params");
                int n = cipherMode = mode == 1 ? 1 : 0;
                if (!(params instanceof IvParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("Illegal parameters");
                }
                iv = ((IvParameterSpec)params).getIV();
                if ((this.algorithmMode == AlgorithmMode.AES_CBC || this.algorithmMode == AlgorithmMode.AES_CTR) && iv.length != 16) {
                    throw new InvalidAlgorithmParameterException("Wrong IV length: must be 16 bytes long");
                }
                keyEncodedLength = key.getEncoded().length;
                if (this.algorithmMode != AlgorithmMode.AES_CBC) break block12;
                switch (keyEncodedLength) {
                    case 16: {
                        this.algo = OpenSslNativeJna.EVP_aes_128_cbc();
                        break block13;
                    }
                    case 24: {
                        this.algo = OpenSslNativeJna.EVP_aes_192_cbc();
                        break block13;
                    }
                    case 32: {
                        this.algo = OpenSslNativeJna.EVP_aes_256_cbc();
                        break block13;
                    }
                    default: {
                        throw new InvalidKeyException("keysize unsupported (" + keyEncodedLength + ")");
                    }
                }
            }
            switch (keyEncodedLength) {
                case 16: {
                    this.algo = OpenSslNativeJna.EVP_aes_128_ctr();
                    break;
                }
                case 24: {
                    this.algo = OpenSslNativeJna.EVP_aes_192_ctr();
                    break;
                }
                case 32: {
                    this.algo = OpenSslNativeJna.EVP_aes_256_ctr();
                    break;
                }
                default: {
                    throw new InvalidKeyException("keysize unsupported (" + keyEncodedLength + ")");
                }
            }
        }
        this.throwOnError(OpenSslNativeJna.EVP_CipherInit_ex(this.context, this.algo, null, key.getEncoded(), iv, cipherMode));
        this.throwOnError(OpenSslNativeJna.EVP_CIPHER_CTX_set_padding(this.context, this.padding));
    }

    private void throwOnError(int retVal) {
        if (retVal != 1) {
            NativeLong err = OpenSslNativeJna.ERR_peek_error();
            String errdesc = OpenSslNativeJna.ERR_error_string(err, null);
            if (this.context != null) {
                OpenSslNativeJna.EVP_CIPHER_CTX_cleanup(this.context);
            }
            throw new IllegalStateException("return code " + retVal + " from OpenSSL. Err code is " + err + ": " + errdesc);
        }
    }

    @Override
    public int update(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        ByteBuffer outputBuf = ByteBuffer.wrap(output, outputOffset, output.length - outputOffset);
        ByteBuffer inputBuf = ByteBuffer.wrap(input, inputOffset, inputLen);
        return this.update(inputBuf, outputBuf);
    }

    @Override
    public int update(ByteBuffer inBuffer, ByteBuffer outBuffer) throws ShortBufferException {
        int[] outlen = new int[1];
        this.throwOnError(OpenSslNativeJna.EVP_CipherUpdate(this.context, outBuffer, outlen, inBuffer, inBuffer.remaining()));
        int len = outlen[0];
        inBuffer.position(inBuffer.limit());
        outBuffer.position(outBuffer.position() + len);
        return len;
    }

    @Override
    public void updateAAD(byte[] aad) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        throw new UnsupportedOperationException("This is unsupported in Jna Cipher");
    }

    @Override
    public void updateAAD(ByteBuffer aad) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        throw new UnsupportedOperationException("This is unsupported in Jna Cipher");
    }

    private static enum AlgorithmMode {
        AES_CTR,
        AES_CBC;


        static AlgorithmMode get(String algorithm, String mode) throws NoSuchAlgorithmException {
            try {
                return AlgorithmMode.valueOf(String.valueOf(algorithm) + "_" + mode);
            }
            catch (Exception e) {
                throw new NoSuchAlgorithmException("Algorithm not supported: " + algorithm + " and mode: " + mode);
            }
        }
    }
}

