/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.view.swing;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.scopemvc.controller.basic.ViewContext;
import org.scopemvc.controller.swing.SwingContext;
import org.scopemvc.core.Control;
import org.scopemvc.core.Controller;
import org.scopemvc.core.View;
import org.scopemvc.view.swing.SwingSubView;
import org.scopemvc.view.swing.SwingUtil;

public abstract class SwingView
extends JPanel
implements View {
    public static final String VIEW_TYPE = "swing";
    public static final int PRIMARY_WINDOW = 0;
    public static final int MODAL_DIALOG = 1;
    public static final int MODELESS_DIALOG = 2;
    public static final Rectangle CENTRED = new Rectangle();
    private static final Log LOG = LogFactory.getLog(class$org$scopemvc$view$swing$SwingView == null ? (class$org$scopemvc$view$swing$SwingView = SwingView.class$("org.scopemvc.view.swing.SwingView")) : class$org$scopemvc$view$swing$SwingView);
    private List subViews = null;
    private Rectangle viewBounds;
    private int displayMode = 0;
    private String title = "Untitled";
    private JMenuBar menuBar;
    private Control closeControl = new Control("_HIDE_VIEW", this);
    private JButton defaultButton;
    private Controller controller;
    static /* synthetic */ Class class$org$scopemvc$view$swing$SwingView;

    public SwingView() {
        if (ViewContext.getViewContext() == null || !(ViewContext.getViewContext() instanceof SwingContext)) {
            ViewContext.clearThreadContext();
            ViewContext.setGlobalContext(new SwingContext());
        }
    }

    public final Rectangle getViewBounds() {
        return this.viewBounds;
    }

    public final Rectangle getLastShownBounds() {
        return this.getViewBounds();
    }

    public String getTitle() {
        return this.title;
    }

    public int getDisplayMode() {
        return this.displayMode;
    }

    public Control getCloseControl() {
        return this.closeControl;
    }

    public boolean isResizable() {
        return true;
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    public Controller getController() {
        return this.controller;
    }

    public void issueControl(Control control) {
        SwingUtil.issueControl(this, control);
    }

    public int getSubViewCount() {
        if (this.subViews != null) {
            return this.subViews.size();
        }
        return 0;
    }

    public SwingSubView getSubView(int n) {
        if (this.subViews != null && n < this.subViews.size()) {
            return (SwingSubView)this.subViews.get(n);
        }
        return null;
    }

    public JButton getDefaultButton() {
        return this.defaultButton;
    }

    public final void setController(Controller controller) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("setController: " + controller);
        }
        this.controller = controller;
    }

    public void setCloseControl(Control control) {
        this.closeControl = control;
    }

    public void setCloseControl(String string) {
        this.closeControl = new Control(string, this);
    }

    public void setDisplayMode(int n) {
        this.displayMode = n;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setViewBounds(Rectangle rectangle) {
        this.viewBounds = rectangle;
    }

    public void setLastShownBounds(Rectangle rectangle) {
        this.setViewBounds(rectangle);
    }

    public void setMenuBar(JMenuBar jMenuBar) {
        this.menuBar = jMenuBar;
    }

    public void setDefaultButton(JButton jButton) {
        this.defaultButton = jButton;
        SwingContext swingContext = (SwingContext)SwingContext.getViewContext();
        JRootPane jRootPane = swingContext.findRootPaneFor(this);
        if (jRootPane != null) {
            jRootPane.setDefaultButton(this.defaultButton);
        }
    }

    public String toString() {
        return this.getClass().toString() + "(" + this.getTitle() + ")";
    }

    public void addSubView(SwingSubView swingSubView) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("addSubView: subView: " + swingSubView);
        }
        if (this.subViews == null) {
            this.subViews = new ArrayList();
        }
        if (!this.subViews.contains(swingSubView)) {
            this.subViews.add(swingSubView);
            swingSubView.setOwner(this);
        }
    }

    public void removeSubView(SwingSubView swingSubView) {
        if (this.subViews == null || swingSubView.getOwner() != this) {
            return;
        }
        this.subViews.remove(swingSubView);
        swingSubView.unsetOwner(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

