/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog;

import java.awt.Component;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class UnsavedChangesDialog {
    private static final String SAVE_AND_CLOSE = "Save Changes";
    private static final String CLOSE_WITHOUT_SAVE = "Discard Changes";
    private static final String CANCEL = "Cancel";
    private static final String[] OPTIONS = new String[]{"Save Changes", "Discard Changes", "Cancel"};
    protected Component parent;
    protected String result = "Cancel";

    public UnsavedChangesDialog(Component parent) {
        this.parent = parent;
    }

    public void show() {
        JOptionPane pane = new JOptionPane("You have unsaved changes. Do you want to save them?", 3);
        pane.setOptions(OPTIONS);
        JDialog dialog = pane.createDialog(this.parent, "Unsaved Changes");
        dialog.setVisible(true);
        Object selectedValue = pane.getValue();
        this.result = SAVE_AND_CLOSE.equals(selectedValue) ? SAVE_AND_CLOSE : (CLOSE_WITHOUT_SAVE.equals(selectedValue) ? CLOSE_WITHOUT_SAVE : CANCEL);
    }

    public boolean shouldSave() {
        return SAVE_AND_CLOSE.equals(this.result);
    }

    public boolean shouldNotSave() {
        return CLOSE_WITHOUT_SAVE.equals(this.result);
    }

    public boolean shouldCancel() {
        return this.result == null || CANCEL.equals(this.result);
    }
}

