/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.dbsync;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.DbGenerator;
import org.apache.cayenne.access.dbsync.ThrowOnPartialSchemaStrategy;
import org.apache.cayenne.map.DataMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrowOnPartialOrCreateSchemaStrategy
extends ThrowOnPartialSchemaStrategy {
    static final Log logger = LogFactory.getLog(ThrowOnPartialOrCreateSchemaStrategy.class);

    @Override
    protected void processSchemaUpdate(DataNode dataNode, List<String> mergerOnlyTable, String errorMessage, int entitiesSize) {
        if (mergerOnlyTable.size() == 0 && errorMessage == null) {
            logger.info("Full schema is present");
        } else if (mergerOnlyTable.size() == entitiesSize) {
            logger.info("No schema detected, will create mapped tables");
            this.generate(dataNode);
        } else {
            logger.info("Error - partial schema detected");
            StringBuilder buffer = new StringBuilder("Schema mismatch detected");
            if (errorMessage != null) {
                buffer.append(": ").append(errorMessage);
            } else if (mergerOnlyTable.size() > 0) {
                buffer.append(": missing table '").append(mergerOnlyTable.get(0)).append('\'');
            }
            throw new CayenneRuntimeException(buffer.toString());
        }
    }

    private void generate(DataNode dataNode) {
        Collection<DataMap> map = dataNode.getDataMaps();
        Iterator<DataMap> iterator = map.iterator();
        while (iterator.hasNext()) {
            DbGenerator gen = new DbGenerator(dataNode.getAdapter(), iterator.next());
            gen.setShouldCreateTables(true);
            gen.setShouldDropTables(false);
            gen.setShouldCreateFKConstraints(false);
            gen.setShouldCreatePKSupport(false);
            gen.setShouldDropPKSupport(false);
            try {
                gen.runGenerator(dataNode.getDataSource());
            }
            catch (Exception e) {
                throw new CayenneRuntimeException(e);
            }
        }
    }
}

