/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validator;

import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.project.validator.TreeNodeValidator;
import org.apache.cayenne.project.validator.Validator;
import org.apache.cayenne.util.Util;

public class DataMapValidator
extends TreeNodeValidator {
    public void validateObject(ProjectPath path, Validator validator) {
        DataMap map = (DataMap)path.getObject();
        this.validateName(map, path, validator);
        this.validateNodeLinks(map, path, validator);
    }

    protected void validateNodeLinks(DataMap map, ProjectPath path, Validator validator) {
        DataDomain domain = (DataDomain)path.getObjectParent();
        if (domain == null) {
            return;
        }
        boolean unlinked = true;
        int nodeCount = 0;
        for (DataNode node : domain.getDataNodes()) {
            ++nodeCount;
            if (!node.getDataMaps().contains(map)) continue;
            unlinked = false;
            break;
        }
        if (unlinked && nodeCount > 0) {
            validator.registerWarning("DataMap is not linked to any DataNodes.", path);
        }
    }

    protected void validateName(DataMap map, ProjectPath path, Validator validator) {
        String name = map.getName();
        if (Util.isEmptyString(name)) {
            validator.registerError("Unnamed DataMap.", path);
            return;
        }
        DataDomain domain = (DataDomain)path.getObjectParent();
        if (domain == null) {
            return;
        }
        for (DataMap otherMap : domain.getDataMaps()) {
            if (otherMap == map || !name.equals(otherMap.getName())) continue;
            validator.registerError("Duplicate DataMap name: " + name + ".", path);
            return;
        }
    }
}

