/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.select;

import java.sql.ResultSet;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.access.select.RowReader;
import org.apache.cayenne.access.select.ScalarRowReader;
import org.apache.cayenne.access.select.SelectColumn;
import org.apache.cayenne.access.select.SelectDescriptor;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ScalarSegment
implements SelectDescriptor<Object>,
SelectColumn {
    private String columnName;
    private RowReader<Object> rowReader;

    ScalarSegment(String columnName, ExtendedType converter) {
        this.columnName = columnName;
        this.rowReader = new ScalarRowReader(converter, Integer.MAX_VALUE);
    }

    @Override
    public List<SelectColumn> getColumns() {
        return Collections.singletonList(this);
    }

    @Override
    public RowReader<Object> getRowReader(ResultSet resultSet) {
        return this.rowReader;
    }

    @Override
    public String getColumnName(DbEntity unionRoot, String tableAlias) {
        if (tableAlias == null || tableAlias.length() == 0) {
            return this.columnName;
        }
        return tableAlias + '.' + this.columnName;
    }

    @Override
    public int getJdbcType() {
        return Integer.MAX_VALUE;
    }

    @Override
    public String getDataRowKey() {
        throw new UnsupportedOperationException("'dataRowKey' is meaningless for Scalar segments");
    }

    @Override
    public List<DbRelationship> getPath(DbEntity unionRoot) {
        throw new UnsupportedOperationException("'getPath' is unsupported for Scalar segments");
    }
}

