/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Collection;
import java.util.Collections;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.ParentAttachmentStrategy;
import org.apache.cayenne.access.PrefetchProcessorNode;
import org.apache.cayenne.graph.GraphManager;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.reflect.ClassDescriptor;

class JoinedIdParentAttachementStrategy
implements ParentAttachmentStrategy {
    private String relatedIdPrefix;
    private Collection<ObjEntity> sourceEntities;
    private PrefetchProcessorNode node;
    private GraphManager graphManager;

    JoinedIdParentAttachementStrategy(GraphManager graphManager, PrefetchProcessorNode node) {
        ClassDescriptor parentDescriptor = ((PrefetchProcessorNode)node.getParent()).getResolver().getDescriptor();
        this.relatedIdPrefix = node.getIncoming().getRelationship().getReverseDbRelationshipPath() + ".";
        this.sourceEntities = parentDescriptor.getEntityInheritanceTree() == null ? Collections.singletonList(parentDescriptor.getEntity()) : parentDescriptor.getEntityInheritanceTree().allSubEntities();
        this.node = node;
        this.graphManager = graphManager;
    }

    public void linkToParent(DataRow row, Persistent object) {
        Persistent parentObject = null;
        for (ObjEntity entity : this.sourceEntities) {
            if (entity.isAbstract()) continue;
            ObjectId id = this.node.getResolver().createObjectId(row, entity, this.relatedIdPrefix);
            if (id == null) {
                throw new CayenneRuntimeException("Can't build ObjectId from row: " + row + ", entity: " + entity.getName() + ", prefix: " + this.relatedIdPrefix);
            }
            parentObject = (Persistent)this.graphManager.getNode(id);
            if (parentObject == null) continue;
            break;
        }
        this.node.linkToParent(object, parentObject);
    }
}

