/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.modeler.util.ProgressDialog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class LongRunningTask {
    private static Log logObj = LogFactory.getLog(LongRunningTask.class);
    protected static final int DEFAULT_MS_TO_DECIDE_TO_POPUP = 500;
    protected ProgressDialog dialog;
    protected JFrame frame;
    protected String title;
    protected Timer taskPollingTimer;
    protected boolean canceled;
    protected int minValue;
    protected int maxValue;
    protected boolean finished;

    public LongRunningTask(JFrame frame, String title) {
        this.frame = frame;
        this.title = title;
    }

    public synchronized void startAndWait() {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new CayenneRuntimeException("Can't block EventDispatchThread. Call 'startAndWait' from another thread.");
        }
        this.start();
        if (this.finished) {
            return;
        }
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            this.setCanceled(true);
        }
        this.notifyAll();
    }

    public void start() {
        this.setCanceled(false);
        this.finished = false;
        Thread task = new Thread(new Runnable(){

            public void run() {
                LongRunningTask.this.internalExecute();
            }
        });
        Timer progressDisplayTimer = new Timer(500, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LongRunningTask.this.showProgress();
            }
        });
        progressDisplayTimer.setRepeats(false);
        progressDisplayTimer.start();
        task.start();
    }

    protected synchronized void showProgress() {
        logObj.debug((Object)"will show progress...");
        if (this.finished) {
            return;
        }
        int currentValue = this.getCurrentValue();
        if (!this.isCanceled() && currentValue < this.getMaxValue()) {
            logObj.debug((Object)"task still in progress, will show progress dialog...");
            this.dialog = new ProgressDialog(this.frame, "Progress...", this.title);
            this.dialog.getCancelButton().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LongRunningTask.this.setCanceled(true);
                }
            });
            this.dialog.getProgressBar().setMinimum(this.getMinValue());
            this.dialog.getProgressBar().setMaximum(this.getMaxValue());
            this.updateProgress();
            this.taskPollingTimer = new Timer(500, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LongRunningTask.this.updateProgress();
                }
            });
            this.taskPollingTimer.start();
            this.dialog.setVisible(true);
        }
    }

    protected void updateProgress() {
        if (this.isCanceled()) {
            this.stop();
            return;
        }
        this.dialog.getStatusLabel().setText(this.getCurrentNote());
        JProgressBar progressBar = this.dialog.getProgressBar();
        if (!this.isIndeterminate()) {
            progressBar.setValue(this.getCurrentValue());
            progressBar.setIndeterminate(false);
        } else {
            progressBar.setIndeterminate(true);
        }
    }

    protected synchronized void stop() {
        if (this.taskPollingTimer != null) {
            this.taskPollingTimer.stop();
        }
        if (this.dialog != null) {
            this.dialog.dispose();
        }
        this.finished = true;
        this.notifyAll();
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean b) {
        if (b) {
            logObj.debug((Object)"task canceled");
        }
        this.canceled = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalExecute() {
        try {
            this.execute();
        }
        catch (Throwable th) {
            this.setCanceled(true);
            logObj.warn((Object)"task error", th);
        }
        finally {
            this.stop();
        }
    }

    protected abstract void execute();

    protected abstract String getCurrentNote();

    protected abstract int getCurrentValue();

    protected abstract boolean isIndeterminate();

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
    }
}

