/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.action.CreateAttributeAction;
import org.apache.cayenne.modeler.action.RemoveAttributeAction;
import org.apache.cayenne.modeler.event.EmbeddableDisplayEvent;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.undo.CayenneUndoableEdit;

public class RemoveAttributeUndoableEdit
extends CayenneUndoableEdit {
    private DataDomain domain;
    private DataMap dataMap;
    private DbAttribute[] dbAttributes;
    private ObjAttribute[] objAttributes;
    private ObjEntity objEntity;
    private DbEntity dbEntity;
    private Embeddable embeddable;
    private EmbeddableAttribute[] embeddableAttrs;

    public RemoveAttributeUndoableEdit(Embeddable embeddable, EmbeddableAttribute[] embeddableAttrs) {
        this.embeddable = embeddable;
        this.embeddableAttrs = embeddableAttrs;
    }

    public RemoveAttributeUndoableEdit(DataDomain domain, DataMap dataMap, ObjEntity entity, ObjAttribute[] attribs) {
        this.objEntity = entity;
        this.objAttributes = attribs;
        this.domain = domain;
        this.dataMap = dataMap;
    }

    public RemoveAttributeUndoableEdit(DataDomain domain, DataMap dataMap, DbEntity entity, DbAttribute[] attribs) {
        this.dbEntity = entity;
        this.dbAttributes = attribs;
        this.domain = domain;
        this.dataMap = dataMap;
    }

    public void redo() throws CannotRedoException {
        RemoveAttributeAction action = (RemoveAttributeAction)this.actionManager.getAction(RemoveAttributeAction.getActionName());
        if (this.objEntity != null) {
            action.removeObjAttributes(this.objEntity, this.objAttributes);
            this.controller.fireObjEntityDisplayEvent(new EntityDisplayEvent((Object)this, (Entity)this.objEntity, this.dataMap, this.domain));
        }
        if (this.dbEntity != null) {
            action.removeDbAttributes(this.dbEntity.getDataMap(), this.dbEntity, this.dbAttributes);
            this.controller.fireDbEntityDisplayEvent(new EntityDisplayEvent((Object)this, (Entity)this.dbEntity, this.dataMap, this.domain));
        }
        if (this.embeddable != null) {
            action.removeEmbeddableAttributes(this.embeddable, this.embeddableAttrs);
            this.controller.fireEmbeddableDisplayEvent(new EmbeddableDisplayEvent((Object)this, this.embeddable, this.dataMap, this.domain));
        }
    }

    public void undo() throws CannotUndoException {
        CreateAttributeAction action = (CreateAttributeAction)this.actionManager.getAction(CreateAttributeAction.getActionName());
        if (this.objEntity != null) {
            for (ObjAttribute objAttribute : this.objAttributes) {
                action.createObjAttribute(this.domain, this.dataMap, this.objEntity, objAttribute);
            }
        }
        if (this.dbEntity != null) {
            for (ObjAttribute objAttribute : this.dbAttributes) {
                action.createDbAttribute(this.domain, this.dataMap, this.dbEntity, (DbAttribute)objAttribute);
            }
        }
        if (this.embeddable != null) {
            for (ObjAttribute objAttribute : this.embeddableAttrs) {
                action.createEmbAttribute(this.embeddable, (EmbeddableAttribute)objAttribute);
            }
        }
    }

    public String getPresentationName() {
        if (this.objEntity != null) {
            return this.objAttributes.length > 1 ? "Remove ObjAttributes" : "Remove ObjAttribute";
        }
        if (this.dbEntity != null) {
            return this.dbAttributes.length > 1 ? "Remove DbAttributes" : "Remove DbAttribute";
        }
        if (this.embeddableAttrs != null) {
            return this.embeddableAttrs.length > 1 ? "Remove Embeddable Attributes" : "Remove Embeddable Attribute";
        }
        return super.getPresentationName();
    }
}

