/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.objectstyle.ashwood.graph.layout.LayerVertex;

public class Layer
extends ArrayList {
    private int rank;

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public LayerVertex getVertex(int index) {
        return (LayerVertex)this.get(index);
    }

    public Object getUserVertex(int index) {
        return this.getVertex(index).getUserVertex();
    }

    public void sort() {
        Collections.sort(this, LayerVertex.LAYER_INDEX_COMPARATOR);
        boolean indicesCorrect = this.checkIndices();
        if (!indicesCorrect) {
            System.out.println("indices failed: rank=" + this.rank);
            for (int i = 0; i < this.size(); ++i) {
                LayerVertex v = this.getVertex(i);
                String sgLabel = v.getParentSubgraph() != null ? v.getParentSubgraph().getLabel() : "?";
                System.out.print(sgLabel + "." + v + "{" + v.getIndexInLayer() + "}, ");
            }
            System.out.println();
        }
    }

    public void sort(Comparator comparator) {
        Collections.sort(this, comparator);
        this.refreshIndices();
    }

    public void refreshIndices() {
        for (int i = 0; i < this.size(); ++i) {
            this.getVertex(i).setIndexInLayer(i);
        }
    }

    public boolean checkIndices() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.getVertex(i).getIndexInLayer() == i) continue;
            return false;
        }
        return true;
    }

    public boolean add(LayerVertex vertex) {
        vertex.setIndexInLayer(this.size());
        vertex.setRank(this.rank);
        return super.add(vertex);
    }

    public boolean add(Object vertex) {
        return this.add((LayerVertex)vertex);
    }

    public LayerVertex getLeft(LayerVertex vertex) {
        int index = vertex.getIndexInLayer();
        return index > 0 ? this.getVertex(index - 1) : null;
    }

    public LayerVertex getRight(LayerVertex vertex) {
        int index = vertex.getIndexInLayer();
        return index < this.size() - 1 ? this.getVertex(index + 1) : null;
    }

    public boolean isFirst(LayerVertex vertex) {
        return vertex.getIndexInLayer() == 0;
    }

    public boolean isLast(LayerVertex vertex) {
        return vertex.getIndexInLayer() == this.size() - 1;
    }
}

