/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.endpoints;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.regions.PartitionMetadata;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.RegionMetadata;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.internal.BucketUtils;
import software.amazon.awssdk.services.s3.internal.ConfiguredS3SdkHttpRequest;
import software.amazon.awssdk.services.s3.internal.endpoints.S3EndpointResolver;
import software.amazon.awssdk.services.s3.internal.endpoints.S3EndpointResolverContext;
import software.amazon.awssdk.services.s3.internal.endpoints.S3EndpointUtils;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.StringUtils;

@SdkInternalApi
public final class S3BucketEndpointResolver
implements S3EndpointResolver {
    private S3BucketEndpointResolver() {
    }

    public static S3BucketEndpointResolver create() {
        return new S3BucketEndpointResolver();
    }

    @Override
    public ConfiguredS3SdkHttpRequest applyEndpointConfiguration(S3EndpointResolverContext context) {
        URI endpoint = S3BucketEndpointResolver.resolveEndpoint(context);
        SdkHttpRequest.Builder mutableRequest = (SdkHttpRequest.Builder)context.request().toBuilder();
        mutableRequest.uri(endpoint);
        String bucketName = context.originalRequest().getValueForField("Bucket", String.class).orElse(null);
        if (S3BucketEndpointResolver.canUseVirtualAddressing(context.serviceConfiguration(), bucketName)) {
            S3BucketEndpointResolver.changeToDnsEndpoint(mutableRequest, bucketName);
        }
        return ConfiguredS3SdkHttpRequest.builder().sdkHttpRequest((SdkHttpRequest)mutableRequest.build()).build();
    }

    private static URI resolveEndpoint(S3EndpointResolverContext context) {
        SdkHttpRequest request = context.request();
        String protocol = request.protocol();
        RegionMetadata regionMetadata = RegionMetadata.of((Region)context.region());
        String dnsSuffixWithoutTagConsideration = regionMetadata != null ? regionMetadata.domain() : PartitionMetadata.of((Region)context.region()).dnsSuffix();
        S3Configuration serviceConfiguration = context.serviceConfiguration();
        boolean useAccelerate = S3EndpointUtils.isAccelerateEnabled(serviceConfiguration) && S3EndpointUtils.isAccelerateSupported(context.originalRequest());
        boolean useDualstack = S3EndpointUtils.isDualstackEnabled(serviceConfiguration);
        boolean useFips = context.fipsEnabled();
        if (useAccelerate && useFips) {
            throw new IllegalStateException("FIPS is not currently supported for S3 accelerate endpoints.");
        }
        if (useAccelerate && useDualstack) {
            return S3EndpointUtils.accelerateDualstackEndpoint(dnsSuffixWithoutTagConsideration, protocol);
        }
        if (useAccelerate) {
            return S3EndpointUtils.accelerateEndpoint(dnsSuffixWithoutTagConsideration, protocol);
        }
        return (URI)FunctionalUtils.invokeSafely(() -> new URI(protocol, null, request.host(), request.port(), null, null, null));
    }

    private static boolean canUseVirtualAddressing(S3Configuration serviceConfiguration, String bucketName) {
        return !S3EndpointUtils.isPathStyleAccessEnabled(serviceConfiguration) && bucketName != null && BucketUtils.isVirtualAddressingCompatibleBucketName(bucketName, false);
    }

    private static void changeToDnsEndpoint(SdkHttpRequest.Builder mutableRequest, String bucketName) {
        if (mutableRequest.host().startsWith("s3")) {
            String newHost = StringUtils.replaceOnce((String)mutableRequest.host(), (String)"s3", (String)(bucketName + ".s3"));
            String newPath = StringUtils.replaceOnce((String)mutableRequest.encodedPath(), (String)("/" + bucketName), (String)"");
            mutableRequest.host(newHost).encodedPath(newPath);
        }
    }
}

