/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidConfigurationValueException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.KeyProviderException;
import org.apache.hadoop.fs.azurebfs.diagnostics.Base64StringConfigurationBasicValidator;
import org.apache.hadoop.fs.azurebfs.services.KeyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleKeyProvider
implements KeyProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleKeyProvider.class);

    @Override
    public String getStorageAccountKey(String accountName, Configuration rawConfig) throws KeyProviderException {
        String key = null;
        try {
            AbfsConfiguration abfsConfig = new AbfsConfiguration(rawConfig, accountName);
            key = abfsConfig.getPasswordString("fs.azure.account.key");
            this.validateStorageAccountKey(key);
        }
        catch (IllegalAccessException | InvalidConfigurationValueException e) {
            throw new KeyProviderException("Failure to initialize configuration", (Throwable)e);
        }
        catch (IOException ioe) {
            LOG.warn("Unable to get key from credential providers. {}", (Throwable)ioe);
        }
        return key;
    }

    private void validateStorageAccountKey(String key) throws InvalidConfigurationValueException {
        Base64StringConfigurationBasicValidator validator = new Base64StringConfigurationBasicValidator("fs.azure.account.key", "", true);
        validator.validate(key);
    }
}

