/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azure.CachedAuthorizerEntry;
import org.apache.hadoop.fs.azure.CachingAuthorizer;
import org.apache.hadoop.fs.azure.RemoteWasbAuthorizerResponse;
import org.apache.hadoop.fs.azure.SecureWasbRemoteCallHelper;
import org.apache.hadoop.fs.azure.WasbAuthorizationException;
import org.apache.hadoop.fs.azure.WasbAuthorizerInterface;
import org.apache.hadoop.fs.azure.WasbRemoteCallException;
import org.apache.hadoop.fs.azure.WasbRemoteCallHelper;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteWasbAuthorizerImpl
implements WasbAuthorizerInterface {
    public static final Logger LOG = LoggerFactory.getLogger(RemoteWasbAuthorizerImpl.class);
    private static final ObjectReader RESPONSE_READER = new ObjectMapper().readerFor(RemoteWasbAuthorizerResponse.class);
    public static final String KEY_REMOTE_AUTH_SERVICE_URLS = "fs.azure.authorization.remote.service.urls";
    private static final String CHECK_AUTHORIZATION_OP = "CHECK_AUTHORIZATION";
    private static final String ACCESS_OPERATION_QUERY_PARAM_NAME = "operation_type";
    private static final String WASB_ABSOLUTE_PATH_QUERY_PARAM_NAME = "wasb_absolute_path";
    private static final String WASB_RESOURCE_OWNER_QUERY_PARAM_NAME = "wasb_resource_owner";
    private static final String AUTHORIZER_HTTP_CLIENT_RETRY_POLICY_ENABLED_KEY = "fs.azure.authorizer.http.retry.policy.enabled";
    private static final String AUTHORIZER_HTTP_CLIENT_RETRY_POLICY_SPEC_SPEC = "fs.azure.authorizer.http.retry.policy.spec";
    private static final String AUTHORIZER_HTTP_CLIENT_RETRY_POLICY_SPEC_DEFAULT = "10,3,100,2";
    private static final String AUTHORIZATION_CACHEENTRY_EXPIRY_PERIOD = "fs.azure.authorization.cacheentry.expiry.period";
    private WasbRemoteCallHelper remoteCallHelper = null;
    private boolean isKerberosSupportEnabled;
    private boolean isSpnegoTokenCacheEnabled;
    private RetryPolicy retryPolicy;
    private String[] commaSeparatedUrls = null;
    private CachingAuthorizer<CachedAuthorizerEntry, Boolean> cache;

    @VisibleForTesting
    public void updateWasbRemoteCallHelper(WasbRemoteCallHelper helper) {
        this.remoteCallHelper = helper;
    }

    @Override
    public void init(Configuration conf) throws IOException {
        LOG.debug("Initializing RemoteWasbAuthorizerImpl instance");
        this.isKerberosSupportEnabled = conf.getBoolean("fs.azure.enable.kerberos.support", false);
        this.isSpnegoTokenCacheEnabled = conf.getBoolean("fs.azure.enable.spnego.token.cache", true);
        this.commaSeparatedUrls = conf.getTrimmedStrings(KEY_REMOTE_AUTH_SERVICE_URLS);
        if (this.commaSeparatedUrls == null || this.commaSeparatedUrls.length <= 0) {
            throw new IOException("fs.azure.authorization.remote.service.urls config not set in configuration.");
        }
        this.retryPolicy = RetryUtils.getMultipleLinearRandomRetry((Configuration)conf, (String)AUTHORIZER_HTTP_CLIENT_RETRY_POLICY_ENABLED_KEY, (boolean)true, (String)AUTHORIZER_HTTP_CLIENT_RETRY_POLICY_SPEC_SPEC, (String)AUTHORIZER_HTTP_CLIENT_RETRY_POLICY_SPEC_DEFAULT);
        this.remoteCallHelper = this.isKerberosSupportEnabled && UserGroupInformation.isSecurityEnabled() ? new SecureWasbRemoteCallHelper(this.retryPolicy, false, this.isSpnegoTokenCacheEnabled) : new WasbRemoteCallHelper(this.retryPolicy);
        this.cache = new CachingAuthorizer(conf.getTimeDuration(AUTHORIZATION_CACHEENTRY_EXPIRY_PERIOD, 5L, TimeUnit.MINUTES), "AUTHORIZATION");
        this.cache.init(conf);
    }

    @Override
    public boolean authorize(String wasbAbsolutePath, String accessType, String resourceOwner) throws IOException {
        if (wasbAbsolutePath.endsWith("-RenamePending.json")) {
            return true;
        }
        CachedAuthorizerEntry cacheKey = new CachedAuthorizerEntry(wasbAbsolutePath, accessType, resourceOwner);
        Boolean cacheresult = this.cache.get(cacheKey);
        if (cacheresult != null) {
            return cacheresult;
        }
        boolean authorizeresult = this.authorizeInternal(wasbAbsolutePath, accessType, resourceOwner);
        this.cache.put(cacheKey, authorizeresult);
        return authorizeresult;
    }

    private boolean authorizeInternal(String wasbAbsolutePath, String accessType, String resourceOwner) throws IOException {
        try {
            String responseBody;
            RemoteWasbAuthorizerResponse authorizerResponse;
            URIBuilder uriBuilder = new URIBuilder();
            uriBuilder.setPath("/CHECK_AUTHORIZATION");
            uriBuilder.addParameter(WASB_ABSOLUTE_PATH_QUERY_PARAM_NAME, wasbAbsolutePath);
            uriBuilder.addParameter(ACCESS_OPERATION_QUERY_PARAM_NAME, accessType);
            if (resourceOwner != null && StringUtils.isNotEmpty((CharSequence)resourceOwner)) {
                uriBuilder.addParameter(WASB_RESOURCE_OWNER_QUERY_PARAM_NAME, resourceOwner);
            }
            if ((authorizerResponse = (RemoteWasbAuthorizerResponse)RESPONSE_READER.readValue(responseBody = this.remoteCallHelper.makeRemoteRequest(this.commaSeparatedUrls, uriBuilder.getPath(), uriBuilder.getQueryParams(), "GET"))) == null) {
                throw new WasbAuthorizationException("RemoteWasbAuthorizerResponse object null from remote call");
            }
            if (authorizerResponse.getResponseCode() == 0) {
                return authorizerResponse.getAuthorizationResult();
            }
            throw new WasbAuthorizationException("Remote authorization service encountered an error " + authorizerResponse.getResponseMessage());
        }
        catch (JsonParseException | JsonMappingException | WasbRemoteCallException ex) {
            throw new WasbAuthorizationException(ex);
        }
    }
}

