/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.AbstractComplexType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.IATypeVisitor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;

public abstract class AbstractCollectionType
extends AbstractComplexType {
    private static final long serialVersionUID = 1L;
    private static final String ITEM_TYPE_FIELD = "itemType";
    private IAType itemType;

    AbstractCollectionType(IAType itemType, String typeName) {
        super(typeName);
        this.itemType = Objects.requireNonNull(itemType);
    }

    public boolean isTyped() {
        return this.itemType != null;
    }

    public IAType getItemType() {
        return this.itemType;
    }

    public void setItemType(IAType itemType) {
        this.itemType = Objects.requireNonNull(itemType);
    }

    @Override
    public IAType getType() {
        return BuiltinType.ALL_TYPE;
    }

    @Override
    public void generateNestedDerivedTypeNames() {
        if (this.itemType.getTypeTag().isDerivedType() && this.itemType.getTypeName() == null) {
            AbstractComplexType nestedType = (AbstractComplexType)this.itemType;
            nestedType.setTypeName(this.getTypeName() + "_Item");
            nestedType.generateNestedDerivedTypeNames();
        }
    }

    @Override
    public boolean containsType(IAType type) {
        return this.isTyped() && this.itemType.getTypeName().equals(type.getTypeName());
    }

    @Override
    public <R, T> R accept(IATypeVisitor<R, T> visitor, T arg) {
        return visitor.visit(this, arg);
    }

    JsonNode convertToJson(IPersistedResourceRegistry registry, Class<? extends IJsonSerializable> clazz, long version) throws HyracksDataException {
        ObjectNode jsonObject = registry.getClassIdentifier(clazz, version);
        this.addToJson(jsonObject);
        jsonObject.set(ITEM_TYPE_FIELD, this.itemType.toJson(registry));
        return jsonObject;
    }

    static IJsonSerializable convertToObject(IPersistedResourceRegistry registry, JsonNode json, boolean ordered) throws HyracksDataException {
        String typeName = json.get("typeName").asText();
        JsonNode itemTypeJson = json.get(ITEM_TYPE_FIELD);
        IAType itemType = (IAType)registry.deserialize(itemTypeJson);
        return ordered ? new AOrderedListType(itemType, typeName) : new AUnorderedListType(itemType, typeName);
    }
}

