/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.base.temporal;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TimeZone;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.temporal.AsterixTemporalTypeParseException;
import org.apache.asterix.om.base.temporal.GregorianCalendarSystem;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class DateTimeFormatUtils {
    private static final GregorianCalendarSystem CAL;
    private static final Charset ENCODING;
    private static final char HOUR_CHAR = 'h';
    private static final char MINUTE_CHAR = 'm';
    private static final char SECOND_CHAR = 's';
    private static final char MILLISECOND_CHAR = 'n';
    private static final char MILLISECOND_CHAR_ALT = 'S';
    private static final char AMPM_CHAR = 'a';
    private static final char TIMEZONE_CHAR = 'z';
    private static final int MAX_HOUR_CHARS = 2;
    private static final int MAX_MINUTE_CHARS = 2;
    private static final int MAX_SECOND_CHARS = 2;
    private static final int MAX_MILLISECOND_CHARS = 3;
    private static final int MAX_AMPM_CHARS = 1;
    private static final int MAX_TIMEZONE_CHARS = 1;
    private static final char YEAR_CHAR = 'Y';
    private static final char QUARTER_CHAR = 'Q';
    private static final char MONTH_CHAR = 'M';
    private static final char DAY_CHAR = 'D';
    private static final char WEEKDAY_CHAR = 'E';
    private static final int MAX_YEAR_CHARS = 4;
    private static final int MAX_QUARTER_CHARS = 2;
    private static final int MAX_MONTH_CHARS = 4;
    private static final int MAX_DAY_CHARS_PARSE = 2;
    private static final int MAX_DAY_CHARS_PRINT = 3;
    private static final int MIN_WEEKDAY_CHAR = 3;
    private static final int MAX_WEEKDAY_CHAR = 4;
    private static final byte[][] MONTH_NAMES;
    private static final byte[][] MONTH_FULL_NAMES;
    private static final byte[][] WEEKDAY_NAMES;
    private static final byte[][] WEEKDAY_FULL_NAMES;
    private static final byte[] UTC_BYTEARRAY;
    private static final byte[] GMT_BYTEARRAY;
    private static final byte[] AM_BYTEARRAY;
    private static final byte[] PM_BYTEARRAY;
    private static final char HYPHEN_CHAR = '-';
    private static final char COLON_CHAR = ':';
    private static final char SOLIDUS_CHAR = '/';
    private static final char PERIOD_CHAR = '.';
    private static final char COMMA_CHAR = ',';
    private static final char T_CHAR = 'T';
    private static final char SKIPPER_CHAR = 'O';
    private static final int MAX_SKIPPER_CHAR = 1;
    private static final byte TO_LOWER_OFFSET = -32;
    private static Comparator<byte[]> byteArrayComparator;
    private static final byte[][] TIMEZONE_IDS;
    private static final TimeZone[] TIMEZONE_VALUES;
    private static final DateTimeFormatUtils INSTANCE;

    public static DateTimeFormatUtils getInstance() {
        return INSTANCE;
    }

    private DateTimeFormatUtils() {
    }

    private int parseFormatField(byte[] format, int formatStart, int formatLength, int formatPointer, char formatChar, int maxAllowedFormatCharCopied) throws AsterixTemporalTypeParseException {
        int formatCharCopies = 0;
        ++formatPointer;
        ++formatCharCopies;
        while (formatPointer < formatLength && format[formatStart + formatPointer] == formatChar) {
            ++formatPointer;
            ++formatCharCopies;
        }
        if (formatCharCopies > maxAllowedFormatCharCopied) {
            throw new AsterixTemporalTypeParseException("The format string for " + formatChar + " is too long: expected no more than " + maxAllowedFormatCharCopied + " but got " + formatCharCopies);
        }
        return formatCharCopies;
    }

    public static boolean byteArrayEqualToString(byte[] barray, int start, int length, byte[] str) {
        if (length != str.length) {
            return false;
        }
        return DateTimeFormatUtils.byteArrayBeingWithString(barray, start, length, str);
    }

    public static boolean byteArrayBeingWithString(byte[] barray, int start, int length, byte[] str) {
        boolean beginWith = true;
        if (length <= str.length) {
            for (int i = 0; i < length; ++i) {
                if (DateTimeFormatUtils.toLower(barray[start + i]) == str[i]) continue;
                beginWith = false;
                break;
            }
        } else {
            beginWith = false;
        }
        return beginWith;
    }

    private int monthIDSearch(byte[] barray, int start, int length, boolean useShortNames) {
        byte[][] monthNames = useShortNames ? MONTH_NAMES : MONTH_FULL_NAMES;
        for (int i = 0; i < monthNames.length; ++i) {
            if (!DateTimeFormatUtils.byteArrayEqualToString(barray, start, length, monthNames[i])) continue;
            return i;
        }
        return -1;
    }

    @Deprecated
    public static int weekdayIDSearchLax(byte[] barray, int start, int length, boolean useShortNames) {
        byte[][] weekdayNames = useShortNames ? WEEKDAY_NAMES : WEEKDAY_FULL_NAMES;
        for (int i = 0; i < weekdayNames.length; ++i) {
            if (!DateTimeFormatUtils.byteArrayBeingWithString(barray, start, length, weekdayNames[i])) continue;
            return i;
        }
        return -1;
    }

    public static int weekdayIDSearch(byte[] barray, int start, int length, boolean useShortNames) {
        byte[][] weekdayNames = useShortNames ? WEEKDAY_NAMES : WEEKDAY_FULL_NAMES;
        for (int i = 0; i < weekdayNames.length; ++i) {
            if (!DateTimeFormatUtils.byteArrayEqualToString(barray, start, length, weekdayNames[i])) continue;
            return i;
        }
        return -1;
    }

    public static TimeZone findTimeZone(byte[] barray, int start, int length) {
        int idx = Arrays.binarySearch(TIMEZONE_IDS, 0, TIMEZONE_IDS.length, Arrays.copyOfRange(barray, start, start + length), byteArrayComparator);
        return idx >= 0 ? TIMEZONE_VALUES[idx] : null;
    }

    private int indexOf(byte[] barray, int start, int length, char c) {
        for (int i = 0; i < length; ++i) {
            if (barray[start + i] != c) continue;
            return i;
        }
        return -1;
    }

    private static byte toLower(byte b) {
        if (b >= 65 && b <= 90) {
            return (byte)(b - -32);
        }
        return b;
    }

    private static byte toUpper(byte b) {
        if (b >= 97 && b <= 122) {
            return (byte)(b + -32);
        }
        return b;
    }

    public boolean parseDateTime(AMutableInt64 outChronon, byte[] data, int dataStart, int dataLength, byte[] format, int formatStart, int formatLength, DateTimeParseMode parseMode, boolean raiseParseDataError) throws AsterixTemporalTypeParseException {
        return this.parseDateTime(outChronon, null, null, null, data, dataStart, dataLength, format, formatStart, formatLength, parseMode, raiseParseDataError, '\u0000', false);
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public boolean parseDateTime(AMutableInt64 outChronon, Mutable<Boolean> outTimeZoneExists, AMutableInt32 outTimeZone, Mutable<Character> dateTimeSeparatorOut, byte[] data, int dataStart, int dataLength, byte[] format, int formatStart, int formatLength, DateTimeParseMode parseMode, boolean raiseParseDataError, char altSeparatorChar, boolean adjustChrononByTimezone) throws AsterixTemporalTypeParseException {
        long chronon;
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int min = 0;
        int sec = 0;
        int ms = 0;
        int timezone = 0;
        boolean timezoneExists = false;
        boolean negativeYear = false;
        int dataStringPointer = 0;
        int formatPointer = 0;
        char separatorChar = '\u0000';
        char lastSeparatorChar = '\u0000';
        char dateTimeSeparatorChar = 'T';
        block33: while (dataStringPointer < dataLength && formatPointer < formatLength) {
            DateTimeProcessState processState;
            int formatCharCopies = 0;
            switch (format[formatStart + formatPointer]) {
                case 89: {
                    processState = DateTimeProcessState.YEAR;
                    int pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'Y', 4);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 81: {
                    processState = DateTimeProcessState.QUARTER;
                    int pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'Q', 2);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 77: {
                    processState = DateTimeProcessState.MONTH;
                    int pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'M', 4);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 68: {
                    processState = DateTimeProcessState.DAY;
                    int pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'D', 2);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 69: {
                    processState = DateTimeProcessState.WEEKDAY;
                    int pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'E', 4);
                    if (pointerMove < 3) {
                        throw new AsterixTemporalTypeParseException(String.format("Expected at least %d '%s' characters but got %d", 3, Character.valueOf('E'), pointerMove));
                    }
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 104: {
                    processState = DateTimeProcessState.HOUR;
                    int pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'h', 2);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 109: {
                    processState = DateTimeProcessState.MINUTE;
                    int pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'm', 2);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 115: {
                    processState = DateTimeProcessState.SECOND;
                    int pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 's', 2);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 110: {
                    processState = DateTimeProcessState.MILLISECOND;
                    int pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'n', 3);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 83: {
                    processState = DateTimeProcessState.MILLISECOND;
                    int pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'S', 3);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 97: {
                    processState = DateTimeProcessState.AMPM;
                    int pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'a', 1);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 122: {
                    processState = DateTimeProcessState.TIMEZONE;
                    int pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'z', 1);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 79: {
                    processState = DateTimeProcessState.SKIPPER;
                    int pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'O', 1);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 32: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 58: 
                case 84: {
                    separatorChar = (char)format[formatStart + formatPointer];
                    processState = DateTimeProcessState.SEPARATOR;
                    ++formatPointer;
                    ++formatCharCopies;
                    while (formatPointer < formatLength && (char)format[formatStart + formatPointer] == separatorChar) {
                        ++formatPointer;
                        ++formatCharCopies;
                    }
                    break;
                }
                default: {
                    throw new AsterixTemporalTypeParseException("Unexpected date format string at " + (formatStart + formatPointer) + ": " + (char)format[formatStart + formatPointer]);
                }
            }
            switch (processState) {
                case YEAR: 
                case QUARTER: 
                case MONTH: 
                case DAY: {
                    if (parseMode != DateTimeParseMode.TIME_ONLY) break;
                    throw new AsterixTemporalTypeParseException("Unexpected date format string when parsing a time value");
                }
                case HOUR: 
                case MINUTE: 
                case SECOND: 
                case MILLISECOND: 
                case AMPM: 
                case TIMEZONE: {
                    if (parseMode != DateTimeParseMode.DATE_ONLY) break;
                    throw new AsterixTemporalTypeParseException("Unexpected time format string when parsing a date value");
                }
            }
            switch (processState) {
                case YEAR: {
                    if (dataStringPointer < dataLength && data[dataStart + dataStringPointer] == 45) {
                        negativeYear = true;
                        ++dataStringPointer;
                    }
                }
                case DAY: {
                    int maxAllowedFormatCharCopies = processState == DateTimeProcessState.YEAR ? 4 : 2;
                    int parsedValue = 0;
                    int processedFieldsCount = 0;
                    for (int i = 0; i < formatCharCopies; ++dataStringPointer, ++processedFieldsCount, ++i) {
                        if (data[dataStart + dataStringPointer] < 48 || data[dataStart + dataStringPointer] > 57) {
                            if (!raiseParseDataError) return false;
                            throw new AsterixTemporalTypeParseException("Unexpected char for year field at " + (dataStart + dataStringPointer) + ": " + data[dataStart + dataStringPointer]);
                        }
                        parsedValue = parsedValue * 10 + (data[dataStart + dataStringPointer] - 48);
                    }
                    while (processedFieldsCount < maxAllowedFormatCharCopies && dataStringPointer < dataLength && data[dataStart + dataStringPointer] >= 48 && data[dataStart + dataStringPointer] <= 57) {
                        parsedValue = parsedValue * 10 + (data[dataStart + dataStringPointer] - 48);
                        ++dataStringPointer;
                        ++processedFieldsCount;
                    }
                    if (processState == DateTimeProcessState.YEAR) {
                        year = parsedValue;
                        if (negativeYear) {
                            year *= -1;
                        }
                        if (month == 0) {
                            month = GregorianCalendarSystem.FIELD_MINS[GregorianCalendarSystem.Fields.MONTH.ordinal()];
                        }
                        if (day != 0) continue block33;
                        day = GregorianCalendarSystem.FIELD_MINS[GregorianCalendarSystem.Fields.DAY.ordinal()];
                        continue block33;
                    }
                    if (parsedValue == 0) {
                        if (!raiseParseDataError) return false;
                        throw new AsterixTemporalTypeParseException("Incorrect day value at " + (dataStart + dataStringPointer));
                    }
                    day = parsedValue;
                    continue block33;
                }
                case QUARTER: {
                    int parsedValue = 0;
                    int processedQuarterFieldsCount = 0;
                    for (int i = 0; i < formatCharCopies; ++dataStringPointer, ++i) {
                        if (data[dataStart + dataStringPointer] < 48 || data[dataStart + dataStringPointer] > 57) {
                            if (!raiseParseDataError) return false;
                            throw new AsterixTemporalTypeParseException("Unexpected char for quarter field at " + (dataStart + dataStringPointer) + ": " + data[dataStart + dataStringPointer]);
                        }
                        parsedValue = parsedValue * 10 + (data[dataStart + dataStringPointer] - 48);
                        if (processedQuarterFieldsCount++ <= 2) continue;
                        if (!raiseParseDataError) return false;
                        throw new AsterixTemporalTypeParseException("Unexpected char for quarter field at " + (dataStart + dataStringPointer) + ": " + data[dataStart + dataStringPointer]);
                    }
                    while (processedQuarterFieldsCount < 2 && dataStringPointer < dataLength && data[dataStart + dataStringPointer] >= 48 && data[dataStart + dataStringPointer] <= 57) {
                        parsedValue = parsedValue * 10 + (data[dataStart + dataStringPointer] - 48);
                        ++dataStringPointer;
                        ++processedQuarterFieldsCount;
                    }
                    if (parsedValue == 0) {
                        if (!raiseParseDataError) return false;
                        throw new AsterixTemporalTypeParseException("Incorrect quarter value at " + (dataStart + dataStringPointer));
                    }
                    month = (parsedValue - 1) * 3 + 1;
                    if (day != 0) continue block33;
                    day = GregorianCalendarSystem.FIELD_MINS[GregorianCalendarSystem.Fields.DAY.ordinal()];
                    continue block33;
                }
                case MONTH: {
                    boolean useShortNames;
                    int processedMonthFieldsCount;
                    int parsedValue;
                    if (formatCharCopies >= 3) {
                        processedMonthFieldsCount = 0;
                        while (dataStringPointer + processedMonthFieldsCount < dataLength && (data[dataStart + dataStringPointer + processedMonthFieldsCount] >= 97 && data[dataStart + dataStringPointer + processedMonthFieldsCount] <= 122 || data[dataStart + dataStringPointer + processedMonthFieldsCount] >= 65 && data[dataStart + dataStringPointer + processedMonthFieldsCount] <= 90)) {
                            ++processedMonthFieldsCount;
                        }
                        useShortNames = formatCharCopies == 3;
                        int monthNameMatch = this.monthIDSearch(data, dataStart + dataStringPointer, processedMonthFieldsCount, useShortNames);
                        if (monthNameMatch < 0) {
                            if (!raiseParseDataError) return false;
                            throw new AsterixTemporalTypeParseException("Unrecognizable month string " + (char)data[dataStart + dataStringPointer] + " " + (char)data[dataStart + dataStringPointer + 1] + " " + (char)data[dataStart + dataStringPointer + 2]);
                        }
                        month = monthNameMatch + 1;
                        dataStringPointer += processedMonthFieldsCount;
                    } else {
                        parsedValue = 0;
                        processedMonthFieldsCount = 0;
                        for (int i = 0; i < formatCharCopies; ++dataStringPointer, ++i) {
                            if (data[dataStart + dataStringPointer] < 48 || data[dataStart + dataStringPointer] > 57) {
                                if (!raiseParseDataError) return false;
                                throw new AsterixTemporalTypeParseException("Unexpected char for month field at " + (dataStart + dataStringPointer) + ": " + data[dataStart + dataStringPointer]);
                            }
                            parsedValue = parsedValue * 10 + (data[dataStart + dataStringPointer] - 48);
                            if (processedMonthFieldsCount++ <= 2) continue;
                            if (!raiseParseDataError) return false;
                            throw new AsterixTemporalTypeParseException("Unexpected char for month field at " + (dataStart + dataStringPointer) + ": " + data[dataStart + dataStringPointer]);
                        }
                        while (processedMonthFieldsCount < 2 && dataStringPointer < dataLength && data[dataStart + dataStringPointer] >= 48 && data[dataStart + dataStringPointer] <= 57) {
                            parsedValue = parsedValue * 10 + (data[dataStart + dataStringPointer] - 48);
                            ++dataStringPointer;
                            ++processedMonthFieldsCount;
                        }
                        if (parsedValue == 0) {
                            if (!raiseParseDataError) return false;
                            throw new AsterixTemporalTypeParseException("Incorrect month value at " + (dataStart + dataStringPointer));
                        }
                        month = parsedValue;
                    }
                    if (day != 0) continue block33;
                    day = GregorianCalendarSystem.FIELD_MINS[GregorianCalendarSystem.Fields.DAY.ordinal()];
                    continue block33;
                }
                case WEEKDAY: {
                    int processedWeekdayFieldsCount = 0;
                    while (dataStringPointer + processedWeekdayFieldsCount < dataLength && (data[dataStart + dataStringPointer + processedWeekdayFieldsCount] >= 97 && data[dataStart + dataStringPointer + processedWeekdayFieldsCount] <= 122 || data[dataStart + dataStringPointer + processedWeekdayFieldsCount] >= 65 && data[dataStart + dataStringPointer + processedWeekdayFieldsCount] <= 90)) {
                        ++processedWeekdayFieldsCount;
                    }
                    boolean useShortNames = formatCharCopies == 3;
                    int weekdayNameMatch = DateTimeFormatUtils.weekdayIDSearch(data, dataStart + dataStringPointer, processedWeekdayFieldsCount, useShortNames);
                    if (weekdayNameMatch < 0) {
                        if (!raiseParseDataError) return false;
                        throw new AsterixTemporalTypeParseException("Unexpected string for day-of-week: " + new String(data, dataStart + dataStringPointer, dataStart + dataStringPointer + processedWeekdayFieldsCount, ENCODING));
                    }
                    dataStringPointer += processedWeekdayFieldsCount;
                    continue block33;
                }
                case HOUR: {
                    dateTimeSeparatorChar = lastSeparatorChar;
                }
                case MINUTE: 
                case SECOND: 
                case MILLISECOND: {
                    int i;
                    int processFieldsCount = 0;
                    int expectedMaxCount = processState == DateTimeProcessState.MILLISECOND ? 3 : 2;
                    int parsedValue = 0;
                    for (i = 0; i < formatCharCopies; ++dataStringPointer, ++i) {
                        if (data[dataStart + dataStringPointer] < 48 || data[dataStart + dataStringPointer] > 57) {
                            if (!raiseParseDataError) return false;
                            throw new AsterixTemporalTypeParseException("Unexpected char for " + processState.name() + " field at " + (dataStart + dataStringPointer) + ": " + data[dataStart + dataStringPointer]);
                        }
                        parsedValue = parsedValue * 10 + (data[dataStart + dataStringPointer] - 48);
                        if (processFieldsCount++ <= expectedMaxCount) continue;
                        if (!raiseParseDataError) return false;
                        throw new AsterixTemporalTypeParseException("Unexpected char for " + processState.name() + " field at " + dataStringPointer + ": " + data[dataStart + dataStringPointer]);
                    }
                    while (processFieldsCount < expectedMaxCount && dataStringPointer < dataLength && data[dataStart + dataStringPointer] >= 48 && data[dataStart + dataStringPointer] <= 57) {
                        parsedValue = parsedValue * 10 + (data[dataStart + dataStringPointer] - 48);
                        ++dataStringPointer;
                        ++processFieldsCount;
                    }
                    if (processState == DateTimeProcessState.HOUR) {
                        hour = parsedValue;
                        continue block33;
                    }
                    if (processState == DateTimeProcessState.MINUTE) {
                        min = parsedValue;
                        continue block33;
                    }
                    if (processState == DateTimeProcessState.SECOND) {
                        sec = parsedValue;
                        continue block33;
                    }
                    if (processState != DateTimeProcessState.MILLISECOND) continue block33;
                    while (dataStringPointer < dataLength && data[dataStart + dataStringPointer] >= 48 && data[dataStart + dataStringPointer] <= 57) {
                        ++dataStringPointer;
                        ++processFieldsCount;
                    }
                    ms = parsedValue;
                    for (i = processFieldsCount; i < 3; ms *= 10, ++i) {
                    }
                    continue block33;
                }
                case TIMEZONE: {
                    int parsedValue;
                    if (data[dataStart + dataStringPointer] == 90 && (dataStringPointer + 1 >= dataLength || data[dataStart + dataStringPointer + 1] < 65 && data[dataStart + dataStringPointer + 1] > 90 && data[dataStart + dataStringPointer + 1] < 97 && data[dataStart + dataStringPointer + 1] > 122)) {
                        timezone = 0;
                        ++dataStringPointer;
                    } else if (data[dataStart + dataStringPointer] == 43 || data[dataStart + dataStringPointer] == 45 || dataStringPointer + 3 < dataLength && (data[dataStart + dataStringPointer + 3] == 43 || data[dataStart + dataStringPointer + 3] == 45)) {
                        int i;
                        if (dataStringPointer + 3 < dataLength && (DateTimeFormatUtils.byteArrayEqualToString(data, dataStart + dataStringPointer, 3, UTC_BYTEARRAY) || DateTimeFormatUtils.byteArrayEqualToString(data, dataStart + dataStringPointer, 3, GMT_BYTEARRAY))) {
                            dataStringPointer += 3;
                        }
                        boolean negativeTimeZone = false;
                        if (data[dataStart + dataStringPointer] == 45) {
                            negativeTimeZone = true;
                            ++dataStringPointer;
                        } else {
                            if (data[dataStart + dataStringPointer] != 43) {
                                if (!raiseParseDataError) return false;
                                throw new AsterixTemporalTypeParseException("Incorrect timezone hour field: expecting sign + or - but got: " + data[dataStart + dataStringPointer]);
                            }
                            ++dataStringPointer;
                        }
                        parsedValue = 0;
                        for (i = 0; i < 2; ++i) {
                            if (data[dataStart + dataStringPointer + i] >= 48 && data[dataStart + dataStringPointer + i] <= 57) {
                                parsedValue = parsedValue * 10 + (data[dataStart + dataStringPointer + i] - 48);
                                continue;
                            }
                            if (!raiseParseDataError) return false;
                            throw new AsterixTemporalTypeParseException("Unexpected character for timezone hour field at " + (dataStart + dataStringPointer) + ": " + data[dataStart + dataStringPointer]);
                        }
                        if (data[dataStart + (dataStringPointer += 2)] == 58) {
                            ++dataStringPointer;
                        }
                        timezone = (int)((long)parsedValue * 3600000L);
                        parsedValue = 0;
                        for (i = 0; i < 2; ++i) {
                            if (data[dataStart + dataStringPointer + i] >= 48 && data[dataStart + dataStringPointer + i] <= 57) {
                                parsedValue = parsedValue * 10 + (data[dataStart + dataStringPointer + i] - 48);
                                continue;
                            }
                            if (!raiseParseDataError) return false;
                            throw new AsterixTemporalTypeParseException("Unexpected character for timezone minute field at " + (dataStart + dataStringPointer) + ": " + data[dataStart + dataStringPointer]);
                        }
                        timezone += (int)((long)parsedValue * 60000L);
                        dataStringPointer += 2;
                        if (!negativeTimeZone) {
                            timezone *= -1;
                        }
                    } else {
                        int timezoneEndField;
                        for (timezoneEndField = dataStringPointer; timezoneEndField < dataLength && (data[dataStart + timezoneEndField] >= 48 && data[dataStart + timezoneEndField] <= 57 || data[dataStart + timezoneEndField] >= 97 && data[dataStart + timezoneEndField] <= 122 || data[dataStart + timezoneEndField] >= 65 && data[dataStart + timezoneEndField] <= 90 || data[dataStart + timezoneEndField] == 47 || data[dataStart + timezoneEndField] == 95); ++timezoneEndField) {
                        }
                        TimeZone tz = DateTimeFormatUtils.findTimeZone(data, dataStart + dataStringPointer, timezoneEndField - dataStringPointer);
                        if (tz == null) {
                            if (!raiseParseDataError) return false;
                            throw new AsterixTemporalTypeParseException("Unexpected timezone string: " + new String(data, dataStart + dataStringPointer, dataStart + timezoneEndField, ENCODING));
                        }
                        timezone = tz.getRawOffset();
                        dataStringPointer = timezoneEndField;
                    }
                    timezoneExists = true;
                    continue block33;
                }
                case AMPM: {
                    if (dataStringPointer + 1 >= dataLength) {
                        if (!raiseParseDataError) return false;
                        throw new AsterixTemporalTypeParseException("Cannot find valid AM/PM marker.");
                    }
                    if (hour > 12 || hour <= 0) {
                        if (!raiseParseDataError) return false;
                        throw new AsterixTemporalTypeParseException("Hour " + hour + " cannot be a time for AM/PM.");
                    }
                    if (!DateTimeFormatUtils.byteArrayEqualToString(data, dataStart + dataStringPointer, 2, AM_BYTEARRAY)) {
                        if (!DateTimeFormatUtils.byteArrayEqualToString(data, dataStart + dataStringPointer, 2, PM_BYTEARRAY)) {
                            if (!raiseParseDataError) return false;
                            throw new AsterixTemporalTypeParseException("Unexpected string for AM/PM marker " + new String(data, dataStart + dataStringPointer, dataStart + dataStringPointer + 2, ENCODING));
                        }
                        if ((hour += 12) == 24) {
                            hour = 0;
                        }
                    }
                    dataStringPointer += 2;
                    continue block33;
                }
                case SKIPPER: {
                    while (data[dataStart + dataStringPointer] >= 97 && data[dataStart + dataStringPointer] <= 122 || data[dataStart + dataStringPointer] >= 65 && data[dataStart + dataStringPointer] <= 90 || data[dataStart + dataStringPointer] >= 48 && data[dataStart + dataStringPointer] <= 57) {
                        ++dataStringPointer;
                    }
                    continue block33;
                }
                case SEPARATOR: {
                    int i;
                    for (i = 0; i < formatCharCopies; ++dataStringPointer, ++i) {
                        boolean match;
                        byte b = data[dataStart + dataStringPointer];
                        boolean bl = match = (char)b == separatorChar || altSeparatorChar != '\u0000' && (char)b == altSeparatorChar;
                        if (!match) {
                            if (!raiseParseDataError) return false;
                            throw new AsterixTemporalTypeParseException("Expecting separator " + separatorChar + " but got " + b);
                        }
                        lastSeparatorChar = (char)b;
                    }
                    continue block33;
                }
            }
            throw new AsterixTemporalTypeParseException("Unexpected time format information when parsing a date value");
        }
        if (dataStringPointer < dataLength) {
            if (!raiseParseDataError) return false;
            throw new AsterixTemporalTypeParseException("The given data string is not fully parsed by the given format string");
        }
        if (formatPointer < formatLength) {
            if (!raiseParseDataError) return false;
            throw new AsterixTemporalTypeParseException("The given format string is not fully used for the given data string");
        }
        if (parseMode == DateTimeParseMode.TIME_ONLY) {
            int minDay;
            int minMonth;
            int minYear = GregorianCalendarSystem.FIELD_MINS[GregorianCalendarSystem.Fields.YEAR.ordinal()];
            if (!CAL.validate(minYear, minMonth = GregorianCalendarSystem.FIELD_MINS[GregorianCalendarSystem.Fields.MONTH.ordinal()], minDay = GregorianCalendarSystem.FIELD_MINS[GregorianCalendarSystem.Fields.DAY.ordinal()], hour, min, sec, ms)) {
                if (!raiseParseDataError) return false;
                throw new AsterixTemporalTypeParseException("Invalid time value");
            }
            chronon = CAL.getChronon(hour, min, sec, ms);
        } else {
            if (!CAL.validate(year, month, day, hour, min, sec, ms)) {
                if (!raiseParseDataError) return false;
                throw new AsterixTemporalTypeParseException("Invalid date/time value");
            }
            chronon = CAL.getChronon(year, month, day, hour, min, sec, ms);
        }
        if (timezoneExists && adjustChrononByTimezone) {
            if (!CAL.validateTimeZone(timezone)) {
                if (!raiseParseDataError) return false;
                throw new AsterixTemporalTypeParseException("Invalid time zone");
            }
            chronon += (long)timezone;
        }
        outChronon.setValue(chronon);
        if (dateTimeSeparatorOut != null) {
            dateTimeSeparatorOut.setValue((Object)Character.valueOf(dateTimeSeparatorChar));
        }
        if (outTimeZoneExists != null) {
            outTimeZoneExists.setValue((Object)timezoneExists);
        }
        if (outTimeZone == null) return true;
        outTimeZone.setValue(timezone);
        return true;
    }

    public void printDateTime(long chronon, byte[] format, int formatStart, int formatLength, Appendable appender, DateTimeParseMode parseMode) throws HyracksDataException {
        int year = CAL.getYear(chronon);
        int month = CAL.getMonthOfYear(chronon, year);
        int day = CAL.getDayOfMonthYear(chronon, year, month);
        int dayOfYear = CAL.getDayOfYear(chronon, year);
        int dayOfWeek = CAL.getDayOfWeek(chronon);
        int hour = CAL.getHourOfDay(chronon);
        int min = CAL.getMinOfHour(chronon);
        int sec = CAL.getSecOfMin(chronon);
        int ms = CAL.getMillisOfSec(chronon);
        int formatPointer = 0;
        char separatorChar = '\u0000';
        boolean usePM = false;
        if (this.indexOf(format, formatStart, formatLength, 'a') >= 0) {
            if (hour >= 12) {
                usePM = true;
                hour -= 12;
            }
            if (hour == 0) {
                hour = 12;
            }
        }
        block30: while (formatPointer < formatLength) {
            DateTimeProcessState processState;
            int formatCharCopies = 0;
            switch (format[formatStart + formatPointer]) {
                case 89: {
                    processState = DateTimeProcessState.YEAR;
                    int pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'Y', 4);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 81: {
                    processState = DateTimeProcessState.QUARTER;
                    int pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'Q', 2);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 77: {
                    processState = DateTimeProcessState.MONTH;
                    int pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'M', 4);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 68: {
                    processState = DateTimeProcessState.DAY;
                    int pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'D', 3);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 69: {
                    processState = DateTimeProcessState.WEEKDAY;
                    int pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'E', 4);
                    if (pointerMove < 3) {
                        throw new AsterixTemporalTypeParseException(String.format("Expected at least %d '%s' characters but got %d", 3, Character.valueOf('E'), pointerMove));
                    }
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 104: {
                    processState = DateTimeProcessState.HOUR;
                    int pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'h', 2);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 109: {
                    processState = DateTimeProcessState.MINUTE;
                    int pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'm', 2);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 115: {
                    processState = DateTimeProcessState.SECOND;
                    int pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 's', 2);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 110: {
                    processState = DateTimeProcessState.MILLISECOND;
                    int pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'n', 3);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 83: {
                    processState = DateTimeProcessState.MILLISECOND;
                    int pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'S', 3);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 97: {
                    processState = DateTimeProcessState.AMPM;
                    int pointerMove = this.parseFormatField(format, formatStart, formatLength, formatPointer, 'a', 1);
                    formatPointer += pointerMove;
                    formatCharCopies += pointerMove;
                    break;
                }
                case 32: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 58: 
                case 84: {
                    separatorChar = (char)format[formatStart + formatPointer];
                    processState = DateTimeProcessState.SEPARATOR;
                    ++formatPointer;
                    ++formatCharCopies;
                    while (formatPointer < formatLength && format[formatStart + formatPointer] == (byte)separatorChar) {
                        ++formatPointer;
                        ++formatCharCopies;
                    }
                    break;
                }
                default: {
                    throw new HyracksDataException("Unexpected format string at " + (formatStart + formatPointer) + ": " + (char)format[formatStart + formatPointer]);
                }
            }
            switch (processState) {
                case YEAR: 
                case QUARTER: 
                case MONTH: 
                case DAY: 
                case WEEKDAY: {
                    if (parseMode != DateTimeParseMode.TIME_ONLY) break;
                    throw new HyracksDataException("Unexpected date format string when parsing a time value");
                }
                case HOUR: 
                case MINUTE: 
                case SECOND: 
                case MILLISECOND: 
                case AMPM: {
                    if (parseMode != DateTimeParseMode.DATE_ONLY) break;
                    throw new HyracksDataException("Unexpected time format string when parsing a date value");
                }
            }
            try {
                switch (processState) {
                    case YEAR: {
                        if (year < 0) {
                            appender.append('-');
                            year *= -1;
                        }
                    }
                    case QUARTER: 
                    case MONTH: {
                        if (processState == DateTimeProcessState.MONTH && formatCharCopies >= 3) {
                            byte[][] monthNames = formatCharCopies > 3 ? MONTH_FULL_NAMES : MONTH_NAMES;
                            for (byte b : monthNames[month - 1]) {
                                appender.append((char)DateTimeFormatUtils.toUpper(b));
                            }
                            continue block30;
                        }
                    }
                    case DAY: {
                        int val = processState == DateTimeProcessState.YEAR ? year : (processState == DateTimeProcessState.QUARTER ? (month - 1) / 3 + 1 : (processState == DateTimeProcessState.MONTH ? month : (formatCharCopies == 3 ? dayOfYear : day)));
                        String strVal = String.valueOf(val);
                        int valFieldCount = strVal.length();
                        for (int i = 0; i < formatCharCopies - valFieldCount; ++i) {
                            appender.append('0');
                        }
                        appender.append(strVal);
                        break;
                    }
                    case WEEKDAY: {
                        byte[][] weekdayNames = formatCharCopies == 3 ? WEEKDAY_NAMES : WEEKDAY_FULL_NAMES;
                        byte[] weekday = weekdayNames[dayOfWeek];
                        for (int i = 0; i < weekday.length; ++i) {
                            byte b = weekday[i];
                            appender.append((char)(i == 0 ? DateTimeFormatUtils.toUpper(b) : b));
                        }
                        continue block30;
                    }
                    case HOUR: 
                    case MINUTE: 
                    case SECOND: {
                        int val = 0;
                        if (processState == DateTimeProcessState.HOUR) {
                            val = hour;
                        } else if (processState == DateTimeProcessState.MINUTE) {
                            val = min;
                        } else if (processState == DateTimeProcessState.SECOND) {
                            val = sec;
                        }
                        if (val < 10) {
                            for (int i = 0; i < formatCharCopies - 1; ++i) {
                                appender.append('0');
                            }
                        }
                        appender.append(String.valueOf(val));
                        break;
                    }
                    case MILLISECOND: {
                        int i;
                        String strMS = String.valueOf(ms);
                        int msFieldCount = strMS.length();
                        for (i = 0; i < 3 - msFieldCount; ++i) {
                            appender.append('0');
                        }
                        if (formatCharCopies < 3) {
                            if (formatCharCopies == 1) {
                                if (ms % 100 == 0) {
                                    ms /= 100;
                                } else if (ms % 10 == 0) {
                                    ms /= 10;
                                }
                            } else if (ms % 10 == 0) {
                                ms /= 10;
                            }
                            appender.append(String.valueOf(ms));
                            break;
                        }
                        appender.append(strMS);
                        break;
                    }
                    case AMPM: {
                        if (usePM) {
                            appender.append("PM");
                            break;
                        }
                        appender.append("AM");
                        break;
                    }
                    case SEPARATOR: {
                        int i;
                        if (separatorChar == '\u0000') {
                            throw new HyracksDataException("Incorrect separator: separator char is not initialized properly!");
                        }
                        for (i = 0; i < formatCharCopies; ++i) {
                            appender.append(separatorChar);
                        }
                        continue block30;
                    }
                    default: {
                        throw new HyracksDataException("Unexpected time state when printing a date value");
                    }
                }
            }
            catch (IOException ex) {
                throw HyracksDataException.create((Throwable)ex);
            }
        }
    }

    static {
        int i;
        CAL = GregorianCalendarSystem.getInstance();
        ENCODING = StandardCharsets.UTF_8;
        MONTH_NAMES = new byte[][]{"jan".getBytes(ENCODING), "feb".getBytes(ENCODING), "mar".getBytes(ENCODING), "apr".getBytes(ENCODING), "may".getBytes(ENCODING), "jun".getBytes(ENCODING), "jul".getBytes(ENCODING), "aug".getBytes(ENCODING), "sep".getBytes(ENCODING), "oct".getBytes(ENCODING), "nov".getBytes(ENCODING), "dec".getBytes(ENCODING)};
        MONTH_FULL_NAMES = new byte[][]{"january".getBytes(ENCODING), "february".getBytes(ENCODING), "march".getBytes(ENCODING), "april".getBytes(ENCODING), "may".getBytes(ENCODING), "june".getBytes(ENCODING), "july".getBytes(ENCODING), "august".getBytes(ENCODING), "september".getBytes(ENCODING), "october".getBytes(ENCODING), "november".getBytes(ENCODING), "december".getBytes(ENCODING)};
        WEEKDAY_NAMES = new byte[][]{"sun".getBytes(ENCODING), "mon".getBytes(ENCODING), "tue".getBytes(ENCODING), "wed".getBytes(ENCODING), "thu".getBytes(ENCODING), "fri".getBytes(ENCODING), "sat".getBytes(ENCODING)};
        WEEKDAY_FULL_NAMES = new byte[][]{"sunday".getBytes(ENCODING), "monday".getBytes(ENCODING), "tuesday".getBytes(ENCODING), "wednesday".getBytes(ENCODING), "thursday".getBytes(ENCODING), "friday".getBytes(ENCODING), "saturday".getBytes(ENCODING)};
        UTC_BYTEARRAY = "utc".getBytes(ENCODING);
        GMT_BYTEARRAY = "gmt".getBytes(ENCODING);
        AM_BYTEARRAY = "am".getBytes(ENCODING);
        PM_BYTEARRAY = "pm".getBytes(ENCODING);
        byteArrayComparator = new Comparator<byte[]>(){

            @Override
            public int compare(byte[] o1, byte[] o2) {
                int i;
                for (i = 0; i < o1.length && i < o2.length; ++i) {
                    if (o1[i] == o2[i]) continue;
                    return o1[i] - o2[i];
                }
                if (i < o1.length) {
                    return -1;
                }
                if (i < o2.length) {
                    return 1;
                }
                return 0;
            }
        };
        String[] tzIds = TimeZone.getAvailableIDs();
        int tzCount = tzIds.length;
        TIMEZONE_IDS = new byte[tzCount][];
        TIMEZONE_VALUES = new TimeZone[tzCount];
        for (i = 0; i < tzCount; ++i) {
            DateTimeFormatUtils.TIMEZONE_IDS[i] = tzIds[i].getBytes(ENCODING);
        }
        Arrays.sort(TIMEZONE_IDS, byteArrayComparator);
        for (i = 0; i < tzCount; ++i) {
            DateTimeFormatUtils.TIMEZONE_VALUES[i] = TimeZone.getTimeZone(new String(TIMEZONE_IDS[i], ENCODING));
        }
        INSTANCE = new DateTimeFormatUtils();
    }

    public static enum DateTimeParseMode {
        DATE_ONLY,
        TIME_ONLY,
        DATETIME;

    }

    private static enum DateTimeProcessState {
        YEAR,
        QUARTER,
        MONTH,
        DAY,
        WEEKDAY,
        HOUR,
        MINUTE,
        SECOND,
        MILLISECOND,
        AMPM,
        TIMEZONE,
        SKIPPER,
        SEPARATOR;

    }
}

