/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.nc.task;

import java.util.HashMap;
import org.apache.asterix.common.api.INCLifecycleTask;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.config.MetadataProperties;
import org.apache.asterix.hyracks.bootstrap.AsterixStateDumpHandler;
import org.apache.hyracks.api.application.IStateDumpHandler;
import org.apache.hyracks.api.control.CcId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.lifecycle.ILifeCycleComponentManager;
import org.apache.hyracks.api.service.IControllerService;
import org.apache.hyracks.control.nc.application.NCServiceContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StartLifecycleComponentsTask
implements INCLifecycleTask {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = 1L;

    public void perform(CcId ccId, IControllerService cs) throws HyracksDataException {
        INcApplicationContext applicationContext = (INcApplicationContext)cs.getApplicationContext();
        NCServiceContext serviceCtx = (NCServiceContext)cs.getContext();
        MetadataProperties metadataProperties = applicationContext.getMetadataProperties();
        LOGGER.info("Starting lifecycle components");
        HashMap<String, String> lifecycleMgmtConfiguration = new HashMap<String, String>();
        String dumpPathKey = "DUMP_PATH";
        String dumpPath = metadataProperties.getCoredumpPath(serviceCtx.getNodeId());
        lifecycleMgmtConfiguration.put(dumpPathKey, dumpPath);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Coredump directory for NC is: " + dumpPath);
        }
        ILifeCycleComponentManager lccm = serviceCtx.getLifeCycleComponentManager();
        lccm.configure(lifecycleMgmtConfiguration);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Configured:" + lccm);
        }
        serviceCtx.setStateDumpHandler((IStateDumpHandler)new AsterixStateDumpHandler(serviceCtx.getNodeId(), lccm.getDumpPath(), lccm));
        lccm.startAll();
    }

    public String toString() {
        return "{ \"class\" : \"" + this.getClass().getSimpleName() + "\" }";
    }
}

