/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.apache.asterix.algebra.base.ILangExtension;
import org.apache.asterix.api.http.server.AbstractQueryApiServlet;
import org.apache.asterix.api.http.server.QueryServiceRequestParameters;
import org.apache.asterix.api.http.server.QueryServiceServlet;
import org.apache.asterix.app.message.CancelQueryRequest;
import org.apache.asterix.app.message.ExecuteStatementRequestMessage;
import org.apache.asterix.app.message.ExecuteStatementResponseMessage;
import org.apache.asterix.app.result.ResponsePrinter;
import org.apache.asterix.app.result.fields.NcResultPrinter;
import org.apache.asterix.app.result.fields.SignaturePrinter;
import org.apache.asterix.app.translator.RequestParameters;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.api.IRequestReference;
import org.apache.asterix.common.config.GlobalConfig;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.common.messaging.api.ICcAddressedMessage;
import org.apache.asterix.common.messaging.api.INCMessageBroker;
import org.apache.asterix.common.messaging.api.MessageFuture;
import org.apache.asterix.compiler.provider.ILangCompilationProvider;
import org.apache.asterix.translator.IStatementExecutor;
import org.apache.asterix.translator.ResultProperties;
import org.apache.asterix.translator.SessionOutput;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.hyracks.api.util.ExceptionUtils;
import org.apache.hyracks.http.api.IChannelClosedHandler;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.HttpServer;
import org.apache.hyracks.http.server.InterruptOnCloseHandler;
import org.apache.hyracks.ipc.exceptions.IPCException;
import org.apache.logging.log4j.Level;

public class NCQueryServiceServlet
extends QueryServiceServlet {
    public NCQueryServiceServlet(ConcurrentMap<String, Object> ctx, String[] paths, IApplicationContext appCtx, ILangExtension.Language queryLanguage, ILangCompilationProvider compilationProvider, Function<IServletRequest, Map<String, String>> optionalParamProvider) {
        super(ctx, paths, appCtx, queryLanguage, compilationProvider, null, null, optionalParamProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeStatement(IServletRequest request, IRequestReference requestReference, String statementsText, SessionOutput sessionOutput, ResultProperties resultProperties, IStatementExecutor.StatementProperties statementProperties, IStatementExecutor.Stats stats, QueryServiceRequestParameters param, QueryServiceServlet.RequestExecutionState executionState, Map<String, String> optionalParameters, Map<String, byte[]> statementParameters, ResponsePrinter responsePrinter, List<Warning> warnings) throws Exception {
        ExecuteStatementResponseMessage responseMsg;
        this.ensureOptionalParameters(optionalParameters);
        INCServiceContext ncCtx = (INCServiceContext)this.serviceCtx;
        INCMessageBroker ncMb = (INCMessageBroker)ncCtx.getMessageBroker();
        IStatementExecutor.ResultDelivery delivery = resultProperties.getDelivery();
        MessageFuture responseFuture = ncMb.registerMessageFuture();
        String handleUrl = this.getHandleUrl(param.getHost(), param.getPath(), delivery);
        try {
            long timeout = param.getTimeout();
            int stmtCategoryRestrictionMask = RequestParameters.getStatementCategoryRestrictionMask(param.isReadOnly());
            ExecuteStatementRequestMessage requestMsg = this.createRequestMessage(request, requestReference, statementsText, sessionOutput, resultProperties, param, optionalParameters, statementParameters, ncCtx, responseFuture, this.queryLanguage, handleUrl, stmtCategoryRestrictionMask, false);
            executionState.start();
            ncMb.sendMessageToPrimaryCC((ICcAddressedMessage)requestMsg);
            try {
                responseMsg = (ExecuteStatementResponseMessage)responseFuture.get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                this.cancelQuery(ncMb, ncCtx.getNodeId(), requestReference.getUuid(), param.getClientContextID(), e, false);
                throw e;
            }
            catch (TimeoutException exception) {
                RuntimeDataException hde = new RuntimeDataException(ErrorCode.REQUEST_TIMEOUT, new Serializable[0]);
                hde.addSuppressed((Throwable)exception);
                this.cancelQuery(ncMb, ncCtx.getNodeId(), requestReference.getUuid(), param.getClientContextID(), (Exception)hde, true);
                throw hde;
            }
            executionState.end();
        }
        finally {
            ncMb.deregisterMessageFuture(responseFuture.getFutureId());
        }
        NCQueryServiceServlet.updatePropertiesFromCC(statementProperties, responseMsg);
        Throwable err = responseMsg.getError();
        if (err != null) {
            if (err instanceof Error) {
                throw (Error)err;
            }
            if (err instanceof Exception) {
                throw (Exception)err;
            }
            throw new Exception(err.toString(), err);
        }
        executionState.setStatus(AbstractQueryApiServlet.ResultStatus.SUCCESS, HttpResponseStatus.OK);
        NCQueryServiceServlet.updateStatsFromCC(stats, responseMsg);
        if (param.isSignature() && delivery != IStatementExecutor.ResultDelivery.ASYNC && !param.isParseOnly()) {
            responsePrinter.addResultPrinter(SignaturePrinter.newInstance(responseMsg.getExecutionPlans()));
        }
        if (NCQueryServiceServlet.hasResult(responseMsg)) {
            responsePrinter.addResultPrinter(new NcResultPrinter(this.appCtx, responseMsg, this.getResultSet(), delivery, sessionOutput, stats));
        }
        warnings.addAll(responseMsg.getWarnings());
        this.buildResponseResults(responsePrinter, sessionOutput, responseMsg.getExecutionPlans(), warnings);
    }

    protected void ensureOptionalParameters(Map<String, String> optionalParameters) throws HyracksDataException {
    }

    protected ExecuteStatementRequestMessage createRequestMessage(IServletRequest request, IRequestReference requestReference, String statementsText, SessionOutput sessionOutput, ResultProperties resultProperties, QueryServiceRequestParameters param, Map<String, String> optionalParameters, Map<String, byte[]> statementParameters, INCServiceContext ncCtx, MessageFuture responseFuture, ILangExtension.Language queryLanguage, String handleUrl, int stmtCategoryRestrictionMask, boolean forceDropDataset) {
        ExecuteStatementRequestMessage requestMessage = new ExecuteStatementRequestMessage(ncCtx.getNodeId(), responseFuture.getFutureId(), queryLanguage, statementsText, sessionOutput.config(), resultProperties.getNcToCcResultProperties(), param.getClientContextID(), param.getDataverse(), handleUrl, optionalParameters, statementParameters, param.isMultiStatement(), param.getProfileType(), stmtCategoryRestrictionMask, requestReference, forceDropDataset);
        requestMessage.setSQLCompatMode(param.isSQLCompatMode());
        return requestMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelQuery(INCMessageBroker messageBroker, String nodeId, String uuid, String clientContextID, Exception exception, boolean wait) {
        if (uuid == null && clientContextID == null) {
            return;
        }
        MessageFuture cancelQueryFuture = messageBroker.registerMessageFuture();
        try {
            CancelQueryRequest cancelQueryMessage = new CancelQueryRequest(nodeId, cancelQueryFuture.getFutureId(), uuid, clientContextID);
            LOGGER.info("Cancelling query due to {}", (Object)exception.getClass().getSimpleName());
            messageBroker.sendMessageToPrimaryCC((ICcAddressedMessage)cancelQueryMessage);
            if (wait) {
                cancelQueryFuture.get(ExecuteStatementRequestMessage.DEFAULT_QUERY_CANCELLATION_WAIT_MILLIS, TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception e) {
            exception.addSuppressed(e);
        }
        finally {
            messageBroker.deregisterMessageFuture(cancelQueryFuture.getFutureId());
        }
    }

    @Override
    protected void handleExecuteStatementException(Throwable t, QueryServiceServlet.RequestExecutionState executionState, QueryServiceRequestParameters param, IServletResponse response) {
        if (t instanceof TimeoutException || ExceptionUtils.matchingCause((Throwable)t, candidate -> candidate instanceof IPCException)) {
            GlobalConfig.ASTERIX_LOGGER.log(Level.WARN, t.toString(), t);
            executionState.setStatus(AbstractQueryApiServlet.ResultStatus.FAILED, HttpResponseStatus.SERVICE_UNAVAILABLE);
        } else {
            super.handleExecuteStatementException(t, executionState, param, response);
        }
    }

    public IChannelClosedHandler getChannelClosedHandler(HttpServer server) {
        return InterruptOnCloseHandler.INSTANCE;
    }

    private static boolean hasResult(ExecuteStatementResponseMessage responseMsg) {
        return !responseMsg.getMetadata().getResultSets().isEmpty() || !responseMsg.getResult().isEmpty();
    }

    private static void updateStatsFromCC(IStatementExecutor.Stats stats, ExecuteStatementResponseMessage responseMsg) {
        IStatementExecutor.Stats responseStats = responseMsg.getStats();
        stats.setJobProfile(responseStats.getJobProfile());
        stats.setProcessedObjects(responseStats.getProcessedObjects());
        stats.updateTotalWarningsCount(responseStats.getTotalWarningsCount());
    }

    private static void updatePropertiesFromCC(IStatementExecutor.StatementProperties statementProperties, ExecuteStatementResponseMessage responseMsg) {
        IStatementExecutor.StatementProperties responseStmtProps = responseMsg.getStatementProperties();
        if (responseStmtProps != null) {
            statementProperties.setKind(responseStmtProps.getKind());
            statementProperties.setName(responseStmtProps.getName());
        }
    }
}

