/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.converter;

import com.couchbase.client.core.message.dcp.DCPRequest;
import com.couchbase.client.core.message.dcp.MutationMessage;
import com.couchbase.client.core.message.dcp.RemoveMessage;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.input.record.CharArrayRecord;
import org.apache.asterix.external.input.record.RecordWithMetadataAndPK;
import org.apache.asterix.external.input.record.converter.IRecordToRecordWithMetadataAndPKConverter;
import org.apache.asterix.external.util.ExternalDataConstants;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.RecordUtil;

public class DCPMessageToRecordConverter
implements IRecordToRecordWithMetadataAndPKConverter<DCPRequest, char[]> {
    private final RecordWithMetadataAndPK<char[]> recordWithMetadata;
    private final CharArrayRecord value;
    private final CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
    private final ByteBuffer bytes = ByteBuffer.allocate(ExternalDataConstants.DEFAULT_BUFFER_SIZE);
    private final CharBuffer chars = CharBuffer.allocate(ExternalDataConstants.DEFAULT_BUFFER_SIZE);
    private static final IAType[] CB_META_TYPES = new IAType[]{BuiltinType.ASTRING, BuiltinType.AINT32, BuiltinType.AINT64, BuiltinType.AINT64, BuiltinType.AINT32, BuiltinType.AINT32, BuiltinType.AINT64, BuiltinType.AINT32};
    private static final int[] PK_INDICATOR = new int[]{1};
    private static final int[] PK_INDEXES = new int[]{0};
    private static final IAType[] PK_TYPES = new IAType[]{BuiltinType.ASTRING};

    public DCPMessageToRecordConverter() {
        this.value = new CharArrayRecord();
        this.recordWithMetadata = new RecordWithMetadataAndPK<char[]>(this.value, CB_META_TYPES, RecordUtil.FULLY_OPEN_RECORD_TYPE, PK_INDICATOR, PK_INDEXES, PK_TYPES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecordWithMetadataAndPK<char[]> convert(IRawRecord<? extends DCPRequest> input) throws IOException {
        DCPRequest dcpRequest = input.get();
        if (dcpRequest instanceof MutationMessage) {
            MutationMessage message = (MutationMessage)dcpRequest;
            try {
                String key = message.key();
                short vbucket = message.partition();
                long seq = message.bySequenceNumber();
                long cas = message.cas();
                int expiration = message.expiration();
                int flags = message.flags();
                long revSeqNumber = message.revisionSequenceNumber();
                int lockTime = message.lockTime();
                int i = 0;
                this.recordWithMetadata.reset();
                this.recordWithMetadata.setMetadata(i++, key);
                this.recordWithMetadata.setMetadata(i++, vbucket);
                this.recordWithMetadata.setMetadata(i++, seq);
                this.recordWithMetadata.setMetadata(i++, cas);
                this.recordWithMetadata.setMetadata(i++, expiration);
                this.recordWithMetadata.setMetadata(i++, flags);
                this.recordWithMetadata.setMetadata(i++, revSeqNumber);
                this.recordWithMetadata.setMetadata(i, lockTime);
                DCPMessageToRecordConverter.set(message.content(), this.decoder, this.bytes, this.chars, this.value);
            }
            finally {
                ReferenceCountUtil.release((Object)message.content());
            }
        } else if (dcpRequest instanceof RemoveMessage) {
            RemoveMessage message = (RemoveMessage)dcpRequest;
            String key = message.key();
            this.recordWithMetadata.reset();
            this.recordWithMetadata.setMetadata(0, key);
        } else {
            throw new RuntimeDataException(ErrorCode.INPUT_RECORD_CONVERTER_DCP_MSG_TO_RECORD_CONVERTER_UNKNOWN_DCP_REQUEST, new Serializable[]{dcpRequest.toString()});
        }
        return this.recordWithMetadata;
    }

    public static void set(ByteBuf content, CharsetDecoder decoder, ByteBuffer bytes, CharBuffer chars, CharArrayRecord record) throws IOException {
        int position = content.readerIndex();
        int limit = content.writerIndex();
        int contentSize = content.readableBytes();
        bytes.clear();
        while (position < limit) {
            chars.clear();
            if (contentSize - position < bytes.capacity()) {
                bytes.limit(contentSize - position);
            }
            content.getBytes(position + bytes.position(), bytes);
            position += bytes.position();
            bytes.flip();
            decoder.decode(bytes, chars, false);
            if (bytes.hasRemaining()) {
                bytes.compact();
                position -= bytes.position();
            } else {
                bytes.clear();
            }
            chars.flip();
            record.append(chars);
        }
        record.endRecord();
    }
}

