/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.locking;

import org.apache.asterix.transaction.management.service.locking.AllocInfo;
import org.apache.asterix.transaction.management.service.locking.RecordManagerStats;
import org.apache.asterix.transaction.management.service.locking.RequestRecordManager;
import org.apache.asterix.transaction.management.service.locking.TypeUtil;

public class RequestArenaManager {
    public static final boolean TRACK_ALLOC_ID = false;
    private final int noArenas;
    private final RequestRecordManager[] arenas;
    private ThreadLocal<LocalManager> local;

    public RequestArenaManager(final int noArenas, long txnShrinkTimer) {
        this.noArenas = noArenas;
        this.arenas = new RequestRecordManager[noArenas];
        for (int i = 0; i < noArenas; ++i) {
            this.arenas[i] = new RequestRecordManager(txnShrinkTimer);
        }
        this.local = new ThreadLocal<LocalManager>(){
            private int nextArena = 0;

            @Override
            protected synchronized LocalManager initialValue() {
                RequestRecordManager mgr = RequestArenaManager.this.arenas[this.nextArena];
                LocalManager res = new LocalManager();
                res.mgr = mgr;
                res.arenaId = this.nextArena;
                this.nextArena = (this.nextArena + 1) % noArenas;
                return res;
            }
        };
    }

    public long allocate() {
        LocalManager localManager = this.local.get();
        RequestRecordManager recMgr = localManager.mgr;
        int allocId = 1;
        int localId = recMgr.allocate();
        long result = TypeUtil.Global.build(localManager.arenaId, allocId, localId);
        assert (TypeUtil.Global.allocId(result) == allocId);
        assert (TypeUtil.Global.arenaId(result) == localManager.arenaId);
        assert (TypeUtil.Global.localId(result) == localId);
        return result;
    }

    public void deallocate(long slotNum) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        this.get(arenaId).deallocate(TypeUtil.Global.localId(slotNum));
    }

    public RequestRecordManager get(int i) {
        return this.arenas[i];
    }

    public RequestRecordManager local() {
        return this.local.get().mgr;
    }

    public long getResourceId(long slotNum) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        return this.get(arenaId).getResourceId(localId);
    }

    public void setResourceId(long slotNum, long value) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        this.get(arenaId).setResourceId(localId, value);
    }

    public long getJobSlot(long slotNum) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        return this.get(arenaId).getJobSlot(localId);
    }

    public void setJobSlot(long slotNum, long value) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        this.get(arenaId).setJobSlot(localId, value);
    }

    public long getPrevJobRequest(long slotNum) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        return this.get(arenaId).getPrevJobRequest(localId);
    }

    public void setPrevJobRequest(long slotNum, long value) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        this.get(arenaId).setPrevJobRequest(localId, value);
    }

    public long getNextJobRequest(long slotNum) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        return this.get(arenaId).getNextJobRequest(localId);
    }

    public void setNextJobRequest(long slotNum, long value) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        this.get(arenaId).setNextJobRequest(localId, value);
    }

    public long getNextRequest(long slotNum) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        return this.get(arenaId).getNextRequest(localId);
    }

    public void setNextRequest(long slotNum, long value) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        this.get(arenaId).setNextRequest(localId, value);
    }

    public int getLockMode(long slotNum) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        return this.get(arenaId).getLockMode(localId);
    }

    public void setLockMode(long slotNum, int value) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        this.get(arenaId).setLockMode(localId, value);
    }

    public short getAllocId(long slotNum) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        return this.get(arenaId).getAllocId(localId);
    }

    public void setAllocId(long slotNum, short value) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        this.get(arenaId).setAllocId(localId, value);
    }

    private void checkAllocId(long slotNum) {
        short curAllocId;
        int refAllocId = TypeUtil.Global.allocId(slotNum);
        if (refAllocId != (curAllocId = this.getAllocId(slotNum))) {
            String msg = "reference to slot " + TypeUtil.Global.toString(slotNum) + " of arena " + TypeUtil.Global.arenaId(slotNum) + " refers to version " + Integer.toHexString(refAllocId) + " current version is " + Integer.toHexString(curAllocId);
            AllocInfo a = this.getAllocInfo(slotNum);
            if (a != null) {
                msg = msg + "\n" + a.toString();
            }
            throw new IllegalStateException(msg);
        }
    }

    public AllocInfo getAllocInfo(long slotNum) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        return this.get(arenaId).getAllocInfo(TypeUtil.Global.localId(slotNum));
    }

    public StringBuilder appendRecord(StringBuilder sb, long slotNum) {
        sb.append("{ ");
        sb.append("\"resource id\" : \"");
        sb = TypeUtil.Global.append(sb, this.getResourceId(slotNum));
        sb.append("\"");
        sb.append(", ");
        sb.append("\"job slot\" : \"");
        sb = TypeUtil.Global.append(sb, this.getJobSlot(slotNum));
        sb.append("\"");
        sb.append(", ");
        sb.append("\"prev job request\" : \"");
        sb = TypeUtil.Global.append(sb, this.getPrevJobRequest(slotNum));
        sb.append("\"");
        sb.append(", ");
        sb.append("\"next job request\" : \"");
        sb = TypeUtil.Global.append(sb, this.getNextJobRequest(slotNum));
        sb.append("\"");
        sb.append(", ");
        sb.append("\"next request\" : \"");
        sb = TypeUtil.Global.append(sb, this.getNextRequest(slotNum));
        sb.append("\"");
        sb.append(", ");
        sb.append("\"lock mode\" : \"");
        sb = TypeUtil.Int.append(sb, this.getLockMode(slotNum));
        sb.append("\"");
        sb.append(", ");
        sb.append("\"alloc id\" : \"");
        sb = TypeUtil.Short.append(sb, this.getAllocId(slotNum));
        sb.append("\"");
        return sb.append(" }");
    }

    public StringBuilder append(StringBuilder sb) {
        for (int i = 0; i < this.noArenas; ++i) {
            sb.append("++++ arena ").append(i).append(" ++++\n");
            this.arenas[i].append(sb);
        }
        return sb;
    }

    public String toString() {
        return this.append(new StringBuilder()).toString();
    }

    public RecordManagerStats addTo(RecordManagerStats s) {
        s.arenas += this.noArenas;
        for (int i = 0; i < this.noArenas; ++i) {
            this.arenas[i].addTo(s);
        }
        return s;
    }

    static class LocalManager {
        int arenaId;
        RequestRecordManager mgr;

        LocalManager() {
        }
    }
}

