/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.runningaggregates.std;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Random;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IRunningAggregateEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IRunningAggregateEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class SampleSlotRunningAggregateFunctionFactory
implements IRunningAggregateEvaluatorFactory {
    private static final long serialVersionUID = 2L;
    private final int sampleCardinalityTarget;
    private final long sampleSeed;

    public SampleSlotRunningAggregateFunctionFactory(int sampleCardinalityTarget, long sampleSeed) {
        this.sampleCardinalityTarget = sampleCardinalityTarget;
        this.sampleSeed = sampleSeed;
    }

    public IRunningAggregateEvaluator createRunningAggregateEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
        final int sampleCardinalityTargetPerPartition = SampleSlotRunningAggregateFunctionFactory.getSampleCardinalityTargetPerPartition(this.sampleCardinalityTarget, ctx.getTaskContext().getPartitionCount());
        return new IRunningAggregateEvaluator(){
            private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
            private final DataOutput resultOutput = this.resultStorage.getDataOutput();
            private final ISerializerDeserializer<AInt32> int32Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);
            private final AMutableInt32 aInt32 = new AMutableInt32(0);
            private final Random rnd;
            private long counter;
            {
                this.rnd = new Random(SampleSlotRunningAggregateFunctionFactory.this.sampleSeed);
            }

            public void init() {
                this.counter = 0L;
            }

            public void step(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                try {
                    ++this.counter;
                    int outValue = this.evaluate();
                    this.resultStorage.reset();
                    this.aInt32.setValue(outValue);
                    this.int32Serde.serialize((Object)this.aInt32, this.resultOutput);
                    result.set((IValueReference)this.resultStorage);
                }
                catch (IOException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
            }

            private int evaluate() {
                if (this.counter <= (long)sampleCardinalityTargetPerPartition) {
                    return (int)this.counter;
                }
                long v = 1L + (long)(this.rnd.nextDouble() * (double)this.counter);
                return v <= (long)sampleCardinalityTargetPerPartition ? (int)v : 0;
            }
        };
    }

    private static int getSampleCardinalityTargetPerPartition(int sampleCardinalityTarget, int nPartitions) {
        return Math.max(1, sampleCardinalityTarget / nPartitions + Math.min(sampleCardinalityTarget % nPartitions, 1));
    }
}

