/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.operators;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.runtime.operators.LSMSecondaryUpsertOperatorNodePushable;
import org.apache.asterix.transaction.management.opcallbacks.AbstractIndexModificationOperationCallback;
import org.apache.hyracks.algebricks.data.IBinaryIntegerInspectorFactory;
import org.apache.hyracks.algebricks.runtime.base.AlgebricksPipeline;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntime;
import org.apache.hyracks.algebricks.runtime.operators.meta.PipelineAssembler;
import org.apache.hyracks.algebricks.runtime.operators.std.NestedTupleSourceRuntimeFactory;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.tuples.ConcatenatingTupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;

public class LSMSecondaryUpsertWithNestedPlanOperatorNodePushable
extends LSMSecondaryUpsertOperatorNodePushable {
    private final NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime[] startOfNewKeyPipelines;
    private final NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime[] startOfPrevKeyPipelines;
    private final int numberOfPrimaryKeyAndFilterFields;

    public LSMSecondaryUpsertWithNestedPlanOperatorNodePushable(IHyracksTaskContext ctx, int partition, IIndexDataflowHelperFactory indexHelperFactory, IModificationOperationCallbackFactory modCallbackFactory, int[] fieldPermutation, RecordDescriptor inputRecDesc, int operationFieldIndex, IBinaryIntegerInspectorFactory operationInspectorFactory, List<AlgebricksPipeline> secondaryKeysPipeline, List<AlgebricksPipeline> prevSecondaryKeysPipeline) throws HyracksDataException {
        super(ctx, partition, indexHelperFactory, modCallbackFactory, null, null, fieldPermutation, inputRecDesc, operationFieldIndex, operationInspectorFactory, null);
        this.numberOfPrimaryKeyAndFilterFields = fieldPermutation.length;
        this.startOfNewKeyPipelines = this.buildStartOfPipelines(secondaryKeysPipeline, inputRecDesc, false);
        this.startOfPrevKeyPipelines = this.buildStartOfPipelines(prevSecondaryKeysPipeline, inputRecDesc, true);
    }

    private NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime[] buildStartOfPipelines(List<AlgebricksPipeline> pipelines, RecordDescriptor inputRecordDescriptor, boolean isPrev) throws HyracksDataException {
        NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime[] resultant = new NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime[pipelines.size()];
        PipelineAssembler[] pipelineAssemblers = new PipelineAssembler[pipelines.size()];
        for (int p = 0; p < pipelines.size(); ++p) {
            IndexTupleUnconditionalOperation outputWriter;
            AlgebricksPipeline pipeline = pipelines.get(p);
            RecordDescriptor lastRecordDescriptorInPipeline = pipeline.getRecordDescriptors()[pipeline.getRecordDescriptors().length - 1];
            if (p == 0) {
                outputWriter = new IndexTupleUnconditionalOperation(lastRecordDescriptorInPipeline, !isPrev);
            } else {
                IPushRuntime outputPushRuntime = PipelineAssembler.linkPipeline((AlgebricksPipeline)pipeline, (PipelineAssembler[])pipelineAssemblers, (int)p);
                if (outputPushRuntime == null) {
                    throw new RuntimeDataException(org.apache.asterix.common.exceptions.ErrorCode.ILLEGAL_STATE, new Serializable[]{"No output runtime factories found."});
                }
                outputPushRuntime.setInputRecordDescriptor(0, lastRecordDescriptorInPipeline);
                outputWriter = outputPushRuntime;
            }
            PipelineAssembler pipelineAssembler = new PipelineAssembler(pipeline, 1, 1, inputRecordDescriptor, lastRecordDescriptorInPipeline);
            resultant[p] = (NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime)pipelineAssembler.assemblePipeline((IFrameWriter)outputWriter, this.ctx);
            pipelineAssemblers[p] = pipelineAssembler;
        }
        return resultant;
    }

    @Override
    public void open() throws HyracksDataException {
        super.open();
        this.frameTuple = new FrameTupleReference();
        this.abstractModCallback = (AbstractIndexModificationOperationCallback)this.modCallback;
    }

    @Override
    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.accessor.reset(buffer);
        int tupleCount = this.accessor.getTupleCount();
        for (int i = 0; i < tupleCount; ++i) {
            this.tuple.reset((IFrameTupleAccessor)this.accessor, i);
            this.writeTupleToPipelineStarts(buffer, i, this.startOfPrevKeyPipelines);
            this.frameTuple.reset((IFrameTupleAccessor)this.accessor, i);
            int operation = this.operationInspector.getIntegerValue(this.frameTuple.getFieldData(this.operationFieldIndex), this.frameTuple.getFieldStart(this.operationFieldIndex), this.frameTuple.getFieldLength(this.operationFieldIndex));
            if (operation != UPSERT_NEW && operation != UPSERT_EXISTING) continue;
            this.writeTupleToPipelineStarts(buffer, i, this.startOfNewKeyPipelines);
        }
        this.writeBuffer.ensureFrameSize(buffer.capacity());
        FrameUtils.copyAndFlip((ByteBuffer)buffer, (ByteBuffer)this.writeBuffer.getBuffer());
        FrameUtils.flushFrame((ByteBuffer)this.writeBuffer.getBuffer(), (IFrameWriter)this.writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTupleToPipelineStarts(ByteBuffer buffer, int tupleIndex, NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime[] pipelineStarts) throws HyracksDataException {
        for (NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime nts : pipelineStarts) {
            nts.writeTuple(buffer, tupleIndex);
        }
        try {
            for (int n = 0; n < pipelineStarts.length; ++n) {
                NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime nts = pipelineStarts[n];
                try {
                    nts.open();
                    continue;
                }
                catch (Exception e) {
                    nts.fail();
                    throw e;
                }
            }
        }
        finally {
            for (int j = n - 1; j >= 0; --j) {
                pipelineStarts[j].close();
            }
        }
    }

    private class IndexTupleUnconditionalOperation
    implements IFrameWriter {
        private final RecordDescriptor inputRecordDescriptor;
        private final boolean isInsert;
        private FrameTupleAccessor endOfPipelineTupleAccessor;
        private FrameTupleReference endOfPipelineTupleReference;
        private ConcatenatingTupleReference endTupleReference;

        private IndexTupleUnconditionalOperation(RecordDescriptor recordDescriptor, boolean isInsert) {
            this.inputRecordDescriptor = recordDescriptor;
            this.isInsert = isInsert;
        }

        public void open() throws HyracksDataException {
            this.endTupleReference = new ConcatenatingTupleReference(2);
            this.endOfPipelineTupleAccessor = new FrameTupleAccessor(this.inputRecordDescriptor);
            this.endOfPipelineTupleReference = new FrameTupleReference();
        }

        public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
            ILSMIndexAccessor workingLSMAccessor = (ILSMIndexAccessor)LSMSecondaryUpsertWithNestedPlanOperatorNodePushable.this.indexAccessor;
            this.endOfPipelineTupleAccessor.reset(buffer);
            int nTuple = this.endOfPipelineTupleAccessor.getTupleCount();
            for (int t = 0; t < nTuple; ++t) {
                this.endOfPipelineTupleReference.reset((IFrameTupleAccessor)this.endOfPipelineTupleAccessor, t);
                if (LSMSecondaryUpsertOperatorNodePushable.hasNullOrMissing(this.endOfPipelineTupleReference)) continue;
                this.endTupleReference.reset();
                this.endTupleReference.addTuple((ITupleReference)this.endOfPipelineTupleReference);
                this.endTupleReference.addTuple((ITupleReference)LSMSecondaryUpsertWithNestedPlanOperatorNodePushable.this.tuple);
                if (this.isInsert) {
                    LSMSecondaryUpsertWithNestedPlanOperatorNodePushable.this.abstractModCallback.setOp(AbstractIndexModificationOperationCallback.Operation.INSERT);
                    try {
                        workingLSMAccessor.forceInsert((ITupleReference)this.endTupleReference);
                        continue;
                    }
                    catch (HyracksDataException e) {
                        if (e.matches((IError)ErrorCode.DUPLICATE_KEY)) continue;
                        throw e;
                    }
                }
                LSMSecondaryUpsertWithNestedPlanOperatorNodePushable.this.abstractModCallback.setOp(AbstractIndexModificationOperationCallback.Operation.DELETE);
                workingLSMAccessor.forceDelete((ITupleReference)this.endTupleReference);
            }
        }

        public void fail() throws HyracksDataException {
        }

        public void close() throws HyracksDataException {
        }
    }
}

