/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.connectors;

import java.util.BitSet;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.IPartitionCollector;
import org.apache.hyracks.api.comm.IPartitionWriterFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionComputerFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IConnectorDescriptorRegistry;
import org.apache.hyracks.dataflow.common.data.partition.OnePartitionComputerFactory;
import org.apache.hyracks.dataflow.std.base.AbstractMToNConnectorDescriptor;
import org.apache.hyracks.dataflow.std.collectors.DeterministicPartitionBatchManager;
import org.apache.hyracks.dataflow.std.collectors.PartitionCollector;
import org.apache.hyracks.dataflow.std.collectors.SequentialMergeFrameReader;
import org.apache.hyracks.dataflow.std.connectors.PartitionDataWriter;

public class MToOneSequentialMergingConnectorDescriptor
extends AbstractMToNConnectorDescriptor {
    private static final long serialVersionUID = 1L;
    private final ITuplePartitionComputerFactory tpcf = new OnePartitionComputerFactory();

    public MToOneSequentialMergingConnectorDescriptor(IConnectorDescriptorRegistry spec) {
        super(spec);
    }

    public IFrameWriter createPartitioner(IHyracksTaskContext ctx, RecordDescriptor recordDesc, IPartitionWriterFactory edwFactory, int index, int nProducerPartitions, int nConsumerPartitions) throws HyracksDataException {
        return new PartitionDataWriter(ctx, nConsumerPartitions, edwFactory, recordDesc, this.tpcf.createPartitioner(ctx));
    }

    @Override
    public IPartitionCollector createPartitionCollector(IHyracksTaskContext ctx, RecordDescriptor recordDesc, int index, int nProducerPartitions, int nConsumerPartitions) throws HyracksDataException {
        DeterministicPartitionBatchManager pbm = new DeterministicPartitionBatchManager(nProducerPartitions);
        SequentialMergeFrameReader sequentialMergeReader = new SequentialMergeFrameReader(nProducerPartitions, pbm);
        BitSet expectedPartitions = new BitSet();
        expectedPartitions.set(0, nProducerPartitions);
        return new PartitionCollector(ctx, this.getConnectorId(), index, expectedPartitions, sequentialMergeReader, pbm);
    }
}

