/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.s3guard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.hadoop.fs.s3a.s3guard.DirListingMetadata;
import org.apache.hadoop.fs.s3a.s3guard.MetadataStore;
import org.apache.hadoop.fs.s3a.s3guard.PathMetadata;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class MetadataStoreListFilesIterator
implements RemoteIterator<S3AFileStatus> {
    public static final Logger LOG = LoggerFactory.getLogger(MetadataStoreListFilesIterator.class);
    private final boolean allowAuthoritative;
    private final MetadataStore metadataStore;
    private final Set<Path> tombstones = new HashSet<Path>();
    private final boolean recursivelyAuthoritative;
    private Iterator<S3AFileStatus> leafNodesIterator = null;

    public MetadataStoreListFilesIterator(MetadataStore ms, PathMetadata meta, boolean allowAuthoritative) throws IOException {
        Preconditions.checkNotNull((Object)ms);
        this.metadataStore = ms;
        this.allowAuthoritative = allowAuthoritative;
        this.recursivelyAuthoritative = this.prefetch(meta);
    }

    private boolean prefetch(PathMetadata meta) throws IOException {
        LinkedList<PathMetadata> queue = new LinkedList<PathMetadata>();
        ArrayList<S3AFileStatus> leafNodes = new ArrayList<S3AFileStatus>();
        boolean allListingsAuthoritative = true;
        if (meta != null) {
            Path path = meta.getFileStatus().getPath();
            if (path.isRoot()) {
                DirListingMetadata rootListing = this.metadataStore.listChildren(path);
                if (rootListing != null) {
                    if (!rootListing.isAuthoritative()) {
                        allListingsAuthoritative = false;
                    }
                    this.tombstones.addAll(rootListing.listTombstones());
                    queue.addAll(rootListing.withoutTombstones().getListing());
                }
            } else {
                queue.add(meta);
            }
        } else {
            allListingsAuthoritative = false;
        }
        while (!queue.isEmpty()) {
            PathMetadata nextMetadata = (PathMetadata)queue.poll();
            S3AFileStatus nextStatus = nextMetadata.getFileStatus();
            if (nextStatus.isFile()) {
                leafNodes.add(nextStatus);
                continue;
            }
            if (!nextStatus.isDirectory()) continue;
            Path path = nextStatus.getPath();
            DirListingMetadata children = this.metadataStore.listChildren(path);
            if (children != null) {
                if (!children.isAuthoritative()) {
                    allListingsAuthoritative = false;
                }
                this.tombstones.addAll(children.listTombstones());
                Collection<PathMetadata> liveChildren = children.withoutTombstones().getListing();
                if (!liveChildren.isEmpty()) {
                    queue.addAll(liveChildren);
                    continue;
                }
                if (!this.allowAuthoritative || !children.isAuthoritative()) continue;
                leafNodes.add(nextStatus);
                continue;
            }
            allListingsAuthoritative = false;
        }
        this.leafNodesIterator = leafNodes.iterator();
        return allListingsAuthoritative;
    }

    public boolean hasNext() {
        return this.leafNodesIterator.hasNext();
    }

    public S3AFileStatus next() {
        return this.leafNodesIterator.next();
    }

    public boolean isRecursivelyAuthoritative() {
        return this.recursivelyAuthoritative;
    }

    public Set<Path> listTombstones() {
        return this.tombstones;
    }
}

