/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical;

import java.util.ArrayList;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.VariablePropagationPolicy;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;

public class LimitOperator
extends AbstractLogicalOperator {
    private final Mutable<ILogicalExpression> maxObjects;
    private final Mutable<ILogicalExpression> offset;
    private final boolean topmost;

    public LimitOperator(ILogicalExpression maxObjectsExpr, ILogicalExpression offsetExpr, boolean topmost) {
        if (maxObjectsExpr == null && offsetExpr == null) {
            throw new IllegalArgumentException();
        }
        this.maxObjects = new MutableObject((Object)maxObjectsExpr);
        this.offset = new MutableObject((Object)offsetExpr);
        this.topmost = topmost;
    }

    public LimitOperator(ILogicalExpression maxObjects, ILogicalExpression offset) {
        this(maxObjects, offset, true);
    }

    public LimitOperator(ILogicalExpression maxObjectsExpr, boolean topmost) {
        this(maxObjectsExpr, null, topmost);
    }

    public LimitOperator(ILogicalExpression maxObjects) {
        this(maxObjects, true);
    }

    public boolean hasMaxObjects() {
        return this.maxObjects.getValue() != null;
    }

    public Mutable<ILogicalExpression> getMaxObjects() {
        return this.maxObjects;
    }

    public boolean hasOffset() {
        return this.offset.getValue() != null;
    }

    public Mutable<ILogicalExpression> getOffset() {
        return this.offset;
    }

    public boolean isTopmostLimitOp() {
        return this.topmost;
    }

    @Override
    public void recomputeSchema() {
        this.schema = new ArrayList();
        this.schema.addAll(((ILogicalOperator)((Mutable)this.inputs.get(0)).getValue()).getSchema());
    }

    @Override
    public <R, T> R accept(ILogicalOperatorVisitor<R, T> visitor, T arg) throws AlgebricksException {
        return visitor.visitLimitOperator(this, arg);
    }

    @Override
    public boolean acceptExpressionTransform(ILogicalExpressionReferenceTransform visitor) throws AlgebricksException {
        boolean b = false;
        if (this.hasMaxObjects()) {
            b = visitor.transform(this.maxObjects);
        }
        if (this.hasOffset()) {
            b |= visitor.transform(this.offset);
        }
        return b;
    }

    @Override
    public LogicalOperatorTag getOperatorTag() {
        return LogicalOperatorTag.LIMIT;
    }

    @Override
    public VariablePropagationPolicy getVariablePropagationPolicy() {
        return VariablePropagationPolicy.ALL;
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public IVariableTypeEnvironment computeOutputTypeEnvironment(ITypingContext ctx) throws AlgebricksException {
        return this.createPropagatingAllInputsTypeEnvironment(ctx);
    }
}

