/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import org.apache.hyracks.algebricks.core.algebra.properties.TypePropagationPolicy;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypeEnvPointer;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.typing.OpRefTypeEnvPointer;
import org.apache.hyracks.algebricks.core.algebra.typing.PropagatingTypeEnvironment;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.SourceLocation;

public abstract class AbstractLogicalOperator
implements ILogicalOperator {
    private ExecutionMode mode = ExecutionMode.UNPARTITIONED;
    protected IPhysicalOperator physicalOperator;
    private final Map<String, Object> annotations = new HashMap<String, Object>();
    private boolean bJobGenEnabled = true;
    protected final List<Mutable<ILogicalOperator>> inputs = new ArrayList<Mutable<ILogicalOperator>>();
    protected List<LogicalVariable> schema;
    private SourceLocation sourceLoc;

    @Override
    public abstract LogicalOperatorTag getOperatorTag();

    @Override
    public ExecutionMode getExecutionMode() {
        return this.mode;
    }

    public void setExecutionMode(ExecutionMode mode) {
        this.mode = mode;
    }

    @Override
    public List<LogicalVariable> getSchema() {
        return this.schema;
    }

    public void setSchema(List<LogicalVariable> schema) {
        if (schema == null) {
            return;
        }
        this.schema = new ArrayList<LogicalVariable>();
        this.schema.addAll(schema);
    }

    public void setPhysicalOperator(IPhysicalOperator physicalOp) {
        this.physicalOperator = physicalOp;
    }

    public IPhysicalOperator getPhysicalOperator() {
        return this.physicalOperator;
    }

    @Override
    public final PhysicalRequirements getRequiredPhysicalPropertiesForChildren(IPhysicalPropertiesVector requiredProperties, IOptimizationContext context) throws AlgebricksException {
        return this.physicalOperator.getRequiredPropertiesForChildren(this, requiredProperties, context);
    }

    @Override
    public final IPhysicalPropertiesVector getDeliveredPhysicalProperties() {
        return this.physicalOperator.getDeliveredProperties();
    }

    @Override
    public final void computeDeliveredPhysicalProperties(IOptimizationContext context) throws AlgebricksException {
        this.physicalOperator.computeDeliveredProperties(this, context);
    }

    @Override
    public final List<Mutable<ILogicalOperator>> getInputs() {
        return this.inputs;
    }

    @Override
    public final boolean hasInputs() {
        return !this.inputs.isEmpty();
    }

    public boolean hasNestedPlans() {
        return false;
    }

    @Override
    public Map<String, Object> getAnnotations() {
        return this.annotations;
    }

    @Override
    public void removeAnnotation(String annotationName) {
        this.annotations.remove(annotationName);
    }

    @Override
    public final void contributeRuntimeOperator(IHyracksJobBuilder builder, JobGenContext context, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IOperatorSchema outerPlanSchema) throws AlgebricksException {
        if (this.bJobGenEnabled) {
            if (this.physicalOperator == null) {
                throw AlgebricksException.create((ErrorCode)ErrorCode.PHYS_OPERATOR_NOT_SET, (SourceLocation)this.getSourceLocation(), (Serializable[])new Serializable[]{this.getOperatorTag()});
            }
            this.physicalOperator.contributeRuntimeOperator(builder, context, this, propagatedSchema, inputSchemas, outerPlanSchema);
        }
    }

    public void disableJobGen() {
        this.bJobGenEnabled = false;
    }

    public boolean isJobGenEnabled() {
        return this.bJobGenEnabled;
    }

    @Override
    public IVariableTypeEnvironment computeInputTypeEnvironment(ITypingContext ctx) throws AlgebricksException {
        return this.createPropagatingAllInputsTypeEnvironment(ctx);
    }

    protected PropagatingTypeEnvironment createPropagatingAllInputsTypeEnvironment(ITypingContext ctx) {
        int n = this.inputs.size();
        ITypeEnvPointer[] envPointers = new ITypeEnvPointer[n];
        for (int i = 0; i < n; ++i) {
            envPointers[i] = new OpRefTypeEnvPointer(this.inputs.get(i), ctx);
        }
        return new PropagatingTypeEnvironment(ctx.getExpressionTypeComputer(), ctx.getMissableTypeComputer(), ctx.getMetadataProvider(), TypePropagationPolicy.ALL, envPointers);
    }

    @Override
    public boolean requiresVariableReferenceExpressions() {
        return true;
    }

    @Override
    public SourceLocation getSourceLocation() {
        return this.sourceLoc;
    }

    public void setSourceLocation(SourceLocation sourceLoc) {
        this.sourceLoc = sourceLoc;
    }

    public static enum ExecutionMode {
        UNPARTITIONED,
        PARTITIONED,
        LOCAL;

    }
}

