/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.btree.impls;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.utils.TupleUtils;
import org.apache.hyracks.storage.am.btree.api.IBTreeInteriorFrame;
import org.apache.hyracks.storage.am.btree.api.IBTreeLeafFrame;
import org.apache.hyracks.storage.am.btree.api.ITupleAcceptor;
import org.apache.hyracks.storage.am.btree.frames.BTreeNSMInteriorFrame;
import org.apache.hyracks.storage.am.btree.impls.BTreeCountingSearchCursor;
import org.apache.hyracks.storage.am.btree.impls.BTreeOpContext;
import org.apache.hyracks.storage.am.btree.impls.BTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.btree.impls.BTreeSplitKey;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.btree.impls.UnconditionalTupleAcceptor;
import org.apache.hyracks.storage.am.common.api.IBTreeIndexTupleReference;
import org.apache.hyracks.storage.am.common.api.IPageManager;
import org.apache.hyracks.storage.am.common.api.ISplitKey;
import org.apache.hyracks.storage.am.common.api.ITreeIndexAccessor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import org.apache.hyracks.storage.am.common.frames.FrameOpSpaceStatus;
import org.apache.hyracks.storage.am.common.impls.AbstractTreeIndex;
import org.apache.hyracks.storage.am.common.impls.NoOpIndexAccessParameters;
import org.apache.hyracks.storage.am.common.impls.NodeFrontier;
import org.apache.hyracks.storage.am.common.impls.TreeIndexDiskOrderScanCursor;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexAccessor;
import org.apache.hyracks.storage.common.IIndexBulkLoader;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.storage.common.NoOpIndexCursorStats;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.buffercache.IExtraPageBlockHelper;
import org.apache.hyracks.storage.common.buffercache.IPageWriteCallback;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;
import org.apache.hyracks.util.JSONUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BTree
extends AbstractTreeIndex {
    public static final float DEFAULT_FILL_FACTOR = 0.7f;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long RESTART_OP = Long.MIN_VALUE;
    private static final long FULL_RESTART_OP = -9223372036854775807L;
    private static final int MAX_RESTARTS = 10;
    private final AtomicInteger smoCounter;
    private final ReadWriteLock treeLatch = new ReentrantReadWriteLock(true);
    private final int maxTupleSize;

    public BTree(IBufferCache bufferCache, IPageManager freePageManager, ITreeIndexFrameFactory interiorFrameFactory, ITreeIndexFrameFactory leafFrameFactory, IBinaryComparatorFactory[] cmpFactories, int fieldCount, FileReference file) {
        super(bufferCache, freePageManager, interiorFrameFactory, leafFrameFactory, cmpFactories, fieldCount, file);
        this.smoCounter = new AtomicInteger();
        ITreeIndexFrame leafFrame = leafFrameFactory.createFrame();
        ITreeIndexFrame interiorFrame = interiorFrameFactory.createFrame();
        this.maxTupleSize = Math.min(leafFrame.getMaxTupleSize(bufferCache.getPageSize()), interiorFrame.getMaxTupleSize(bufferCache.getPageSize()));
    }

    private void diskOrderScan(ITreeIndexCursor icursor, BTreeOpContext ctx) throws HyracksDataException {
        TreeIndexDiskOrderScanCursor cursor = (TreeIndexDiskOrderScanCursor)icursor;
        ctx.reset();
        RangePredicate diskOrderScanPred = new RangePredicate(null, null, true, true, ctx.getCmp(), ctx.getCmp());
        int maxPageId = this.freePageManager.getMaxPageId(ctx.getMetaFrame());
        int currentPageId = this.bulkloadLeafStart;
        ICachedPage page = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.getFileId(), (int)currentPageId), false);
        page.acquireReadLatch();
        try {
            cursor.setBufferCache(this.bufferCache);
            cursor.setFileId(this.getFileId());
            cursor.setCurrentPageId(currentPageId);
            cursor.setMaxPageId(maxPageId);
            ctx.getCursorInitialState().setPage(page);
            ctx.getCursorInitialState().setSearchOperationCallback(ctx.getSearchCallback());
            ctx.getCursorInitialState().setOriginialKeyComparator(ctx.getCmp());
            cursor.open((ICursorInitialState)ctx.getCursorInitialState(), (ISearchPredicate)diskOrderScanPred);
        }
        catch (Exception e) {
            page.releaseReadLatch();
            this.bufferCache.unpin(page);
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public void validate() throws HyracksDataException {
        BTreeAccessor accessor = this.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
        BTreeOpContext.PageValidationInfo pvi = accessor.ctx.createPageValidationInfo(null);
        accessor.ctx.getValidationInfos().addFirst(pvi);
        if (this.isActive) {
            this.validate(accessor.ctx, this.rootPage);
        }
    }

    private void validate(BTreeOpContext ctx, int pageId) throws HyracksDataException {
        ICachedPage page = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.getFileId(), (int)pageId), false);
        ctx.getInteriorFrame().setPage(page);
        BTreeOpContext.PageValidationInfo currentPvi = ctx.getValidationInfos().peekFirst();
        boolean isLeaf = ctx.getInteriorFrame().isLeaf();
        if (isLeaf) {
            ctx.getLeafFrame().setPage(page);
            ctx.getLeafFrame().validate(currentPvi);
        } else {
            BTreeOpContext.PageValidationInfo nextPvi = ctx.createPageValidationInfo(currentPvi);
            ArrayList<Integer> children = ((BTreeNSMInteriorFrame)ctx.getInteriorFrame()).getChildren(ctx.getCmp());
            ctx.getInteriorFrame().validate(currentPvi);
            for (int i = 0; i < children.size(); ++i) {
                ctx.getInteriorFrame().setPage(page);
                if (children.size() == 1) {
                    nextPvi.propagateLowRangeKey(currentPvi);
                    nextPvi.propagateHighRangeKey(currentPvi);
                } else if (i == 0) {
                    nextPvi.propagateLowRangeKey(currentPvi);
                    ctx.getInteriorFrameTuple().resetByTupleIndex((ITreeIndexFrame)ctx.getInteriorFrame(), i);
                    nextPvi.adjustHighRangeKey((ITupleReference)ctx.getInteriorFrameTuple());
                } else if (i == children.size() - 1) {
                    nextPvi.propagateHighRangeKey(currentPvi);
                    ctx.getInteriorFrameTuple().resetByTupleIndex((ITreeIndexFrame)ctx.getInteriorFrame(), i - 1);
                    nextPvi.adjustLowRangeKey((ITupleReference)ctx.getInteriorFrameTuple());
                } else {
                    ctx.getInteriorFrameTuple().resetByTupleIndex((ITreeIndexFrame)ctx.getInteriorFrame(), i - 1);
                    nextPvi.adjustLowRangeKey((ITupleReference)ctx.getInteriorFrameTuple());
                    ctx.getInteriorFrameTuple().resetByTupleIndex((ITreeIndexFrame)ctx.getInteriorFrame(), i);
                    nextPvi.adjustHighRangeKey((ITupleReference)ctx.getInteriorFrameTuple());
                }
                ctx.getValidationInfos().addFirst(nextPvi);
                this.validate(ctx, (Integer)children.get(i));
            }
        }
        this.bufferCache.unpin(page);
        ctx.getValidationInfos().removeFirst();
    }

    private void search(ITreeIndexCursor cursor, ISearchPredicate searchPred, BTreeOpContext ctx) throws HyracksDataException {
        ctx.reset();
        ctx.setPred((RangePredicate)searchPred);
        ctx.setCursor(cursor);
        if (ctx.getPred().getLowKeyComparator() == null) {
            ctx.getPred().setLowKeyComparator(ctx.getCmp());
        }
        if (ctx.getPred().getHighKeyComparator() == null) {
            ctx.getPred().setHighKeyComparator(ctx.getCmp());
        }
        boolean repeatOp = true;
        while (repeatOp && ctx.getOpRestarts() < 10) {
            this.performOp(this.rootPage, null, true, ctx);
            if (!ctx.getPageLsns().isEmpty() && ctx.getPageLsns().getLast() == Long.MIN_VALUE) {
                ctx.getPageLsns().removeLast();
                continue;
            }
            repeatOp = false;
        }
        cursor.setBufferCache(this.bufferCache);
        cursor.setFileId(this.getFileId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsetSmPages(BTreeOpContext ctx) throws HyracksDataException {
        ICachedPage originalPage = ctx.getInteriorFrame().getPage();
        for (int i = 0; i < ctx.getSmPages().size(); ++i) {
            int pageId = ctx.getSmPages().get(i);
            ICachedPage smPage = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.getFileId(), (int)pageId), false);
            smPage.acquireWriteLatch();
            try {
                ctx.getInteriorFrame().setPage(smPage);
                ctx.getInteriorFrame().setSmFlag(false);
                continue;
            }
            finally {
                smPage.releaseWriteLatch(true);
                this.bufferCache.unpin(smPage);
            }
        }
        if (ctx.getSmPages().size() > 0) {
            if (ctx.getSmoCount() == Integer.MAX_VALUE) {
                this.smoCounter.set(0);
            } else {
                this.smoCounter.incrementAndGet();
            }
            this.treeLatch.writeLock().unlock();
            ctx.getSmPages().clear();
        }
        ctx.getInteriorFrame().setPage(originalPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewRoot(BTreeOpContext ctx) throws HyracksDataException {
        ICachedPage leftNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.getFileId(), (int)ctx.getSplitKey().getLeftPage()), false);
        leftNode.acquireWriteLatch();
        try {
            int newLeftId = this.freePageManager.takePage(ctx.getMetaFrame());
            ICachedPage newLeftNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.getFileId(), (int)newLeftId), true);
            newLeftNode.acquireWriteLatch();
            try {
                boolean largePage = false;
                if (leftNode.getBuffer().capacity() > newLeftNode.getBuffer().capacity()) {
                    this.bufferCache.resizePage(newLeftNode, leftNode.getBuffer().capacity() / this.bufferCache.getPageSize(), (IExtraPageBlockHelper)ctx);
                    largePage = true;
                }
                System.arraycopy(leftNode.getBuffer().array(), 0, newLeftNode.getBuffer().array(), 0, newLeftNode.getBuffer().capacity());
                ctx.getInteriorFrame().setPage(newLeftNode);
                ctx.getInteriorFrame().setSmFlag(false);
                long leftNodeLSN = ctx.getInteriorFrame().getPageLsn();
                if (largePage) {
                    this.bufferCache.resizePage(leftNode, 1, (IExtraPageBlockHelper)ctx);
                    ctx.getInteriorFrame().setPage(leftNode);
                    ctx.getInteriorFrame().setLargeFlag(false);
                } else {
                    ctx.getInteriorFrame().setPage(leftNode);
                    ctx.getInteriorFrame().setLargeFlag(false);
                }
                ctx.getInteriorFrame().initBuffer((byte)(ctx.getInteriorFrame().getLevel() + 1));
                ctx.getInteriorFrame().setPageLsn(leftNodeLSN);
                ctx.getInteriorFrame().setSmFlag(true);
                ctx.getSplitKey().setLeftPage(newLeftId);
                int targetTupleIndex = ctx.getInteriorFrame().findInsertTupleIndex((ITupleReference)ctx.getSplitKey().getTuple());
                int tupleSize = ctx.getInteriorFrame().getBytesRequiredToWriteTuple((ITupleReference)ctx.getSplitKey().getTuple());
                if (tupleSize > this.maxTupleSize) {
                    throw HyracksDataException.create((ErrorCode)ErrorCode.RECORD_IS_TOO_LARGE, (Serializable[])new Serializable[]{Integer.valueOf(tupleSize), Integer.valueOf(this.maxTupleSize)});
                }
                ctx.getInteriorFrame().insert((ITupleReference)ctx.getSplitKey().getTuple(), targetTupleIndex);
            }
            finally {
                newLeftNode.releaseWriteLatch(true);
                this.bufferCache.unpin(newLeftNode);
            }
        }
        finally {
            leftNode.releaseWriteLatch(true);
            this.bufferCache.unpin(leftNode);
        }
    }

    private boolean insertLeaf(ITupleReference tuple, int targetTupleIndex, int pageId, BTreeOpContext ctx) throws Exception {
        boolean restartOp = false;
        FrameOpSpaceStatus spaceStatus = ctx.getLeafFrame().hasSpaceInsert(tuple);
        switch (spaceStatus) {
            case EXPAND: {
                ctx.getLeafFrame().ensureCapacity(this.bufferCache, tuple, ctx);
            }
            case SUFFICIENT_CONTIGUOUS_SPACE: {
                ctx.getModificationCallback().found(null, tuple);
                ctx.getLeafFrame().insert(tuple, targetTupleIndex);
                ctx.getSplitKey().reset();
                break;
            }
            case SUFFICIENT_SPACE: {
                int finalIndex = ctx.getLeafFrame().compact() ? ctx.getLeafFrame().findInsertTupleIndex(tuple) : targetTupleIndex;
                ctx.getModificationCallback().found(null, tuple);
                ctx.getLeafFrame().insert(tuple, finalIndex);
                ctx.getSplitKey().reset();
                break;
            }
            case INSUFFICIENT_SPACE: {
                if (ctx.getLeafFrame().compress() && ctx.getLeafFrame().hasSpaceInsert(tuple) == FrameOpSpaceStatus.SUFFICIENT_CONTIGUOUS_SPACE) {
                    ctx.getModificationCallback().found(null, tuple);
                    ctx.getLeafFrame().insert(tuple, ctx.getLeafFrame().findInsertTupleIndex(tuple));
                    ctx.getSplitKey().reset();
                    break;
                }
                restartOp = this.performLeafSplit(pageId, tuple, ctx, -1);
                break;
            }
            default: {
                throw new IllegalStateException("NYI: " + spaceStatus);
            }
        }
        return restartOp;
    }

    private boolean performLeafSplit(int pageId, ITupleReference tuple, BTreeOpContext ctx, int updateTupleIndex) throws Exception {
        if (!this.treeLatch.writeLock().tryLock()) {
            return true;
        }
        int tempSmoCount = this.smoCounter.get();
        if (tempSmoCount != ctx.getSmoCount()) {
            this.treeLatch.writeLock().unlock();
            return true;
        }
        int rightPageId = this.freePageManager.takePage(ctx.getMetaFrame());
        ICachedPage rightNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.getFileId(), (int)rightPageId), true);
        rightNode.acquireWriteLatch();
        try {
            IBTreeLeafFrame rightFrame = ctx.createLeafFrame();
            rightFrame.setPage(rightNode);
            rightFrame.initBuffer((byte)0);
            rightFrame.setMultiComparator(ctx.getCmp());
            if (updateTupleIndex != -1) {
                ITupleReference beforeTuple = ctx.getLeafFrame().getMatchingKeyTuple(tuple, updateTupleIndex);
                ctx.getModificationCallback().found(beforeTuple, tuple);
                ctx.getLeafFrame().delete(tuple, updateTupleIndex);
            } else {
                ctx.getModificationCallback().found(null, tuple);
            }
            ctx.getLeafFrame().split(rightFrame, tuple, ctx.getSplitKey(), ctx, this.bufferCache);
            ctx.getSmPages().add(pageId);
            ctx.getSmPages().add(rightPageId);
            ctx.getLeafFrame().setSmFlag(true);
            rightFrame.setSmFlag(true);
            rightFrame.setNextLeaf(ctx.getLeafFrame().getNextLeaf());
            ctx.getLeafFrame().setNextLeaf(rightPageId);
            rightFrame.setPageLsn(rightFrame.getPageLsn() + 1L);
            ctx.getLeafFrame().setPageLsn(ctx.getLeafFrame().getPageLsn() + 1L);
            ctx.getSplitKey().setPages(pageId, rightPageId);
        }
        catch (Exception e) {
            this.treeLatch.writeLock().unlock();
            throw e;
        }
        finally {
            rightNode.releaseWriteLatch(true);
            this.bufferCache.unpin(rightNode);
        }
        return false;
    }

    private boolean updateLeaf(ITupleReference tuple, int oldTupleIndex, int pageId, BTreeOpContext ctx) throws Exception {
        FrameOpSpaceStatus spaceStatus = ctx.getLeafFrame().hasSpaceUpdate(tuple, oldTupleIndex);
        ITupleReference beforeTuple = ctx.getLeafFrame().getMatchingKeyTuple(tuple, oldTupleIndex);
        IBTreeIndexTupleReference beforeBTreeTuple = (IBTreeIndexTupleReference)beforeTuple;
        ctx.getLeafFrame().getTupleWriter().setUpdated(beforeBTreeTuple.flipUpdated());
        boolean restartOp = false;
        switch (spaceStatus) {
            case SUFFICIENT_INPLACE_SPACE: {
                ctx.getModificationCallback().found(beforeTuple, tuple);
                ctx.getLeafFrame().update(tuple, oldTupleIndex, true);
                ctx.getSplitKey().reset();
                break;
            }
            case EXPAND: {
                ctx.getModificationCallback().found(beforeTuple, tuple);
                ctx.getLeafFrame().delete(tuple, oldTupleIndex);
                ctx.getLeafFrame().compact();
                ctx.getLeafFrame().ensureCapacity(this.bufferCache, tuple, ctx);
                int targetTupleIndex = ctx.getLeafFrame().findInsertTupleIndex(tuple);
                ctx.getLeafFrame().insert(tuple, targetTupleIndex);
                ctx.getSplitKey().reset();
                break;
            }
            case SUFFICIENT_CONTIGUOUS_SPACE: {
                ctx.getModificationCallback().found(beforeTuple, tuple);
                ctx.getLeafFrame().update(tuple, oldTupleIndex, false);
                ctx.getSplitKey().reset();
                break;
            }
            case SUFFICIENT_SPACE: {
                ctx.getModificationCallback().found(beforeTuple, tuple);
                ctx.getLeafFrame().delete(tuple, oldTupleIndex);
                ctx.getLeafFrame().compact();
                int targetTupleIndex = ctx.getLeafFrame().findInsertTupleIndex(tuple);
                ctx.getLeafFrame().insert(tuple, targetTupleIndex);
                ctx.getSplitKey().reset();
                break;
            }
            case INSUFFICIENT_SPACE: {
                restartOp = this.performLeafSplit(pageId, tuple, ctx, oldTupleIndex);
                break;
            }
            default: {
                throw new IllegalStateException("NYI: " + spaceStatus);
            }
        }
        ctx.getLeafFrame().getTupleWriter().setUpdated(false);
        return restartOp;
    }

    private boolean upsertLeaf(ITupleReference tuple, int targetTupleIndex, int pageId, BTreeOpContext ctx) throws Exception {
        ITupleReference beforeTuple = ctx.getLeafFrame().getMatchingKeyTuple(tuple, targetTupleIndex);
        boolean restartOp = ctx.getAcceptor().accept(beforeTuple) ? (beforeTuple == null ? this.insertLeaf(tuple, targetTupleIndex, pageId, ctx) : this.updateLeaf(tuple, targetTupleIndex, pageId, ctx)) : this.insertLeaf(tuple, ctx.getLeafFrame().findInsertTupleIndex(tuple), pageId, ctx);
        return restartOp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertInterior(ICachedPage node, int pageId, ITupleReference tuple, BTreeOpContext ctx) throws Exception {
        ctx.getInteriorFrame().setPage(node);
        int targetTupleIndex = ctx.getInteriorFrame().findInsertTupleIndex(tuple);
        FrameOpSpaceStatus spaceStatus = ctx.getInteriorFrame().hasSpaceInsert(tuple);
        switch (spaceStatus) {
            case INSUFFICIENT_SPACE: {
                int rightPageId = this.freePageManager.takePage(ctx.getMetaFrame());
                ICachedPage rightNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.getFileId(), (int)rightPageId), true);
                rightNode.acquireWriteLatch();
                try {
                    IBTreeInteriorFrame rightFrame = ctx.createInteriorFrame();
                    rightFrame.setPage(rightNode);
                    rightFrame.initBuffer(ctx.getInteriorFrame().getLevel());
                    rightFrame.setMultiComparator(ctx.getCmp());
                    ctx.getInteriorFrame().split(rightFrame, (ITupleReference)ctx.getSplitKey().getTuple(), ctx.getSplitKey(), ctx, this.bufferCache);
                    ctx.getSmPages().add(pageId);
                    ctx.getSmPages().add(rightPageId);
                    ctx.getInteriorFrame().setSmFlag(true);
                    rightFrame.setSmFlag(true);
                    rightFrame.setPageLsn(rightFrame.getPageLsn() + 1L);
                    ctx.getInteriorFrame().setPageLsn(ctx.getInteriorFrame().getPageLsn() + 1L);
                    ctx.getSplitKey().setPages(pageId, rightPageId);
                    break;
                }
                finally {
                    rightNode.releaseWriteLatch(true);
                    this.bufferCache.unpin(rightNode);
                }
            }
            case SUFFICIENT_CONTIGUOUS_SPACE: {
                ctx.getInteriorFrame().insert(tuple, targetTupleIndex);
                ctx.getSplitKey().reset();
                break;
            }
            case SUFFICIENT_SPACE: {
                boolean slotsChanged = ctx.getInteriorFrame().compact();
                if (slotsChanged) {
                    targetTupleIndex = ctx.getInteriorFrame().findInsertTupleIndex(tuple);
                }
                ctx.getInteriorFrame().insert(tuple, targetTupleIndex);
                ctx.getSplitKey().reset();
                break;
            }
            case TOO_LARGE: {
                int tupleSize = ctx.getInteriorFrame().getBytesRequiredToWriteTuple(tuple);
                throw HyracksDataException.create((ErrorCode)ErrorCode.RECORD_IS_TOO_LARGE, (Serializable[])new Serializable[]{Integer.valueOf(tupleSize), Integer.valueOf(this.maxTupleSize)});
            }
            default: {
                throw new IllegalStateException("NYI: " + spaceStatus);
            }
        }
    }

    private boolean deleteLeaf(ICachedPage node, int pageId, ITupleReference tuple, BTreeOpContext ctx) throws Exception {
        if (ctx.getLeafFrame().getTupleCount() == 0) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.UPDATE_OR_DELETE_NON_EXISTENT_KEY, (Serializable[])new Serializable[0]);
        }
        int tupleIndex = ctx.getLeafFrame().findDeleteTupleIndex(tuple);
        ITupleReference beforeTuple = ctx.getLeafFrame().getMatchingKeyTuple(tuple, tupleIndex);
        ctx.getModificationCallback().found(beforeTuple, tuple);
        ctx.getLeafFrame().delete(tuple, tupleIndex);
        return false;
    }

    private final boolean acquireLatch(ICachedPage node, BTreeOpContext ctx, boolean isLeaf) {
        if (!isLeaf || ctx.getOperation() == IndexOperation.SEARCH && !ctx.getCursor().isExclusiveLatchNodes()) {
            node.acquireReadLatch();
            return true;
        }
        node.acquireWriteLatch();
        return false;
    }

    private ICachedPage isConsistent(int pageId, BTreeOpContext ctx) throws Exception {
        boolean isConsistent;
        ICachedPage node = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.getFileId(), (int)pageId), false);
        node.acquireReadLatch();
        ctx.getInteriorFrame().setPage(node);
        boolean bl = isConsistent = ctx.getPageLsns().getLast() == ctx.getInteriorFrame().getPageLsn();
        if (!isConsistent) {
            node.releaseReadLatch();
            this.bufferCache.unpin(node);
            return null;
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performOp(int pageId, ICachedPage parent, boolean parentIsReadLatched, BTreeOpContext ctx) throws HyracksDataException {
        block37: {
            ICachedPage node = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.getFileId(), (int)pageId), false);
            ctx.getInteriorFrame().setPage(node);
            boolean unsafeIsLeaf = ctx.getInteriorFrame().isLeaf();
            boolean isReadLatched = this.acquireLatch(node, ctx, unsafeIsLeaf);
            boolean smFlag = ctx.getInteriorFrame().getSmFlag();
            boolean isLeaf = ctx.getInteriorFrame().isLeaf();
            ctx.getPageLsns().add(ctx.getInteriorFrame().getPageLsn());
            try {
                if (parent != null) {
                    if (parentIsReadLatched) {
                        parent.releaseReadLatch();
                    } else {
                        parent.releaseWriteLatch(true);
                    }
                    this.bufferCache.unpin(parent);
                }
                if (!isLeaf || smFlag) {
                    if (!smFlag) {
                        boolean repeatOp = true;
                        while (repeatOp && ctx.getOpRestarts() < 10) {
                            int childPageId = ctx.getInteriorFrame().getChildPageId(ctx.getPred());
                            this.performOp(childPageId, node, isReadLatched, ctx);
                            node = null;
                            if (!ctx.getPageLsns().isEmpty()) {
                                if (ctx.getPageLsns().getLast() == -9223372036854775807L) break block37;
                                if (ctx.getPageLsns().getLast() == Long.MIN_VALUE) {
                                    ctx.getPageLsns().removeLast();
                                    node = this.isConsistent(pageId, ctx);
                                    if (node != null) {
                                        isReadLatched = true;
                                        continue;
                                    }
                                    ctx.getPageLsns().removeLast();
                                    ctx.getPageLsns().add(Long.MIN_VALUE);
                                    break block37;
                                }
                            }
                            switch (ctx.getOperation()) {
                                case INSERT: 
                                case UPSERT: 
                                case UPDATE: {
                                    if (ctx.getSplitKey().getBuffer() != null) {
                                        ICachedPage interiorNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.getFileId(), (int)pageId), false);
                                        interiorNode.acquireWriteLatch();
                                        try {
                                            this.insertInterior(interiorNode, pageId, (ITupleReference)ctx.getSplitKey().getTuple(), ctx);
                                            break;
                                        }
                                        finally {
                                            interiorNode.releaseWriteLatch(true);
                                            this.bufferCache.unpin(interiorNode);
                                        }
                                    }
                                    this.unsetSmPages(ctx);
                                    break;
                                }
                                case DELETE: {
                                    if (ctx.getSplitKey().getBuffer() == null) break;
                                    throw new HyracksDataException("Split key was propagated during delete. Delete allows empty leaf pages.");
                                }
                            }
                            repeatOp = false;
                        }
                        break block37;
                    }
                    ctx.setOpRestarts(ctx.getOpRestarts() + 1);
                    if (isReadLatched) {
                        node.releaseReadLatch();
                    } else {
                        node.releaseWriteLatch(true);
                    }
                    this.bufferCache.unpin(node);
                    this.treeLatch.readLock().lock();
                    this.treeLatch.readLock().unlock();
                    ctx.getPageLsns().removeLast();
                    ctx.getPageLsns().add(Long.MIN_VALUE);
                    break block37;
                }
                boolean restartOp = false;
                ctx.getLeafFrame().setPage(node);
                switch (ctx.getOperation()) {
                    case INSERT: {
                        int targetTupleIndex = ctx.getLeafFrame().findInsertTupleIndex(ctx.getPred().getLowKey());
                        restartOp = this.insertLeaf(ctx.getPred().getLowKey(), targetTupleIndex, pageId, ctx);
                        break;
                    }
                    case UPSERT: {
                        int targetTupleIndex = ctx.getLeafFrame().findUpsertTupleIndex(ctx.getPred().getLowKey());
                        restartOp = this.upsertLeaf(ctx.getPred().getLowKey(), targetTupleIndex, pageId, ctx);
                        break;
                    }
                    case UPDATE: {
                        int oldTupleIndex = ctx.getLeafFrame().findUpdateTupleIndex(ctx.getPred().getLowKey());
                        restartOp = this.updateLeaf(ctx.getPred().getLowKey(), oldTupleIndex, pageId, ctx);
                        break;
                    }
                    case DELETE: {
                        restartOp = this.deleteLeaf(node, pageId, ctx.getPred().getLowKey(), ctx);
                        break;
                    }
                    case SEARCH: {
                        ctx.getCursorInitialState().setSearchOperationCallback(ctx.getSearchCallback());
                        ctx.getCursorInitialState().setOriginialKeyComparator(ctx.getCmp());
                        ctx.getCursorInitialState().setPage(node);
                        ctx.getCursorInitialState().setPageId(pageId);
                        ctx.getCursor().open((ICursorInitialState)ctx.getCursorInitialState(), (ISearchPredicate)ctx.getPred());
                    }
                }
                if (ctx.getOperation() != IndexOperation.SEARCH) {
                    node.releaseWriteLatch(true);
                    this.bufferCache.unpin(node);
                }
                if (restartOp) {
                    this.treeLatch.readLock().lock();
                    this.treeLatch.readLock().unlock();
                    ctx.getPageLsns().removeLast();
                    ctx.getPageLsns().add(-9223372036854775807L);
                }
            }
            catch (HyracksDataException e) {
                if (!ctx.isExceptionHandled() && node != null) {
                    if (isReadLatched) {
                        node.releaseReadLatch();
                    } else {
                        node.releaseWriteLatch(true);
                    }
                    this.bufferCache.unpin(node);
                    ctx.setExceptionHandled(true);
                }
                throw e;
            }
            catch (Exception e) {
                if (node != null) {
                    if (isReadLatched) {
                        node.releaseReadLatch();
                    } else {
                        node.releaseWriteLatch(true);
                    }
                    this.bufferCache.unpin(node);
                }
                HyracksDataException wrappedException = HyracksDataException.create((Throwable)e);
                ctx.setExceptionHandled(true);
                throw wrappedException;
            }
        }
    }

    private BTreeOpContext createOpContext(IIndexAccessor accessor, IModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback) {
        return new BTreeOpContext(accessor, this.leafFrameFactory, this.interiorFrameFactory, this.freePageManager, this.cmpFactories, modificationCallback, searchCallback);
    }

    public String printTree(IBTreeLeafFrame leafFrame, IBTreeInteriorFrame interiorFrame, ISerializerDeserializer[] keySerdes) throws Exception {
        MultiComparator cmp = MultiComparator.create((IBinaryComparatorFactory[])this.cmpFactories);
        byte treeHeight = this.getTreeHeight(leafFrame);
        StringBuilder strBuilder = new StringBuilder();
        this.printTree(this.rootPage, null, false, leafFrame, interiorFrame, treeHeight, keySerdes, strBuilder, cmp);
        return strBuilder.toString();
    }

    public void printTree(int pageId, ICachedPage parent, boolean unpin, IBTreeLeafFrame leafFrame, IBTreeInteriorFrame interiorFrame, byte treeHeight, ISerializerDeserializer[] keySerdes, StringBuilder strBuilder, MultiComparator cmp) throws Exception {
        ICachedPage node = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.getFileId(), (int)pageId), false);
        node.acquireReadLatch();
        try {
            String keyString;
            if (parent != null && unpin) {
                parent.releaseReadLatch();
                this.bufferCache.unpin(parent);
            }
            interiorFrame.setPage(node);
            byte level = interiorFrame.getLevel();
            strBuilder.append(String.format("%1d ", level));
            strBuilder.append(String.format("%3d ", pageId) + ": ");
            for (int i = 0; i < treeHeight - level; ++i) {
                strBuilder.append("    ");
            }
            if (interiorFrame.isLeaf()) {
                leafFrame.setPage(node);
                keyString = BTree.printLeafFrameTuples(leafFrame, keySerdes);
            } else {
                keyString = BTree.printInteriorFrameTuples(interiorFrame, keySerdes);
            }
            strBuilder.append(keyString + "\n");
            if (!interiorFrame.isLeaf()) {
                ArrayList<Integer> children = ((BTreeNSMInteriorFrame)interiorFrame).getChildren(cmp);
                for (int i = 0; i < children.size(); ++i) {
                    this.printTree(children.get(i), node, i == children.size() - 1, leafFrame, interiorFrame, treeHeight, keySerdes, strBuilder, cmp);
                }
            } else {
                node.releaseReadLatch();
                this.bufferCache.unpin(node);
            }
        }
        catch (Exception e) {
            node.releaseReadLatch();
            this.bufferCache.unpin(node);
        }
    }

    public BTreeAccessor createAccessor(IIndexAccessParameters iap) {
        return new BTreeAccessor(this, iap);
    }

    public IIndexBulkLoader createBulkLoader(float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex, IPageWriteCallback callback) throws HyracksDataException {
        return new BTreeBulkLoader(fillFactor, verifyInput, callback);
    }

    public static String printLeafFrameTuples(IBTreeLeafFrame leafFrame, ISerializerDeserializer[] fieldSerdes) throws HyracksDataException {
        StringBuilder strBuilder = new StringBuilder();
        ITreeIndexTupleReference tuple = leafFrame.createTupleReference();
        for (int i = 0; i < leafFrame.getTupleCount(); ++i) {
            tuple.resetByTupleIndex((ITreeIndexFrame)leafFrame, i);
            String tupleString = TupleUtils.printTuple((ITupleReference)tuple, (ISerializerDeserializer[])fieldSerdes);
            strBuilder.append(tupleString + " | ");
        }
        int rightPageId = leafFrame.getNextLeaf();
        strBuilder.append("(" + rightPageId + ")");
        return strBuilder.toString();
    }

    public static String printInteriorFrameTuples(IBTreeInteriorFrame interiorFrame, ISerializerDeserializer[] fieldSerdes) throws HyracksDataException {
        StringBuilder strBuilder = new StringBuilder();
        ITreeIndexTupleReference tuple = interiorFrame.createTupleReference();
        for (int i = 0; i < interiorFrame.getTupleCount(); ++i) {
            tuple.resetByTupleIndex((ITreeIndexFrame)interiorFrame, i);
            int numFields = tuple.getFieldCount();
            int childPageId = IntegerPointable.getInteger((byte[])tuple.getFieldData(numFields - 1), (int)(tuple.getFieldStart(numFields - 1) + tuple.getFieldLength(numFields - 1)));
            strBuilder.append("(" + childPageId + ") ");
            String tupleString = TupleUtils.printTuple((ITupleReference)tuple, (ISerializerDeserializer[])fieldSerdes);
            strBuilder.append(tupleString + " | ");
        }
        int rightMostChildPageId = interiorFrame.getRightmostChildPageId();
        strBuilder.append("(" + rightMostChildPageId + ")");
        return strBuilder.toString();
    }

    public int getNumOfFilterFields() {
        return 0;
    }

    public class BTreeBulkLoader
    extends AbstractTreeIndex.AbstractTreeIndexBulkLoader {
        protected final ISplitKey splitKey;
        protected final boolean verifyInput;

        public BTreeBulkLoader(float fillFactor, boolean verifyInput, IPageWriteCallback callback) throws HyracksDataException {
            super((AbstractTreeIndex)BTree.this, fillFactor, callback);
            this.verifyInput = verifyInput;
            this.splitKey = new BTreeSplitKey(this.leafFrame.getTupleWriter().createTupleReference());
            this.splitKey.getTuple().setFieldCount(this.cmp.getKeyFieldCount());
        }

        public void add(ITupleReference tuple) throws HyracksDataException {
            try {
                int tupleSize = Math.max(this.leafFrame.getBytesRequiredToWriteTuple(tuple), this.interiorFrame.getBytesRequiredToWriteTuple(tuple));
                NodeFrontier leafFrontier = (NodeFrontier)this.nodeFrontiers.get(0);
                int spaceNeeded = this.tupleWriter.bytesRequired(tuple) + this.slotSize;
                int spaceUsed = this.leafFrame.getBuffer().capacity() - this.leafFrame.getTotalFreeSpace();
                if (spaceUsed + spaceNeeded > this.leafMaxBytes) {
                    this.leafFrame.compress();
                    spaceUsed = this.leafFrame.getBuffer().capacity() - this.leafFrame.getTotalFreeSpace();
                }
                if (spaceUsed + spaceNeeded > this.leafMaxBytes) {
                    if (this.leafFrame.getTupleCount() == 0) {
                        BTree.this.bufferCache.returnPage(leafFrontier.page, false);
                    } else {
                        leafFrontier.lastTuple.resetByTupleIndex(this.leafFrame, this.leafFrame.getTupleCount() - 1);
                        if (this.verifyInput) {
                            this.verifyInputTuple(tuple, (ITupleReference)leafFrontier.lastTuple);
                        }
                        int splitKeySize = this.tupleWriter.bytesRequired((ITupleReference)leafFrontier.lastTuple, 0, this.cmp.getKeyFieldCount());
                        this.splitKey.initData(splitKeySize);
                        this.tupleWriter.writeTupleFields((ITupleReference)leafFrontier.lastTuple, 0, this.cmp.getKeyFieldCount(), this.splitKey.getBuffer().array(), 0);
                        this.splitKey.getTuple().resetByTupleOffset(this.splitKey.getBuffer().array(), 0);
                        this.splitKey.setLeftPage(leafFrontier.pageId);
                        this.propagateBulk(1, this.pagesToWrite);
                        leafFrontier.pageId = BTree.this.freePageManager.takePage(this.metaFrame);
                        ((IBTreeLeafFrame)this.leafFrame).setNextLeaf(leafFrontier.pageId);
                        this.write(leafFrontier.page);
                        for (ICachedPage c : this.pagesToWrite) {
                            this.write(c);
                        }
                        this.pagesToWrite.clear();
                        this.splitKey.setRightPage(leafFrontier.pageId);
                    }
                    if (tupleSize > BTree.this.maxTupleSize) {
                        long dpid = BufferedFileHandle.getDiskPageId((int)BTree.this.getFileId(), (int)leafFrontier.pageId);
                        int headerSize = Math.max(this.leafFrame.getPageHeaderSize(), this.interiorFrame.getPageHeaderSize());
                        int multiplier = (int)Math.ceil((double)tupleSize / (double)(BTree.this.bufferCache.getPageSize() - headerSize));
                        leafFrontier.page = multiplier > 1 ? BTree.this.bufferCache.confiscateLargePage(dpid, multiplier, BTree.this.freePageManager.takeBlock(this.metaFrame, multiplier - 1)) : BTree.this.bufferCache.confiscatePage(dpid);
                        this.leafFrame.setPage(leafFrontier.page);
                        this.leafFrame.initBuffer((byte)0);
                        ((IBTreeLeafFrame)this.leafFrame).setLargeFlag(true);
                    } else {
                        long dpid = BufferedFileHandle.getDiskPageId((int)BTree.this.getFileId(), (int)leafFrontier.pageId);
                        leafFrontier.page = BTree.this.bufferCache.confiscatePage(dpid);
                        this.leafFrame.setPage(leafFrontier.page);
                        this.leafFrame.initBuffer((byte)0);
                    }
                } else if (this.verifyInput && this.leafFrame.getTupleCount() > 0) {
                    leafFrontier.lastTuple.resetByTupleIndex(this.leafFrame, this.leafFrame.getTupleCount() - 1);
                    this.verifyInputTuple(tuple, (ITupleReference)leafFrontier.lastTuple);
                }
                ((IBTreeLeafFrame)this.leafFrame).insertSorted(tuple);
            }
            catch (RuntimeException | HyracksDataException e) {
                this.logState(tuple, (Exception)e);
                this.handleException();
                throw e;
            }
        }

        protected void verifyInputTuple(ITupleReference tuple, ITupleReference prevTuple) throws HyracksDataException {
            int cmpResult = this.cmp.compare(tuple, prevTuple);
            if (cmpResult < 0) {
                throw HyracksDataException.create((ErrorCode)ErrorCode.UNSORTED_LOAD_INPUT, (Serializable[])new Serializable[0]);
            }
            if (cmpResult == 0) {
                throw HyracksDataException.create((ErrorCode)ErrorCode.DUPLICATE_LOAD_INPUT, (Serializable[])new Serializable[0]);
            }
        }

        protected void propagateBulk(int level, List<ICachedPage> pagesToWrite) throws HyracksDataException {
            if (this.splitKey.getBuffer() == null) {
                return;
            }
            if (level >= this.nodeFrontiers.size()) {
                this.addLevel();
            }
            NodeFrontier frontier = (NodeFrontier)this.nodeFrontiers.get(level);
            this.interiorFrame.setPage(frontier.page);
            ITreeIndexTupleReference tuple = this.splitKey.getTuple();
            int tupleBytes = this.tupleWriter.bytesRequired((ITupleReference)tuple, 0, this.cmp.getKeyFieldCount());
            int spaceNeeded = tupleBytes + this.slotSize + 4;
            if (tupleBytes > this.interiorFrame.getMaxTupleSize(BTree.this.bufferCache.getPageSize())) {
                throw HyracksDataException.create((ErrorCode)ErrorCode.RECORD_IS_TOO_LARGE, (Serializable[])new Serializable[]{Integer.valueOf(tupleBytes), Integer.valueOf(this.interiorFrame.getMaxTupleSize(BTree.this.bufferCache.getPageSize()))});
            }
            int spaceUsed = this.interiorFrame.getBuffer().capacity() - this.interiorFrame.getTotalFreeSpace();
            if (spaceUsed + spaceNeeded > this.interiorMaxBytes) {
                ISplitKey copyKey = this.splitKey.duplicate(this.leafFrame.getTupleWriter().createTupleReference());
                tuple = copyKey.getTuple();
                frontier.lastTuple.resetByTupleIndex(this.interiorFrame, this.interiorFrame.getTupleCount() - 1);
                int splitKeySize = this.tupleWriter.bytesRequired((ITupleReference)frontier.lastTuple, 0, this.cmp.getKeyFieldCount());
                this.splitKey.initData(splitKeySize);
                this.tupleWriter.writeTupleFields((ITupleReference)frontier.lastTuple, 0, this.cmp.getKeyFieldCount(), this.splitKey.getBuffer().array(), 0);
                this.splitKey.getTuple().resetByTupleOffset(this.splitKey.getBuffer().array(), 0);
                ((IBTreeInteriorFrame)this.interiorFrame).deleteGreatest();
                int finalPageId = BTree.this.freePageManager.takePage(this.metaFrame);
                frontier.page.setDiskPageId(BufferedFileHandle.getDiskPageId((int)BTree.this.getFileId(), (int)finalPageId));
                pagesToWrite.add(frontier.page);
                this.splitKey.setLeftPage(finalPageId);
                this.propagateBulk(level + 1, pagesToWrite);
                frontier.page = BTree.this.bufferCache.confiscatePage(-1L);
                this.interiorFrame.setPage(frontier.page);
                this.interiorFrame.initBuffer((byte)level);
            }
            ((IBTreeInteriorFrame)this.interiorFrame).insertSorted((ITupleReference)tuple);
        }

        private void persistFrontiers(int level, int rightPage) throws HyracksDataException {
            if (level >= this.nodeFrontiers.size()) {
                BTree.this.rootPage = ((NodeFrontier)this.nodeFrontiers.get((int)(level - 1))).pageId;
                this.releasedLatches = true;
                return;
            }
            if (level < 1) {
                ICachedPage lastLeaf = ((NodeFrontier)this.nodeFrontiers.get((int)level)).page;
                int lastLeafPage = ((NodeFrontier)this.nodeFrontiers.get((int)level)).pageId;
                lastLeaf.setDiskPageId(BufferedFileHandle.getDiskPageId((int)BTree.this.getFileId(), (int)((NodeFrontier)this.nodeFrontiers.get((int)level)).pageId));
                this.write(lastLeaf);
                ((NodeFrontier)this.nodeFrontiers.get((int)level)).page = null;
                this.persistFrontiers(level + 1, lastLeafPage);
                return;
            }
            NodeFrontier frontier = (NodeFrontier)this.nodeFrontiers.get(level);
            this.interiorFrame.setPage(frontier.page);
            if (rightPage < 0) {
                throw new HyracksDataException("Error in index creation. Internal node appears to have no rightmost guide");
            }
            ((IBTreeInteriorFrame)this.interiorFrame).setRightmostChildPageId(rightPage);
            int finalPageId = BTree.this.freePageManager.takePage(this.metaFrame);
            frontier.page.setDiskPageId(BufferedFileHandle.getDiskPageId((int)BTree.this.getFileId(), (int)finalPageId));
            this.write(frontier.page);
            frontier.pageId = finalPageId;
            this.persistFrontiers(level + 1, finalPageId);
        }

        public void end() throws HyracksDataException {
            try {
                this.persistFrontiers(0, -1);
                super.end();
            }
            catch (RuntimeException | HyracksDataException e) {
                this.handleException();
                throw e;
            }
        }

        public void abort() throws HyracksDataException {
            super.handleException();
        }

        private void logState(ITupleReference tuple, Exception e) {
            try {
                ObjectNode state = JSONUtil.createObject();
                state.set("leafFrame", (JsonNode)this.leafFrame.getState());
                state.set("interiorFrame", (JsonNode)this.interiorFrame.getState());
                int tupleSize = Math.max(this.leafFrame.getBytesRequiredToWriteTuple(tuple), this.interiorFrame.getBytesRequiredToWriteTuple(tuple));
                state.put("tupleSize", tupleSize);
                state.put("spaceNeeded", this.tupleWriter.bytesRequired(tuple) + this.slotSize);
                state.put("spaceUsed", this.leafFrame.getBuffer().capacity() - this.leafFrame.getTotalFreeSpace());
                state.put("leafMaxBytes", this.leafMaxBytes);
                state.put("maxTupleSize", BTree.this.maxTupleSize);
                LOGGER.error("failed to add tuple {}", (Object)state, (Object)e);
            }
            catch (Throwable t) {
                e.addSuppressed(t);
            }
        }
    }

    public class BTreeAccessor
    implements ITreeIndexAccessor {
        protected BTree btree;
        protected BTreeOpContext ctx;
        private boolean destroyed = false;
        protected IIndexAccessParameters iap;

        public BTreeAccessor(BTree btree, IIndexAccessParameters iap) {
            this.btree = btree;
            this.ctx = btree.createOpContext((IIndexAccessor)this, iap.getModificationCallback(), iap.getSearchOperationCallback());
            this.iap = iap;
        }

        public void reset(BTree btree, IIndexAccessParameters iap) {
            this.btree = btree;
            this.ctx.setCallbacks(iap.getModificationCallback(), iap.getSearchOperationCallback());
            this.ctx.reset();
            this.iap = iap;
        }

        public void insert(ITupleReference tuple) throws HyracksDataException {
            this.ctx.setOperation(IndexOperation.INSERT);
            this.insert(tuple, this.ctx);
        }

        public void update(ITupleReference tuple) throws HyracksDataException {
            this.ctx.setOperation(IndexOperation.UPDATE);
            this.update(tuple, this.ctx);
        }

        public void delete(ITupleReference tuple) throws HyracksDataException {
            this.ctx.setOperation(IndexOperation.DELETE);
            this.delete(tuple, this.ctx);
        }

        public void upsert(ITupleReference tuple) throws HyracksDataException {
            this.upsertIfConditionElseInsert(tuple, UnconditionalTupleAcceptor.INSTANCE);
        }

        public void upsertIfConditionElseInsert(ITupleReference tuple, ITupleAcceptor acceptor) throws HyracksDataException {
            this.ctx.setOperation(IndexOperation.UPSERT);
            this.ctx.setAcceptor(acceptor);
            this.upsert(tuple, this.ctx);
        }

        public BTreeRangeSearchCursor createSearchCursor(boolean exclusive) {
            IBTreeLeafFrame leafFrame = (IBTreeLeafFrame)this.btree.getLeafFrameFactory().createFrame();
            return new BTreeRangeSearchCursor(leafFrame, exclusive, this.iap.getParameters().getOrDefault("INDEX_CURSOR_STATS", NoOpIndexCursorStats.INSTANCE));
        }

        public BTreeRangeSearchCursor createPointCursor(boolean exclusive, boolean stateful) {
            return this.createSearchCursor(exclusive);
        }

        public void search(IIndexCursor cursor, ISearchPredicate searchPred) throws HyracksDataException {
            this.ctx.setOperation(IndexOperation.SEARCH);
            this.btree.search((ITreeIndexCursor)cursor, searchPred, this.ctx);
        }

        public ITreeIndexCursor createDiskOrderScanCursor() {
            IBTreeLeafFrame leafFrame = (IBTreeLeafFrame)this.btree.getLeafFrameFactory().createFrame();
            return new TreeIndexDiskOrderScanCursor((ITreeIndexFrame)leafFrame);
        }

        public void diskOrderScan(ITreeIndexCursor cursor) throws HyracksDataException {
            this.ctx.setOperation(IndexOperation.DISKORDERSCAN);
            this.btree.diskOrderScan(cursor, this.ctx);
        }

        public BTreeOpContext getOpContext() {
            return this.ctx;
        }

        public ITreeIndexCursor createCountingSearchCursor() {
            IBTreeLeafFrame leafFrame = (IBTreeLeafFrame)this.btree.getLeafFrameFactory().createFrame();
            return new BTreeCountingSearchCursor(leafFrame, false);
        }

        private void insert(ITupleReference tuple, BTreeOpContext ctx) throws HyracksDataException {
            ctx.getModificationCallback().before(tuple);
            this.insertUpdateOrDelete(tuple, ctx);
        }

        private void upsert(ITupleReference tuple, BTreeOpContext ctx) throws HyracksDataException {
            ctx.getModificationCallback().before(tuple);
            this.insertUpdateOrDelete(tuple, ctx);
        }

        private void update(ITupleReference tuple, BTreeOpContext ctx) throws HyracksDataException {
            if (BTree.this.fieldCount == ctx.getCmp().getKeyFieldCount()) {
                HyracksDataException.create((ErrorCode)ErrorCode.INDEX_NOT_UPDATABLE, (Serializable[])new Serializable[0]);
            }
            ctx.getModificationCallback().before(tuple);
            this.insertUpdateOrDelete(tuple, ctx);
        }

        private void delete(ITupleReference tuple, BTreeOpContext ctx) throws HyracksDataException {
            ctx.getModificationCallback().before(tuple);
            this.insertUpdateOrDelete(tuple, ctx);
        }

        private void insertUpdateOrDelete(ITupleReference tuple, BTreeOpContext ctx) throws HyracksDataException {
            ctx.reset();
            ctx.getPred().setLowKeyComparator(ctx.getCmp());
            ctx.getPred().setHighKeyComparator(ctx.getCmp());
            ctx.getPred().setLowKey(tuple, true);
            ctx.getPred().setHighKey(tuple, true);
            ctx.getSplitKey().reset();
            ctx.getSplitKey().getTuple().setFieldCount(ctx.getCmp().getKeyFieldCount());
            boolean repeatOp = true;
            while (repeatOp && ctx.getOpRestarts() < 10) {
                ctx.setSmoCount(BTree.this.smoCounter.get());
                BTree.this.performOp(BTree.this.rootPage, null, true, ctx);
                if (!ctx.getPageLsns().isEmpty()) {
                    if (ctx.getPageLsns().getLast() == -9223372036854775807L) {
                        ctx.getPageLsns().clear();
                        continue;
                    }
                    if (ctx.getPageLsns().getLast() == Long.MIN_VALUE) {
                        ctx.getPageLsns().removeLast();
                        continue;
                    }
                }
                if (ctx.getSplitKey().getBuffer() != null) {
                    BTree.this.createNewRoot(ctx);
                }
                BTree.this.unsetSmPages(ctx);
                repeatOp = false;
            }
            if (ctx.getOpRestarts() >= 10) {
                throw HyracksDataException.create((ErrorCode)ErrorCode.OPERATION_EXCEEDED_MAX_RESTARTS, (Serializable[])new Serializable[]{Integer.valueOf(10)});
            }
        }

        public void destroy() throws HyracksDataException {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
            this.ctx.destroy();
        }
    }
}

