/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.common.file;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.storage.common.file.IFileMapManager;

public class FileMapManager
implements IFileMapManager {
    private static final long serialVersionUID = 1L;
    private Map<Integer, FileReference> id2nameMap = new HashMap<Integer, FileReference>();
    private Map<FileReference, Integer> name2IdMap = new HashMap<FileReference, Integer>();
    private int idCounter = 0;

    @Override
    public FileReference lookupFileName(int fileId) throws HyracksDataException {
        FileReference fRef = this.id2nameMap.get(fileId);
        if (fRef == null) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.NO_MAPPING_FOR_FILE_ID, (Serializable[])new Serializable[]{Integer.valueOf(fileId)});
        }
        return fRef;
    }

    @Override
    public int lookupFileId(FileReference fileRef) throws HyracksDataException {
        Integer fileId = this.name2IdMap.get(fileRef);
        if (fileId == null) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.NO_MAPPING_FOR_FILENAME, (Serializable[])new Serializable[]{fileRef});
        }
        return fileId;
    }

    @Override
    public boolean isMapped(FileReference fileRef) {
        return this.name2IdMap.containsKey(fileRef);
    }

    @Override
    public boolean isMapped(int fileId) {
        return this.id2nameMap.containsKey(fileId);
    }

    @Override
    public FileReference unregisterFile(int fileId) throws HyracksDataException {
        FileReference fileRef = this.id2nameMap.remove(fileId);
        if (fileRef == null) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.NO_MAPPING_FOR_FILE_ID, (Serializable[])new Serializable[]{Integer.valueOf(fileId)});
        }
        this.name2IdMap.remove(fileRef);
        fileRef.unregister();
        return fileRef;
    }

    @Override
    public int registerFile(FileReference fileRef) throws HyracksDataException {
        Integer existingKey = this.name2IdMap.get(fileRef);
        if (existingKey != null) {
            FileReference prevFile = this.id2nameMap.get(existingKey);
            throw HyracksDataException.create((ErrorCode)ErrorCode.FILE_ALREADY_MAPPED, (Serializable[])new Serializable[]{fileRef, prevFile, new Date(prevFile.registrationTime()).toString()});
        }
        int fileId = this.idCounter++;
        fileRef.register();
        this.id2nameMap.put(fileId, fileRef);
        this.name2IdMap.put(fileRef, fileId);
        return fileId;
    }
}

