/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.policy.HttpPipelinePolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class HttpPipelineBuilder {
    private HttpClient httpClient;
    private List<HttpPipelinePolicy> pipelinePolicies;

    public HttpPipeline build() {
        ArrayList<HttpPipelinePolicy> policies = this.pipelinePolicies == null ? new ArrayList() : this.pipelinePolicies;
        HttpClient client = this.httpClient == null ? HttpClient.createDefault() : this.httpClient;
        return new HttpPipeline(client, policies);
    }

    public HttpPipelineBuilder httpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public HttpPipelineBuilder policies(HttpPipelinePolicy ... policies) {
        if (this.pipelinePolicies == null) {
            this.pipelinePolicies = new ArrayList<HttpPipelinePolicy>();
        }
        this.pipelinePolicies.addAll(Arrays.asList(policies));
        return this;
    }
}

