/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.logging;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.asterix.common.transactions.ILogRecord;
import org.apache.asterix.common.transactions.LogRecord;
import org.apache.commons.codec.binary.Hex;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogBufferTailReader {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ByteBuffer buffer;
    private final LogRecord logRecord;
    private int endOffset;

    public LogBufferTailReader(ByteBuffer buffer) {
        this.buffer = buffer;
        this.logRecord = new LogRecord();
    }

    public void initializeScan(int beginOffset, int endOffset) {
        this.endOffset = endOffset;
        this.buffer.position(beginOffset);
    }

    public LogRecord next() {
        if (this.buffer.position() == this.endOffset) {
            return null;
        }
        ILogRecord.RecordReadStatus status = this.logRecord.readLogRecord(this.buffer);
        if (status != ILogRecord.RecordReadStatus.OK) {
            this.logReadFailure(status);
            throw new IllegalStateException("Unexpected log read status: " + status);
        }
        return this.logRecord;
    }

    private void logReadFailure(ILogRecord.RecordReadStatus status) {
        int bufferRemaining = this.endOffset - this.buffer.position();
        byte[] remainingData = new byte[bufferRemaining];
        this.buffer.get(remainingData);
        char[] hexData = Hex.encodeHex((byte[])remainingData);
        LOGGER.error("Unexpected read status {}, read Log: {},  buffer remaining at read: {}, buffer remaining content: {}", (Object)status, (Object)bufferRemaining, (Object)this.logRecord.getLogRecordForDisplay(), (Object)Arrays.toString(hexData));
    }
}

