/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.logging;

import java.nio.ByteBuffer;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.transactions.ILogManager;
import org.apache.asterix.common.transactions.ILogRecord;
import org.apache.asterix.common.transactions.ILogRequester;
import org.apache.asterix.common.transactions.LogRecord;
import org.apache.asterix.common.utils.TransactionUtil;
import org.apache.asterix.replication.api.IReplicationWorker;
import org.apache.asterix.replication.logging.RemoteLogRecord;
import org.apache.asterix.replication.logging.RemoteLogsNotifier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RemoteLogsProcessor
implements ILogRequester {
    private static final Logger LOGGER = LogManager.getLogger();
    private final LinkedBlockingQueue<RemoteLogRecord> remoteLogsQ;
    private final ILogManager logManager;

    public RemoteLogsProcessor(INcApplicationContext appCtx) {
        this.logManager = appCtx.getTransactionSubsystem().getLogManager();
        this.remoteLogsQ = new LinkedBlockingQueue();
        appCtx.getThreadExecutor().execute(new RemoteLogsNotifier(appCtx, this.remoteLogsQ));
    }

    public void process(ByteBuffer logsBatch, RemoteLogRecord reusableLog, IReplicationWorker worker) {
        block5: while (logsBatch.hasRemaining()) {
            logsBatch.getInt();
            reusableLog.readRemoteLog(logsBatch);
            reusableLog.setLogSource((byte)1);
            switch (reusableLog.getLogType()) {
                case 0: 
                case 2: 
                case 7: {
                    this.logManager.log((ILogRecord)reusableLog);
                    continue block5;
                }
                case 1: 
                case 3: {
                    RemoteLogRecord jobTerminationLog = new RemoteLogRecord();
                    TransactionUtil.formJobTerminateLogRecord((LogRecord)jobTerminationLog, (long)reusableLog.getTxnId(), (reusableLog.getLogType() == 1 ? 1 : 0) != 0);
                    jobTerminationLog.setRequester(this);
                    jobTerminationLog.setReplicationWorker(worker);
                    jobTerminationLog.setLogSource((byte)1);
                    this.logManager.log((ILogRecord)jobTerminationLog);
                    continue block5;
                }
                case 4: {
                    RemoteLogRecord flushLog = new RemoteLogRecord();
                    TransactionUtil.formFlushLogRecord((LogRecord)flushLog, (int)reusableLog.getDatasetId(), (int)reusableLog.getResourcePartition(), (long)reusableLog.getFlushingComponentMinId(), (long)reusableLog.getFlushingComponentMaxId(), null);
                    flushLog.setRequester(this);
                    flushLog.setLogSource((byte)1);
                    flushLog.setMasterLsn(reusableLog.getLSN());
                    this.logManager.log((ILogRecord)flushLog);
                    continue block5;
                }
            }
            LOGGER.error(() -> "Unsupported LogType: " + reusableLog.getLogType());
        }
    }

    public void notifyFlushed(ILogRecord logRecord) {
        this.remoteLogsQ.add((RemoteLogRecord)logRecord);
    }
}

