/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.ObjectIdentifierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Delete
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Delete> {
    private static final SdkField<List<ObjectIdentifier>> OBJECTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Delete.getter(Delete::objects)).setter(Delete.setter(Builder::objects)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Object").unmarshallLocationName("Object").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ObjectIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).isFlattened(true).build()}).build();
    private static final SdkField<Boolean> QUIET_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Delete.getter(Delete::quiet)).setter(Delete.setter(Builder::quiet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quiet").unmarshallLocationName("Quiet").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECTS_FIELD, QUIET_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ObjectIdentifier> objects;
    private final Boolean quiet;

    private Delete(BuilderImpl builder) {
        this.objects = builder.objects;
        this.quiet = builder.quiet;
    }

    public boolean hasObjects() {
        return this.objects != null && !(this.objects instanceof SdkAutoConstructList);
    }

    public List<ObjectIdentifier> objects() {
        return this.objects;
    }

    public Boolean quiet() {
        return this.quiet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.objects());
        hashCode = 31 * hashCode + Objects.hashCode(this.quiet());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Delete)) {
            return false;
        }
        Delete other = (Delete)obj;
        return Objects.equals(this.objects(), other.objects()) && Objects.equals(this.quiet(), other.quiet());
    }

    public String toString() {
        return ToString.builder((String)"Delete").add("Objects", this.objects()).add("Quiet", (Object)this.quiet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Objects": {
                return Optional.ofNullable(clazz.cast(this.objects()));
            }
            case "Quiet": {
                return Optional.ofNullable(clazz.cast(this.quiet()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Delete, T> g) {
        return obj -> g.apply((Delete)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ObjectIdentifier> objects = DefaultSdkAutoConstructList.getInstance();
        private Boolean quiet;

        private BuilderImpl() {
        }

        private BuilderImpl(Delete model) {
            this.objects(model.objects);
            this.quiet(model.quiet);
        }

        public final Collection<ObjectIdentifier.Builder> getObjects() {
            return this.objects != null ? (Collection)this.objects.stream().map(ObjectIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder objects(Collection<ObjectIdentifier> objects) {
            this.objects = ObjectIdentifierListCopier.copy(objects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objects(ObjectIdentifier ... objects) {
            this.objects(Arrays.asList(objects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objects(Consumer<ObjectIdentifier.Builder> ... objects) {
            this.objects(Stream.of(objects).map(c -> (ObjectIdentifier)((ObjectIdentifier.Builder)ObjectIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setObjects(Collection<ObjectIdentifier.BuilderImpl> objects) {
            this.objects = ObjectIdentifierListCopier.copyFromBuilder(objects);
        }

        public final Boolean getQuiet() {
            return this.quiet;
        }

        @Override
        public final Builder quiet(Boolean quiet) {
            this.quiet = quiet;
            return this;
        }

        public final void setQuiet(Boolean quiet) {
            this.quiet = quiet;
        }

        public Delete build() {
            return new Delete(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Delete> {
        public Builder objects(Collection<ObjectIdentifier> var1);

        public Builder objects(ObjectIdentifier ... var1);

        public Builder objects(Consumer<ObjectIdentifier.Builder> ... var1);

        public Builder quiet(Boolean var1);
    }
}

