/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.job;

import java.util.Map;
import org.apache.hyracks.api.dataflow.TaskId;
import org.apache.hyracks.control.cc.job.TaskAttempt;
import org.apache.hyracks.control.cc.job.TaskCluster;

public class TaskClusterAttempt {
    private final TaskCluster taskCluster;
    private final int attempt;
    private Map<TaskId, TaskAttempt> taskAttempts;
    private TaskClusterStatus status;
    private int pendingTaskCounter;
    private long startTime;
    private long endTime;

    public TaskClusterAttempt(TaskCluster taskCluster, int attempt) {
        this.taskCluster = taskCluster;
        this.attempt = attempt;
        this.startTime = -1L;
        this.endTime = -1L;
    }

    public TaskCluster getTaskCluster() {
        return this.taskCluster;
    }

    public void setTaskAttempts(Map<TaskId, TaskAttempt> taskAttempts) {
        this.taskAttempts = taskAttempts;
    }

    public Map<TaskId, TaskAttempt> getTaskAttempts() {
        return this.taskAttempts;
    }

    public int getAttempt() {
        return this.attempt;
    }

    public void setStatus(TaskClusterStatus status) {
        this.status = status;
    }

    public TaskClusterStatus getStatus() {
        return this.status;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public void initializePendingTaskCounter() {
        this.pendingTaskCounter = this.taskAttempts.size();
    }

    public int getPendingTaskCounter() {
        return this.pendingTaskCounter;
    }

    public int decrementPendingTasksCounter() {
        return --this.pendingTaskCounter;
    }

    public static enum TaskClusterStatus {
        RUNNING,
        COMPLETED,
        FAILED,
        ABORTED;

    }
}

