/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.clienthelper.commands;

import java.io.IOException;
import org.apache.asterix.clienthelper.Args;
import org.apache.asterix.clienthelper.commands.RemoteCommand;

public class ShutdownCommand
extends RemoteCommand {
    private final String shutdownPath;

    public ShutdownCommand(Args args, String extra) {
        super(args);
        this.shutdownPath = args.getShutdownPath() + extra;
    }

    public ShutdownCommand(Args args) {
        this(args, "");
    }

    private void clusterLog(String suffix) {
        this.log("Cluster " + this.hostPort + " " + suffix);
    }

    @Override
    public int execute() throws IOException {
        this.log("Attempting to shutdown cluster " + this.hostPort + "...");
        int statusCode = this.tryPost(this.shutdownPath);
        switch (statusCode) {
            case 202: {
                this.clusterLog("accepted shutdown request.");
                return 0;
            }
            case -1: {
                this.clusterLog("not reachable.");
                return 1;
            }
        }
        this.clusterLog("shutdown request failed, with response code:" + statusCode);
        return 1;
    }
}

