/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.asterix.optimizer.base.AnalysisUtil;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class PushFieldAccessRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        String finalAnnot;
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op)) {
            return false;
        }
        if (op.getOperatorTag() != LogicalOperatorTag.ASSIGN) {
            return false;
        }
        if (!OperatorPropertiesUtil.isMovable((ILogicalOperator)op)) {
            return false;
        }
        AssignOperator access = (AssignOperator)op;
        ILogicalExpression expr = this.getFirstExpr(access);
        if (AnalysisUtil.isAccessToFieldRecord(expr)) {
            finalAnnot = "PUSHED_FIELD_ACCESS";
        } else if (AnalysisUtil.isRunnableAccessToFieldRecord(expr)) {
            finalAnnot = "PUSHED_RUNNABLE_FIELD_ACCESS";
        } else {
            return false;
        }
        return this.pushDownFieldAccessRec(opRef, context, finalAnnot);
    }

    private boolean isAccessToIndexedField(AssignOperator assign, IOptimizationContext context) throws AlgebricksException {
        DataSourceId asid;
        AbstractFunctionCallExpression accessFun = (AbstractFunctionCallExpression)((Mutable)assign.getExpressions().get(0)).getValue();
        ILogicalExpression e0 = (ILogicalExpression)((Mutable)accessFun.getArguments().get(0)).getValue();
        if (e0.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
            return false;
        }
        LogicalVariable var = ((VariableReferenceExpression)e0).getVariableReference();
        if (context.findPrimaryKey(var) == null) {
            return false;
        }
        AssignOperator op = assign;
        while (op.getInputs().size() == 1 && op.getOperatorTag() != LogicalOperatorTag.DATASOURCESCAN) {
            op = (AbstractLogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        }
        if (op.getOperatorTag() != LogicalOperatorTag.DATASOURCESCAN) {
            return false;
        }
        DataSourceScanOperator scan = (DataSourceScanOperator)op;
        LogicalVariable recVar = (LogicalVariable)scan.getVariables().get(scan.getVariables().size() - 1);
        if (recVar != var) {
            return false;
        }
        MetadataProvider mp = (MetadataProvider)context.getMetadataProvider();
        Dataset dataset = mp.findDataset((asid = (DataSourceId)scan.getDataSource().getId()).getDataverseName(), asid.getDatasourceName());
        if (dataset == null) {
            throw new CompilationException(1050, scan.getSourceLocation(), new Serializable[]{asid.getDatasourceName(), asid.getDataverseName()});
        }
        if (dataset.getDatasetType() != DatasetConfig.DatasetType.INTERNAL) {
            return false;
        }
        Integer pos = ConstantExpressionUtil.getIntConstant((ILogicalExpression)((ILogicalExpression)((Mutable)accessFun.getArguments().get(1)).getValue()));
        if (pos != null) {
            String tName = dataset.getItemTypeName();
            IAType t = mp.findType(dataset.getItemTypeDataverseName(), tName);
            if (t.getTypeTag() != ATypeTag.OBJECT) {
                return false;
            }
            ARecordType rt = (ARecordType)t;
            if (pos >= rt.getFieldNames().length) {
                return false;
            }
        }
        List datasetIndexes = mp.getDatasetIndexes(dataset.getDataverseName(), dataset.getDatasetName());
        boolean hasSecondaryIndex = false;
        for (Index index : datasetIndexes) {
            if (!index.isSecondaryIndex()) continue;
            hasSecondaryIndex = true;
            break;
        }
        return hasSecondaryIndex;
    }

    private boolean tryingToPushThroughSelectionWithSameDataSource(AssignOperator access, AbstractLogicalOperator op2) {
        if (op2.getOperatorTag() != LogicalOperatorTag.SELECT) {
            return false;
        }
        ILogicalExpression e1 = (ILogicalExpression)access.getAnnotations().get("FIELD_ACCESS");
        if (e1 == null) {
            return false;
        }
        ILogicalExpression e2 = (ILogicalExpression)op2.getAnnotations().get("FIELD_ACCESS");
        if (e2 == null) {
            return false;
        }
        return e1.equals(e2);
    }

    private boolean pushDownFieldAccessRec(Mutable<ILogicalOperator> opRef, IOptimizationContext context, String finalAnnot) throws AlgebricksException {
        Object v2;
        AssignOperator assignOp = (AssignOperator)opRef.getValue();
        Mutable opRef2 = (Mutable)assignOp.getInputs().get(0);
        AbstractLogicalOperator inputOp = (AbstractLogicalOperator)opRef2.getValue();
        if (inputOp.getOperatorTag() == LogicalOperatorTag.PROJECT || context.checkAndAddToAlreadyCompared((ILogicalOperator)assignOp, (ILogicalOperator)inputOp) && (inputOp.getOperatorTag() != LogicalOperatorTag.SELECT || !this.isAccessToIndexedField(assignOp, context))) {
            return false;
        }
        Object annotation = inputOp.getAnnotations().get("isMovable");
        if (annotation != null && !((Boolean)annotation).booleanValue()) {
            return false;
        }
        if (this.tryingToPushThroughSelectionWithSameDataSource(assignOp, inputOp)) {
            return false;
        }
        if (this.testAndModifyRedundantOp(assignOp, inputOp)) {
            this.pushDownFieldAccessRec((Mutable<ILogicalOperator>)opRef2, context, finalAnnot);
            return true;
        }
        HashSet usedInAccess = new HashSet();
        VariableUtilities.getUsedVariables((ILogicalOperator)assignOp, usedInAccess);
        HashSet produced2 = new HashSet();
        if (inputOp.getOperatorTag() == LogicalOperatorTag.GROUP) {
            VariableUtilities.getLiveVariables((ILogicalOperator)inputOp, produced2);
        } else {
            VariableUtilities.getProducedVariables((ILogicalOperator)inputOp, produced2);
        }
        boolean pushItDown = false;
        HashSet inter = new HashSet(usedInAccess);
        if (inter.isEmpty()) {
            return false;
        }
        inter.retainAll(produced2);
        if (inter.isEmpty()) {
            pushItDown = true;
        } else if (inputOp.getOperatorTag() == LogicalOperatorTag.GROUP) {
            GroupByOperator g = (GroupByOperator)inputOp;
            ArrayList<Pair> varMappings = new ArrayList<Pair>();
            for (Object p : g.getDecorList()) {
                LogicalVariable decorVar;
                ILogicalExpression e = (ILogicalExpression)((Mutable)((Pair)p).second).getValue();
                if (e.getExpressionTag() != LogicalExpressionTag.VARIABLE || !inter.contains(decorVar = GroupByOperator.getDecorVariable((Pair)p))) continue;
                inter.remove(decorVar);
                LogicalVariable v1 = ((VariableReferenceExpression)e).getVariableReference();
                varMappings.add(new Pair((Object)decorVar, (Object)v1));
            }
            if (inter.isEmpty()) {
                boolean changed = false;
                for (Pair m : varMappings) {
                    v2 = context.newVar();
                    LogicalVariable oldVar = (LogicalVariable)assignOp.getVariables().get(0);
                    VariableReferenceExpression v2Ref = new VariableReferenceExpression((LogicalVariable)v2);
                    v2Ref.setSourceLocation(g.getSourceLocation());
                    g.getDecorList().add(new Pair((Object)oldVar, (Object)new MutableObject((Object)v2Ref)));
                    changed = true;
                    assignOp.getVariables().set(0, v2);
                    VariableUtilities.substituteVariables((ILogicalOperator)assignOp, (LogicalVariable)((LogicalVariable)m.first), (LogicalVariable)((LogicalVariable)m.second), (ITypingContext)context);
                }
                if (changed) {
                    context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)g);
                }
                usedInAccess.clear();
                VariableUtilities.getUsedVariables((ILogicalOperator)assignOp, usedInAccess);
                pushItDown = true;
            }
        }
        if (pushItDown) {
            if (inputOp.getOperatorTag() == LogicalOperatorTag.NESTEDTUPLESOURCE) {
                Mutable childOfSubplan = (Mutable)((ILogicalOperator)((NestedTupleSourceOperator)inputOp).getDataSourceReference().getValue()).getInputs().get(0);
                this.pushAccessDown(opRef, (ILogicalOperator)inputOp, (Mutable<ILogicalOperator>)childOfSubplan, context, finalAnnot);
                return true;
            }
            if (inputOp.getInputs().size() == 1 && !inputOp.hasNestedPlans()) {
                this.pushAccessDown(opRef, (ILogicalOperator)inputOp, (Mutable<ILogicalOperator>)((Mutable)inputOp.getInputs().get(0)), context, finalAnnot);
                return true;
            }
            for (Object inp : inputOp.getInputs()) {
                HashSet v22 = new HashSet();
                VariableUtilities.getLiveVariables((ILogicalOperator)((ILogicalOperator)inp.getValue()), v22);
                if (!v22.containsAll(usedInAccess)) continue;
                this.pushAccessDown(opRef, (ILogicalOperator)inputOp, (Mutable<ILogicalOperator>)inp, context, finalAnnot);
                return true;
            }
            if (inputOp.hasNestedPlans()) {
                AbstractOperatorWithNestedPlans nestedOp = (AbstractOperatorWithNestedPlans)inputOp;
                for (ILogicalPlan plan : nestedOp.getNestedPlans()) {
                    for (Mutable root : plan.getRoots()) {
                        v2 = new HashSet();
                        VariableUtilities.getLiveVariables((ILogicalOperator)((ILogicalOperator)root.getValue()), (Collection)v2);
                        if (!((AbstractCollection)v2).containsAll(usedInAccess)) continue;
                        this.pushAccessDown(opRef, (ILogicalOperator)inputOp, (Mutable<ILogicalOperator>)root, context, finalAnnot);
                        return true;
                    }
                }
            }
            return false;
        }
        if (inputOp.getOperatorTag() == LogicalOperatorTag.DATASOURCESCAN) {
            DataSourceScanOperator scan = (DataSourceScanOperator)inputOp;
            IDataSource dataSource = scan.getDataSource();
            byte dsType = ((DataSource)dataSource).getDatasourceType();
            if (dsType != 0 && dsType != 1) {
                return false;
            }
            DataSourceId asid = (DataSourceId)dataSource.getId();
            MetadataProvider mp = (MetadataProvider)context.getMetadataProvider();
            Dataset dataset = mp.findDataset(asid.getDataverseName(), asid.getDatasourceName());
            if (dataset == null) {
                throw new CompilationException(1050, scan.getSourceLocation(), new Serializable[]{asid.getDatasourceName(), asid.getDataverseName()});
            }
            if (dataset.getDatasetType() != DatasetConfig.DatasetType.INTERNAL) {
                this.setAsFinal((ILogicalOperator)assignOp, context, finalAnnot);
                return false;
            }
            List allVars = scan.getVariables();
            LogicalVariable dataRecVarInScan = ((DataSource)dataSource).getDataRecordVariable(allVars);
            LogicalVariable metaRecVarInScan = ((DataSource)dataSource).getMetaVariable(allVars);
            String dataTypeName = dataset.getItemTypeName();
            IAType dataType = mp.findType(dataset.getItemTypeDataverseName(), dataTypeName);
            if (dataType.getTypeTag() != ATypeTag.OBJECT) {
                return false;
            }
            ARecordType dataRecType = (ARecordType)dataType;
            Pair<ILogicalExpression, List<String>> fieldPathAndVar = this.getFieldExpression(assignOp, dataRecType);
            ILogicalExpression targetRecVar = (ILogicalExpression)fieldPathAndVar.first;
            List targetFieldPath = (List)fieldPathAndVar.second;
            boolean rewrite = false;
            boolean fieldFromMeta = false;
            if (this.sameRecords(targetRecVar, dataRecVarInScan)) {
                rewrite = true;
            } else {
                IAType metaType = mp.findMetaType(dataset);
                if (metaType != null && metaType.getTypeTag() == ATypeTag.OBJECT) {
                    fieldPathAndVar = this.getFieldExpression(assignOp, (ARecordType)metaType);
                    targetRecVar = (ILogicalExpression)fieldPathAndVar.first;
                    targetFieldPath = (List)fieldPathAndVar.second;
                    if (this.sameRecords(targetRecVar, metaRecVarInScan)) {
                        rewrite = true;
                        fieldFromMeta = true;
                    }
                }
            }
            if (rewrite) {
                int p = DatasetUtil.getPositionOfPartitioningKeyField((Dataset)dataset, (List)targetFieldPath, (boolean)fieldFromMeta);
                if (p < 0) {
                    this.setAsFinal((ILogicalOperator)assignOp, context, finalAnnot);
                    return false;
                }
                LogicalVariable keyVar = (LogicalVariable)scan.getVariables().get(p);
                VariableReferenceExpression keyVarRef = new VariableReferenceExpression(keyVar);
                keyVarRef.setSourceLocation(targetRecVar.getSourceLocation());
                ((Mutable)assignOp.getExpressions().get(0)).setValue((Object)keyVarRef);
                return true;
            }
        }
        this.setAsFinal((ILogicalOperator)assignOp, context, finalAnnot);
        return false;
    }

    private boolean sameRecords(ILogicalExpression recordInAssign, LogicalVariable recordInScan) {
        return recordInAssign != null && recordInAssign.getExpressionTag() == LogicalExpressionTag.VARIABLE && ((VariableReferenceExpression)recordInAssign).getVariableReference().equals((Object)recordInScan);
    }

    private Pair<ILogicalExpression, List<String>> getFieldExpression(AssignOperator access, ARecordType rt) {
        LinkedList<String> fieldPath = new LinkedList<String>();
        ILogicalExpression e0 = (ILogicalExpression)((Mutable)access.getExpressions().get(0)).getValue();
        while (AnalysisUtil.isAccessToFieldRecord(e0)) {
            String fldName;
            ILogicalExpression e1 = (ILogicalExpression)((Mutable)((AbstractFunctionCallExpression)e0).getArguments().get(1)).getValue();
            if (e1.getExpressionTag() != LogicalExpressionTag.CONSTANT) {
                return new Pair(null, null);
            }
            ConstantExpression ce = (ConstantExpression)e1;
            IAObject obj = ((AsterixConstantValue)ce.getValue()).getObject();
            if (obj.getType().getTypeTag() == ATypeTag.STRING) {
                fldName = ((AString)obj).getStringValue();
            } else {
                int pos = ((AInt32)obj).getIntegerValue();
                if (pos >= rt.getFieldNames().length) {
                    return new Pair(null, null);
                }
                fldName = rt.getFieldNames()[pos];
            }
            fieldPath.addFirst(fldName);
            e0 = (ILogicalExpression)((Mutable)((AbstractFunctionCallExpression)e0).getArguments().get(0)).getValue();
        }
        return new Pair((Object)e0, fieldPath);
    }

    private void setAsFinal(ILogicalOperator access, IOptimizationContext context, String finalAnnot) {
        access.getAnnotations().put(finalAnnot, true);
        context.addToDontApplySet((IAlgebraicRewriteRule)this, access);
    }

    private boolean testAndModifyRedundantOp(AssignOperator access, AbstractLogicalOperator op2) {
        if (op2.getOperatorTag() != LogicalOperatorTag.ASSIGN) {
            return false;
        }
        AssignOperator a2 = (AssignOperator)op2;
        ILogicalExpression accessExpr0 = this.getFirstExpr(access);
        if (accessExpr0.equals(this.getFirstExpr(a2))) {
            VariableReferenceExpression varRef = new VariableReferenceExpression((LogicalVariable)a2.getVariables().get(0));
            varRef.setSourceLocation(accessExpr0.getSourceLocation());
            ((Mutable)access.getExpressions().get(0)).setValue((Object)varRef);
            return true;
        }
        return false;
    }

    private void pushAccessDown(Mutable<ILogicalOperator> fldAccessOpRef, ILogicalOperator op2, Mutable<ILogicalOperator> inputOfOp2, IOptimizationContext context, String finalAnnot) throws AlgebricksException {
        ILogicalOperator fieldAccessOp = (ILogicalOperator)fldAccessOpRef.getValue();
        fldAccessOpRef.setValue((Object)op2);
        List faInpList = fieldAccessOp.getInputs();
        faInpList.clear();
        faInpList.add(new MutableObject(inputOfOp2.getValue()));
        inputOfOp2.setValue((Object)fieldAccessOp);
        context.computeAndSetTypeEnvironmentForOperator(fieldAccessOp);
        context.computeAndSetTypeEnvironmentForOperator(op2);
        this.pushDownFieldAccessRec(inputOfOp2, context, finalAnnot);
    }

    private ILogicalExpression getFirstExpr(AssignOperator assign) {
        return (ILogicalExpression)((Mutable)assign.getExpressions().get(0)).getValue();
    }
}

