/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.message;

import org.apache.asterix.common.cluster.IClusterStateManager;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.messaging.api.ICCMessageBroker;
import org.apache.asterix.common.messaging.api.ICcAddressedMessage;
import org.apache.asterix.common.messaging.api.INcAddressedMessage;
import org.apache.asterix.common.transactions.IResourceIdManager;
import org.apache.asterix.runtime.message.ResourceIdRequestResponseMessage;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class ResourceIdRequestMessage
implements ICcAddressedMessage {
    private static final long serialVersionUID = 1L;
    private final String src;

    public ResourceIdRequestMessage(String src) {
        this.src = src;
    }

    public void handle(ICcApplicationContext appCtx) throws HyracksDataException, InterruptedException {
        try {
            ICCMessageBroker broker = (ICCMessageBroker)appCtx.getServiceContext().getMessageBroker();
            ResourceIdRequestResponseMessage response = new ResourceIdRequestResponseMessage();
            IClusterStateManager clusterStateManager = appCtx.getClusterStateManager();
            IResourceIdManager resourceIdManager = appCtx.getResourceIdManager();
            response.setResourceId(resourceIdManager.createResourceId());
            if (response.getResourceId() < 0L) {
                if (!clusterStateManager.isClusterActive()) {
                    response.setException(new Exception("Cannot generate global resource id when cluster is not active."));
                } else {
                    response.setException(new Exception("One or more nodes has not reported max resource id."));
                }
            }
            broker.sendApplicationMessageToNC((INcAddressedMessage)response, this.src);
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public String toString() {
        return ResourceIdRequestMessage.class.getSimpleName();
    }
}

