/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.builders.UnorderedListBuilder;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.functions.IFunctionTypeInferer;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.functions.FunctionTypeInferers;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class UnorderedListConstructorDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new UnorderedListConstructorDescriptor();
        }

        public IFunctionTypeInferer createFunctionTypeInferer() {
            return FunctionTypeInferers.SET_EXPRESSION_TYPE;
        }
    };
    private static final long serialVersionUID = 1L;
    private AUnorderedListType ultype;

    public void setImmutableStates(Object ... states) {
        this.ultype = (AUnorderedListType)states[0];
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.UNORDERED_LIST_CONSTRUCTOR;
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(IScalarEvaluatorFactory[] args) {
        return new UnorderedListConstructorEvaluatorFactory(args, this.ultype);
    }

    private static class UnorderedListConstructorEvaluatorFactory
    implements IScalarEvaluatorFactory {
        private static final long serialVersionUID = 1L;
        private IScalarEvaluatorFactory[] args;
        private boolean selfDescList = false;
        private boolean homoList = false;
        private AUnorderedListType unorderedlistType;

        public UnorderedListConstructorEvaluatorFactory(IScalarEvaluatorFactory[] args, AUnorderedListType type) {
            this.args = args;
            this.unorderedlistType = type;
            if (type == null || type.getItemType() == null || type.getItemType().getTypeTag() == ATypeTag.ANY) {
                this.selfDescList = true;
            } else {
                this.homoList = true;
            }
        }

        public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
            VoidPointable inputVal = new VoidPointable();
            final IScalarEvaluator[] argEvals = new IScalarEvaluator[this.args.length];
            for (int i = 0; i < this.args.length; ++i) {
                argEvals[i] = this.args[i].createScalarEvaluator(ctx);
            }
            return new IScalarEvaluator((IPointable)inputVal){
                private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                private DataOutput out = this.resultStorage.getDataOutput();
                private UnorderedListBuilder builder = new UnorderedListBuilder();
                final /* synthetic */ IPointable val$inputVal;
                {
                    this.val$inputVal = iPointable;
                }

                public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                    try {
                        this.builder.reset((AbstractCollectionType)unorderedlistType);
                        if (selfDescList) {
                            this.writeUntypedItems(tuple);
                        }
                        if (homoList) {
                            this.writeTypedItems(tuple);
                        }
                        this.resultStorage.reset();
                        this.builder.write(this.out, true);
                        result.set((IValueReference)this.resultStorage);
                    }
                    catch (IOException ioe) {
                        throw HyracksDataException.create((Throwable)ioe);
                    }
                }

                private void writeUntypedItems(IFrameTupleReference tuple) throws HyracksDataException {
                    try {
                        for (int i = 0; i < argEvals.length; ++i) {
                            argEvals[i].evaluate(tuple, this.val$inputVal);
                            this.builder.addItem((IValueReference)this.val$inputVal);
                        }
                    }
                    catch (IOException ioe) {
                        throw HyracksDataException.create((Throwable)ioe);
                    }
                }

                private void writeTypedItems(IFrameTupleReference tuple) throws HyracksDataException {
                    try {
                        for (int i = 0; i < argEvals.length; ++i) {
                            argEvals[i].evaluate(tuple, this.val$inputVal);
                            this.builder.addItem((IValueReference)this.val$inputVal);
                        }
                    }
                    catch (IOException ioe) {
                        throw HyracksDataException.create((Throwable)ioe);
                    }
                }
            };
        }
    }
}

