/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.Collection;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class PushProjectIntoDataSourceScanRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getInputs().size() <= 0) {
            return false;
        }
        AbstractLogicalOperator project = (AbstractLogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        if (project.getOperatorTag() != LogicalOperatorTag.PROJECT) {
            return false;
        }
        AbstractLogicalOperator exchange = (AbstractLogicalOperator)((Mutable)project.getInputs().get(0)).getValue();
        if (exchange.getOperatorTag() != LogicalOperatorTag.EXCHANGE) {
            return false;
        }
        AbstractLogicalOperator inputOp = (AbstractLogicalOperator)((Mutable)exchange.getInputs().get(0)).getValue();
        if (inputOp.getOperatorTag() != LogicalOperatorTag.DATASOURCESCAN) {
            return false;
        }
        DataSourceScanOperator scanOp = (DataSourceScanOperator)inputOp;
        ProjectOperator projectOp = (ProjectOperator)project;
        scanOp.addProjectVariables((Collection)projectOp.getVariables());
        if (op.getOperatorTag() != LogicalOperatorTag.EXCHANGE) {
            op.getInputs().set(0, project.getInputs().get(0));
        } else {
            op.getInputs().set(0, exchange.getInputs().get(0));
        }
        return true;
    }
}

