/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.dataflow;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class EnforceFrameWriter
implements IFrameWriter {
    private final IFrameWriter writer;
    private boolean downstreamFailed = false;
    private boolean failCalledByUpstream = false;
    private boolean downstreamOpen = false;

    protected EnforceFrameWriter(IFrameWriter writer) {
        this.writer = writer;
    }

    @Override
    public final void open() throws HyracksDataException {
        try {
            if (this.downstreamOpen) {
                throw HyracksDataException.create(59, new Serializable[0]);
            }
            if (this.downstreamFailed || this.failCalledByUpstream) {
                throw HyracksDataException.create(60, new Serializable[0]);
            }
            this.writer.open();
            this.downstreamOpen = true;
        }
        catch (Throwable th) {
            this.downstreamFailed = true;
            throw th;
        }
    }

    @Override
    public final void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        if (!this.downstreamOpen) {
            throw HyracksDataException.create(62, new Serializable[0]);
        }
        if (this.downstreamFailed || this.failCalledByUpstream) {
            throw HyracksDataException.create(61, new Serializable[0]);
        }
        try {
            this.writer.nextFrame(buffer);
        }
        catch (Throwable th) {
            this.downstreamFailed = true;
            throw th;
        }
    }

    @Override
    public final void flush() throws HyracksDataException {
        if (!this.downstreamOpen) {
            throw HyracksDataException.create(64, new Serializable[0]);
        }
        if (this.downstreamFailed || this.failCalledByUpstream) {
            throw HyracksDataException.create(63, new Serializable[0]);
        }
        try {
            this.writer.flush();
        }
        catch (Throwable th) {
            this.downstreamFailed = true;
            throw th;
        }
    }

    @Override
    public final void fail() throws HyracksDataException {
        this.writer.fail();
        if (this.failCalledByUpstream) {
            throw HyracksDataException.create(65, new Serializable[0]);
        }
        this.failCalledByUpstream = true;
    }

    @Override
    public void close() throws HyracksDataException {
        if (this.downstreamFailed && !this.failCalledByUpstream) {
            throw HyracksDataException.create(66, new Serializable[0]);
        }
        this.writer.close();
        this.downstreamOpen = false;
    }

    public static IFrameWriter enforce(IFrameWriter writer) {
        return writer instanceof EnforceFrameWriter ? writer : new EnforceFrameWriter(writer);
    }
}

