/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.win;

import java.nio.ByteBuffer;
import org.apache.hyracks.algebricks.runtime.base.IRunningAggregateEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.operators.win.AbstractWindowNestedPlansPushRuntime;
import org.apache.hyracks.algebricks.runtime.operators.win.WindowAggregatorDescriptorFactory;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.utils.TupleUtils;

class WindowNestedPlansUnboundedPushRuntime
extends AbstractWindowNestedPlansPushRuntime {
    private ArrayTupleBuilder nestedAggOutputBuilder;
    private final int frameMaxObjects;
    private int toWrite;

    WindowNestedPlansUnboundedPushRuntime(int[] partitionColumns, IBinaryComparatorFactory[] partitionComparatorFactories, IBinaryComparatorFactory[] orderComparatorFactories, int frameMaxObjects, int[] projectionColumns, int[] runningAggOutColumns, IRunningAggregateEvaluatorFactory[] runningAggFactories, int nestedAggOutSchemaSize, WindowAggregatorDescriptorFactory nestedAggFactory, IHyracksTaskContext ctx, int memSizeInFrames, SourceLocation sourceLoc) {
        super(partitionColumns, partitionComparatorFactories, orderComparatorFactories, projectionColumns, runningAggOutColumns, runningAggFactories, nestedAggOutSchemaSize, nestedAggFactory, ctx, memSizeInFrames, sourceLoc);
        this.frameMaxObjects = frameMaxObjects;
    }

    @Override
    protected void init() throws HyracksDataException {
        super.init();
        this.nestedAggOutputBuilder = new ArrayTupleBuilder(this.nestedAggOutSchemaSize);
    }

    @Override
    protected void beginPartitionImpl() throws HyracksDataException {
        super.beginPartitionImpl();
        this.nestedAggInit();
        this.nestedAggOutputBuilder.reset();
        this.toWrite = this.frameMaxObjects;
    }

    @Override
    protected void partitionChunkImpl(long frameId, ByteBuffer frameBuffer, int tBeginIdx, int tEndIdx) throws HyracksDataException {
        super.partitionChunkImpl(frameId, frameBuffer, tBeginIdx, tEndIdx);
        this.tAccess.reset(frameBuffer);
        for (int t = tBeginIdx; t <= tEndIdx && this.toWrite != 0; ++t) {
            this.nestedAggAggregate(this.tAccess, t);
            if (this.toWrite <= 0) continue;
            --this.toWrite;
        }
    }

    @Override
    protected void endPartitionImpl() throws HyracksDataException {
        this.nestedAggOutputFinalResult(this.nestedAggOutputBuilder);
        super.endPartitionImpl();
    }

    @Override
    protected void produceTuple(ArrayTupleBuilder tb, IFrameTupleAccessor accessor, int tIndex, FrameTupleReference tupleRef) throws HyracksDataException {
        super.produceTuple(tb, accessor, tIndex, tupleRef);
        TupleUtils.addFields((ArrayTupleBuilder)this.nestedAggOutputBuilder, (ArrayTupleBuilder)tb);
    }
}

