/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.resource;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.arns.Arn;
import software.amazon.awssdk.services.s3.internal.resource.ArnConverter;
import software.amazon.awssdk.services.s3.internal.resource.S3AccessPointResource;
import software.amazon.awssdk.services.s3.internal.resource.S3BucketResource;
import software.amazon.awssdk.services.s3.internal.resource.S3ObjectResource;
import software.amazon.awssdk.services.s3.internal.resource.S3Resource;
import software.amazon.awssdk.services.s3.internal.resource.S3ResourceType;

@SdkInternalApi
public final class S3ArnConverter
implements ArnConverter<S3Resource> {
    private static final S3ArnConverter INSTANCE = new S3ArnConverter();

    private S3ArnConverter() {
    }

    public static S3ArnConverter create() {
        return INSTANCE;
    }

    @Override
    public S3Resource convertArn(Arn arn) {
        S3ResourceType s3ResourceType;
        Arn v2Arn = this.convertToV2Arn(arn);
        if (!v2Arn.resource().resourceType().isPresent()) {
            throw new IllegalArgumentException("Unknown ARN type");
        }
        try {
            s3ResourceType = S3ResourceType.fromValue((String)v2Arn.resource().resourceType().get());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown ARN type '" + (String)v2Arn.resource().resourceType().get() + "'");
        }
        switch (s3ResourceType) {
            case OBJECT: {
                return this.parseS3ObjectArn(v2Arn);
            }
            case ACCESS_POINT: {
                return this.parseS3AccessPointArn(v2Arn);
            }
            case BUCKET: {
                return this.parseS3BucketArn(v2Arn);
            }
        }
        throw new IllegalArgumentException("Unknown ARN type '" + (Object)((Object)s3ResourceType) + "'");
    }

    private Arn convertToV2Arn(Arn arn) {
        if (!this.isV1Arn(arn)) {
            return arn;
        }
        String resource = arn.resourceAsString();
        if (resource.contains("/")) {
            return arn.toBuilder().resource("object:" + arn.resourceAsString()).build();
        }
        return arn.toBuilder().resource("bucket_name:" + arn.resourceAsString()).build();
    }

    private S3BucketResource parseS3BucketArn(Arn arn) {
        return S3BucketResource.builder().partition(arn.partition()).region(arn.region().orElse(null)).accountId(arn.accountId().orElse(null)).bucketName(arn.resource().resource()).build();
    }

    private S3AccessPointResource parseS3AccessPointArn(Arn arn) {
        return S3AccessPointResource.builder().partition(arn.partition()).region(arn.region().orElse(null)).accountId(arn.accountId().orElse(null)).accessPointName(arn.resource().resource()).build();
    }

    private S3ObjectResource parseS3ObjectArn(Arn arn) {
        String resourceString = arn.resource().resource();
        String[] splitResourceString = resourceString.split("/");
        if (splitResourceString.length < 2) {
            throw new IllegalArgumentException("Invalid format for S3 object resource ARN");
        }
        String bucketName = splitResourceString[0];
        String key = splitResourceString[1];
        return S3ObjectResource.builder().partition(arn.partition()).region(arn.region().orElse(null)).accountId(arn.accountId().orElse(null)).bucketName(bucketName).key(key).build();
    }

    private boolean isV1Arn(Arn arn) {
        return !arn.accountId().isPresent() && !arn.region().isPresent();
    }
}

