"""
    Airflow API

    Airflow API. All endpoints located under ``/api/v2`` can be used safely, are stable and backward compatible. Endpoints located under ``/ui`` are dedicated to the UI and are subject to breaking change depending on the need of the frontend. Users should not rely on those but use the public ones instead.

    The version of the OpenAPI document: 2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""
from __future__ import annotations
import pprint
import re
import json
from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class TriggerDAGRunPostBody(BaseModel):
    """
    Trigger DAG Run Serializer for POST body.
    """
    conf: Optional[Dict[str, Any]] = None
    dag_run_id: Optional[StrictStr] = None
    data_interval_end: Optional[datetime] = None
    data_interval_start: Optional[datetime] = None
    logical_date: Optional[datetime] = None
    note: Optional[StrictStr] = None
    run_after: Optional[datetime] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ['conf', 'dag_run_id', 'data_interval_end', 'data_interval_start', 'logical_date', 'note', 'run_after']
    model_config = ConfigDict(populate_by_name=True, validate_assignment=True, protected_namespaces=())

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TriggerDAGRunPostBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set(['additional_properties'])
        _dict = self.model_dump(by_alias=True, exclude=excluded_fields, exclude_none=True)
        if 'logical_date' not in _dict:
            _dict['logical_date'] = None
        if self.additional_properties is not None:
            for (_key, _value) in self.additional_properties.items():
                _dict[_key] = _value
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TriggerDAGRunPostBody from a dict"""
        if obj is None:
            return None
        if not isinstance(obj, dict):
            return cls.model_validate(obj)
        _obj = cls.model_validate({'conf': obj.get('conf'), 'dag_run_id': obj.get('dag_run_id'), 'data_interval_end': obj.get('data_interval_end'), 'data_interval_start': obj.get('data_interval_start'), 'logical_date': obj.get('logical_date'), 'note': obj.get('note'), 'run_after': obj.get('run_after')})
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)
        return _obj